/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.spatial4j.core.shape.Shape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.builders.BaseLineStringBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class BasePolygonBuilder<E extends BasePolygonBuilder<E>>
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.POLYGON;
    protected Ring<E> shell;
    protected final ArrayList<BaseLineStringBuilder<?>> holes = new ArrayList();
    private static final Coordinate[][] EMPTY = new Coordinate[0][];

    private E thisRef() {
        return (E)this;
    }

    public E point(double longitude, double latitude) {
        this.shell.point(longitude, latitude);
        return this.thisRef();
    }

    public E point(Coordinate coordinate) {
        this.shell.point(coordinate);
        return this.thisRef();
    }

    public E points(Coordinate ... coordinates) {
        this.shell.points(coordinates);
        return this.thisRef();
    }

    public E hole(BaseLineStringBuilder<?> hole) {
        this.holes.add(hole);
        return this.thisRef();
    }

    public Ring<E> hole() {
        Ring<E> hole = new Ring<E>(this.thisRef());
        this.holes.add(hole);
        return hole;
    }

    public ShapeBuilder close() {
        return this.shell.close();
    }

    public Coordinate[][][] coordinates() {
        int numEdges = this.shell.points.size() - 1;
        for (int i = 0; i < this.holes.size(); ++i) {
            numEdges += this.holes.get((int)i).points.size() - 1;
        }
        ShapeBuilder.Edge[] edges = new ShapeBuilder.Edge[numEdges];
        ShapeBuilder.Edge[] holeComponents = new ShapeBuilder.Edge[this.holes.size()];
        int offset = BasePolygonBuilder.createEdges(0, true, this.shell, edges, 0);
        for (int i = 0; i < this.holes.size(); ++i) {
            int length = BasePolygonBuilder.createEdges(i + 1, false, this.holes.get(i), edges, offset);
            holeComponents[i] = edges[offset];
            offset += length;
        }
        int numHoles = holeComponents.length;
        numHoles = BasePolygonBuilder.merge(edges, 0, BasePolygonBuilder.intersections(180.0, edges), holeComponents, numHoles);
        numHoles = BasePolygonBuilder.merge(edges, 0, BasePolygonBuilder.intersections(-180.0, edges), holeComponents, numHoles);
        return BasePolygonBuilder.compose(edges, holeComponents, numHoles);
    }

    @Override
    public Shape build() {
        return this.jtsGeometry(this.buildGeometry(FACTORY, this.wrapdateline));
    }

    protected XContentBuilder coordinatesArray(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.shell.coordinatesToXcontent(builder, true);
        for (BaseLineStringBuilder<?> hole : this.holes) {
            hole.coordinatesToXcontent(builder, true);
        }
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", BasePolygonBuilder.TYPE.shapename);
        builder.startArray("coordinates");
        this.coordinatesArray(builder, params);
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public Geometry buildGeometry(GeometryFactory factory, boolean fixDateline) {
        if (fixDateline) {
            Coordinate[][][] polygons = this.coordinates();
            return polygons.length == 1 ? BasePolygonBuilder.polygon(factory, polygons[0]) : BasePolygonBuilder.multipolygon(factory, polygons);
        }
        return this.toPolygon(factory);
    }

    public Polygon toPolygon() {
        return this.toPolygon(FACTORY);
    }

    protected Polygon toPolygon(GeometryFactory factory) {
        LinearRing shell = BasePolygonBuilder.linearRing(factory, this.shell.points);
        LinearRing[] holes = new LinearRing[this.holes.size()];
        Iterator<BaseLineStringBuilder<?>> iterator = this.holes.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            holes[i] = BasePolygonBuilder.linearRing(factory, iterator.next().points);
            ++i;
        }
        return factory.createPolygon(shell, holes);
    }

    protected static LinearRing linearRing(GeometryFactory factory, ArrayList<Coordinate> coordinates) {
        return factory.createLinearRing(coordinates.toArray(new Coordinate[coordinates.size()]));
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    protected static Polygon polygon(GeometryFactory factory, Coordinate[][] polygon) {
        LinearRing[] holes;
        LinearRing shell = factory.createLinearRing(polygon[0]);
        if (polygon.length > 1) {
            holes = new LinearRing[polygon.length - 1];
            for (int i = 0; i < holes.length; ++i) {
                holes[i] = factory.createLinearRing(polygon[i + 1]);
            }
        } else {
            holes = null;
        }
        return factory.createPolygon(shell, holes);
    }

    protected static MultiPolygon multipolygon(GeometryFactory factory, Coordinate[][][] polygons) {
        Polygon[] polygonSet = new Polygon[polygons.length];
        for (int i = 0; i < polygonSet.length; ++i) {
            polygonSet[i] = BasePolygonBuilder.polygon(factory, polygons[i]);
        }
        return factory.createMultiPolygon(polygonSet);
    }

    private static int component(ShapeBuilder.Edge edge, int id, ArrayList<ShapeBuilder.Edge> edges) {
        double shift;
        ShapeBuilder.Edge any = edge;
        while ((any.coordinate.x == 180.0 || any.coordinate.x == -180.0) && (any = any.next) != edge) {
        }
        double d = any.coordinate.x > 180.0 ? 180.0 : (shift = any.coordinate.x < -180.0 ? -180.0 : 0.0);
        if (BasePolygonBuilder.debugEnabled()) {
            LOGGER.debug("shift: {[]}", shift);
        }
        int length = 0;
        ShapeBuilder.Edge current = edge;
        do {
            current.coordinate = BasePolygonBuilder.shift(current.coordinate, shift);
            current.component = id;
            if (edges != null) {
                edges.add(current);
            }
            ++length;
        } while ((current = current.next) != edge);
        return length;
    }

    private static Coordinate[] coordinates(ShapeBuilder.Edge component, Coordinate[] coordinates) {
        for (int i = 0; i < coordinates.length; ++i) {
            component = component.next;
            coordinates[i] = component.coordinate;
        }
        return coordinates;
    }

    private static Coordinate[][][] buildCoordinates(ArrayList<ArrayList<Coordinate[]>> components) {
        int i;
        Coordinate[][][] result = new Coordinate[components.size()][][];
        for (i = 0; i < result.length; ++i) {
            ArrayList<Coordinate[]> component = components.get(i);
            result[i] = (Coordinate[][])component.toArray((T[])new Coordinate[component.size()][]);
        }
        if (BasePolygonBuilder.debugEnabled()) {
            for (i = 0; i < result.length; ++i) {
                LOGGER.debug("Component {[]}:", i);
                for (int j = 0; j < result[i].length; ++j) {
                    LOGGER.debug("\t" + Arrays.toString(result[i][j]), new Object[0]);
                }
            }
        }
        return result;
    }

    private static Coordinate[][] holes(ShapeBuilder.Edge[] holes, int numHoles) {
        if (numHoles == 0) {
            return EMPTY;
        }
        Coordinate[][] points = new Coordinate[numHoles][];
        for (int i = 0; i < numHoles; ++i) {
            int length = BasePolygonBuilder.component(holes[i], -(i + 1), null);
            points[i] = BasePolygonBuilder.coordinates(holes[i], new Coordinate[length + 1]);
        }
        return points;
    }

    private static ShapeBuilder.Edge[] edges(ShapeBuilder.Edge[] edges, int numHoles, ArrayList<ArrayList<Coordinate[]>> components) {
        ArrayList<ShapeBuilder.Edge> mainEdges = new ArrayList<ShapeBuilder.Edge>(edges.length);
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i].component < 0) continue;
            int length = BasePolygonBuilder.component(edges[i], -(components.size() + numHoles + 1), mainEdges);
            ArrayList<Coordinate[]> component = new ArrayList<Coordinate[]>();
            component.add(BasePolygonBuilder.coordinates(edges[i], new Coordinate[length + 1]));
            components.add(component);
        }
        return mainEdges.toArray(new ShapeBuilder.Edge[mainEdges.size()]);
    }

    private static Coordinate[][][] compose(ShapeBuilder.Edge[] edges, ShapeBuilder.Edge[] holes, int numHoles) {
        ArrayList<ArrayList<Coordinate[]>> components = new ArrayList<ArrayList<Coordinate[]>>();
        BasePolygonBuilder.assign(holes, BasePolygonBuilder.holes(holes, numHoles), numHoles, BasePolygonBuilder.edges(edges, numHoles, components), components);
        return BasePolygonBuilder.buildCoordinates(components);
    }

    private static void assign(ShapeBuilder.Edge[] holes, Coordinate[][] points, int numHoles, ShapeBuilder.Edge[] edges, ArrayList<ArrayList<Coordinate[]>> components) {
        if (BasePolygonBuilder.debugEnabled()) {
            LOGGER.debug("Holes: " + Arrays.toString(holes), new Object[0]);
        }
        for (int i = 0; i < numHoles; ++i) {
            ShapeBuilder.Edge current = new ShapeBuilder.Edge(holes[i].coordinate, holes[i].next);
            current.intersect = current.coordinate;
            int intersections = BasePolygonBuilder.intersections(current.coordinate.x, edges);
            int pos = Arrays.binarySearch(edges, 0, intersections, current, INTERSECTION_ORDER);
            if (pos >= 0) {
                throw new ElasticsearchParseException("Invaild shape: Hole is not within polygon");
            }
            int index = -(pos + 2);
            int component = -edges[index].component - numHoles - 1;
            if (BasePolygonBuilder.debugEnabled()) {
                LOGGER.debug("\tposition (" + index + ") of edge " + current + ": " + edges[index], new Object[0]);
                LOGGER.debug("\tComponent: " + component, new Object[0]);
                LOGGER.debug("\tHole intersections (" + current.coordinate.x + "): " + Arrays.toString(edges), new Object[0]);
            }
            components.get(component).add(points[i]);
        }
    }

    private static int merge(ShapeBuilder.Edge[] intersections, int offset, int length, ShapeBuilder.Edge[] holes, int numHoles) {
        for (int i = 0; i < length; i += 2) {
            ShapeBuilder.Edge e1 = intersections[offset + i + 0];
            ShapeBuilder.Edge e2 = intersections[offset + i + 1];
            if (e2.component > 0) {
                holes[e2.component - 1] = holes[--numHoles];
                holes[numHoles] = null;
            }
            if (e1.intersect == ShapeBuilder.Edge.MAX_COORDINATE || e2.intersect == ShapeBuilder.Edge.MAX_COORDINATE) continue;
            BasePolygonBuilder.connect(e1, e2);
        }
        return numHoles;
    }

    private static void connect(ShapeBuilder.Edge in, ShapeBuilder.Edge out) {
        assert (in != null && out != null);
        assert (in != out);
        if (in.intersect != in.next.coordinate) {
            ShapeBuilder.Edge e1 = new ShapeBuilder.Edge(in.intersect, in.next);
            if (out.intersect != out.next.coordinate) {
                ShapeBuilder.Edge e2 = new ShapeBuilder.Edge(out.intersect, out.next);
                in.next = new ShapeBuilder.Edge(in.intersect, e2, in.intersect);
            } else {
                in.next = new ShapeBuilder.Edge(in.intersect, out.next, in.intersect);
            }
            out.next = new ShapeBuilder.Edge(out.intersect, e1, out.intersect);
        } else if (in.next != out) {
            ShapeBuilder.Edge e2 = new ShapeBuilder.Edge(out.intersect, in.next, out.intersect);
            if (out.intersect != out.next.coordinate) {
                ShapeBuilder.Edge e1 = new ShapeBuilder.Edge(out.intersect, out.next);
                in.next = new ShapeBuilder.Edge(in.intersect, e1, in.intersect);
            } else {
                in.next = new ShapeBuilder.Edge(in.intersect, out.next, in.intersect);
            }
            out.next = e2;
        }
    }

    private static int createEdges(int component, boolean direction, BaseLineStringBuilder<?> line, ShapeBuilder.Edge[] edges, int offset) {
        Coordinate[] points = line.coordinates(false);
        ShapeBuilder.Edge.ring(component, direction, points, 0, edges, offset, points.length - 1);
        return points.length - 1;
    }

    public static class Ring<P extends ShapeBuilder>
    extends BaseLineStringBuilder<Ring<P>> {
        private final P parent;

        protected Ring(P parent) {
            this(parent, new ArrayList<Coordinate>());
        }

        protected Ring(P parent, ArrayList<Coordinate> points) {
            super(points);
            this.parent = parent;
        }

        public P close() {
            Coordinate start = (Coordinate)this.points.get(0);
            Coordinate end = (Coordinate)this.points.get(this.points.size() - 1);
            if (start.x != end.x || start.y != end.y) {
                this.points.add(start);
            }
            return this.parent;
        }

        @Override
        public ShapeBuilder.GeoShapeType type() {
            return null;
        }
    }
}

