/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportShardReplicationOperationAction<Request extends ShardReplicationOperationRequest, ReplicaRequest extends ShardReplicationOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    protected final IndicesService indicesService;
    protected final ShardStateAction shardStateAction;
    protected final ReplicationType defaultReplicationType;
    protected final WriteConsistencyLevel defaultWriteConsistencyLevel;
    protected final TransportRequestOptions transportOptions;
    final String transportReplicaAction;
    final String executor;
    final boolean checkWriteConsistency;

    protected TransportShardReplicationOperationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, actionName, threadPool, actionFilters);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.shardStateAction = shardStateAction;
        this.transportReplicaAction = actionName + "[r]";
        this.executor = this.executor();
        this.checkWriteConsistency = this.checkWriteConsistency();
        transportService.registerHandler(actionName, new OperationTransportHandler());
        transportService.registerHandler(this.transportReplicaAction, new ReplicaOperationTransportHandler());
        this.transportOptions = this.transportOptions();
        this.defaultReplicationType = ReplicationType.fromString(settings.get("action.replication_type", "sync"));
        this.defaultWriteConsistencyLevel = WriteConsistencyLevel.fromString(settings.get("action.write_consistency", "quorum"));
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncShardOperationAction(this, request, listener).start();
    }

    protected abstract Request newRequestInstance();

    protected abstract ReplicaRequest newReplicaRequestInstance();

    protected abstract Response newResponseInstance();

    protected abstract String executor();

    protected abstract PrimaryResponse<Response, ReplicaRequest> shardOperationOnPrimary(ClusterState var1, PrimaryOperationRequest var2);

    protected abstract void shardOperationOnReplica(ReplicaOperationRequest var1);

    protected void postPrimaryOperation(InternalRequest request, PrimaryResponse<Response, ReplicaRequest> response) {
    }

    protected abstract ShardIterator shards(ClusterState var1, InternalRequest var2) throws ElasticsearchException;

    protected abstract boolean checkWriteConsistency();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.concreteIndex());
    }

    protected abstract boolean resolveIndex();

    protected boolean resolveRequest(ClusterState state, InternalRequest request, ActionListener<Response> listener) {
        return true;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected boolean ignoreReplicas() {
        return false;
    }

    protected boolean retryPrimaryException(Throwable e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    protected boolean ignoreReplicaException(Throwable e) {
        if (TransportActions.isShardNotAvailableException(e)) {
            return true;
        }
        return this.isConflictException(e);
    }

    protected boolean isConflictException(Throwable e) {
        Throwable cause = ExceptionsHelper.unwrapCause(e);
        if (cause instanceof VersionConflictEngineException) {
            return true;
        }
        return cause instanceof DocumentAlreadyExistsException;
    }

    private void failReplicaIfNeeded(String index, int shardId, Throwable t) {
        this.logger.trace("failure on replica [{}][{}]", t, index, shardId);
        if (!this.ignoreReplicaException(t)) {
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                this.logger.debug("ignoring failed replica [{}][{}] because index was already removed.", index, shardId);
                return;
            }
            IndexShard indexShard = indexService.shard(shardId);
            if (indexShard == null) {
                this.logger.debug("ignoring failed replica [{}][{}] because index was already removed.", index, shardId);
                return;
            }
            indexShard.failShard(this.actionName + " failed on replica", t);
        }
    }

    protected static class InternalRequest {
        final Request request;
        String concreteIndex;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        InternalRequest(Request request) {
            this.this$0 = var1_1;
            this.request = request;
        }

        public Request request() {
            return this.request;
        }

        void concreteIndex(String concreteIndex) {
            this.concreteIndex = concreteIndex;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }

    public static class PrimaryResponse<Response, ReplicaRequest> {
        private final ReplicaRequest replicaRequest;
        private final Response response;
        private final Object payload;

        public PrimaryResponse(ReplicaRequest replicaRequest, Response response, Object payload) {
            this.replicaRequest = replicaRequest;
            this.response = response;
            this.payload = payload;
        }

        public ReplicaRequest replicaRequest() {
            return this.replicaRequest;
        }

        public Response response() {
            return this.response;
        }

        public Object payload() {
            return this.payload;
        }
    }

    protected static class AsyncShardOperationAction {
        private final ActionListener<Response> listener;
        private final InternalRequest internalRequest;
        private volatile ShardIterator shardIt;
        private final AtomicBoolean primaryOperationStarted = new AtomicBoolean();
        private final ReplicationType replicationType;
        private volatile ClusterStateObserver observer;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        AsyncShardOperationAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.internalRequest = new InternalRequest((TransportShardReplicationOperationAction)var1_1, request);
            this.listener = listener;
            this.replicationType = ((ShardReplicationOperationRequest)request).replicationType() != ReplicationType.DEFAULT ? ((ShardReplicationOperationRequest)request).replicationType() : var1_1.defaultReplicationType;
        }

        public void start() {
            this.observer = new ClusterStateObserver(this.this$0.clusterService, ((ShardReplicationOperationRequest)this.internalRequest.request()).timeout(), this.this$0.logger);
            this.doStart();
        }

        protected void doStart() throws ElasticsearchException {
            ShardRouting shardX;
            try {
                ClusterBlockException blockException = this.this$0.checkGlobalBlock(this.observer.observedState());
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.this$0.logger.trace("cluster is blocked ({}), scheduling a retry", blockException.getMessage());
                        this.retry(blockException);
                        return;
                    }
                    throw blockException;
                }
                if (this.this$0.resolveIndex()) {
                    this.internalRequest.concreteIndex(this.observer.observedState().metaData().concreteSingleIndex(((ShardReplicationOperationRequest)this.internalRequest.request()).index(), ((ShardReplicationOperationRequest)this.internalRequest.request()).indicesOptions()));
                } else {
                    this.internalRequest.concreteIndex(((ShardReplicationOperationRequest)this.internalRequest.request()).index());
                }
                if (!this.this$0.resolveRequest(this.observer.observedState(), this.internalRequest, this.listener)) {
                    return;
                }
                blockException = this.this$0.checkRequestBlock(this.observer.observedState(), this.internalRequest);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.this$0.logger.trace("cluster is blocked ({}), scheduling a retry", blockException.getMessage());
                        this.retry(blockException);
                        return;
                    }
                    throw blockException;
                }
                this.shardIt = this.this$0.shards(this.observer.observedState(), this.internalRequest);
            }
            catch (Throwable e) {
                this.listener.onFailure(e);
                return;
            }
            if (this.shardIt.size() == 0) {
                this.this$0.logger.trace("no shard instances known for shard [{}], scheduling a retry", this.shardIt.shardId());
                this.retryBecauseUnavailable(this.shardIt.shardId(), "No active shards.");
                return;
            }
            boolean foundPrimary = false;
            while ((shardX = this.shardIt.nextOrNull()) != null) {
                final ShardRouting shard = shardX;
                if (!shard.primary()) continue;
                if (!shard.active() || !this.observer.observedState().nodes().nodeExists(shard.currentNodeId())) {
                    this.this$0.logger.trace("primary shard [{}] is not yet active or we do not know the node it is assigned to [{}], scheduling a retry.", shard.shardId(), shard.currentNodeId());
                    this.retryBecauseUnavailable(this.shardIt.shardId(), "Primary shard is not active or isn't assigned is a known node.");
                    return;
                }
                if (!this.primaryOperationStarted.compareAndSet(false, true)) {
                    return;
                }
                foundPrimary = true;
                if (shard.currentNodeId().equals(this.observer.observedState().nodes().localNodeId())) {
                    try {
                        if (((ShardReplicationOperationRequest)this.internalRequest.request()).operationThreaded()) {
                            ((ShardReplicationOperationRequest)this.internalRequest.request()).beforeLocalFork();
                            this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        AsyncShardOperationAction.this.performOnPrimary(shard.id(), shard);
                                    }
                                    catch (Throwable t) {
                                        AsyncShardOperationAction.this.listener.onFailure(t);
                                    }
                                }
                            });
                            break;
                        }
                        this.performOnPrimary(shard.id(), shard);
                    }
                    catch (Throwable t) {
                        this.listener.onFailure(t);
                    }
                    break;
                }
                DiscoveryNode node = this.observer.observedState().nodes().get(shard.currentNodeId());
                this.this$0.transportService.sendRequest(node, this.this$0.actionName, (TransportRequest)this.internalRequest.request(), this.this$0.transportOptions, new BaseTransportResponseHandler<Response>(){

                    @Override
                    public Response newInstance() {
                        return AsyncShardOperationAction.this.this$0.newResponseInstance();
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncShardOperationAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        if (exp.unwrapCause() instanceof ConnectTransportException || exp.unwrapCause() instanceof NodeClosedException || AsyncShardOperationAction.this.this$0.retryPrimaryException(exp)) {
                            AsyncShardOperationAction.this.primaryOperationStarted.set(false);
                            AsyncShardOperationAction.this.this$0.logger.trace("received an error from node the primary was assigned to ({}), scheduling a retry", exp.getMessage());
                            AsyncShardOperationAction.this.retry(exp);
                        } else {
                            AsyncShardOperationAction.this.listener.onFailure(exp);
                        }
                    }
                });
                break;
            }
            if (!foundPrimary) {
                this.this$0.logger.trace("couldn't find a eligible primary shard, scheduling for retry.", new Object[0]);
                this.retryBecauseUnavailable(this.shardIt.shardId(), "No active shards.");
            }
        }

        void retry(Throwable failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.listener.onFailure(failure);
                return;
            }
            ((ShardReplicationOperationRequest)this.internalRequest.request()).beforeLocalFork();
            ((ShardReplicationOperationRequest)this.internalRequest.request()).operationThreaded(true);
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncShardOperationAction.this.doStart();
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncShardOperationAction.this.listener.onFailure(new NodeClosedException(AsyncShardOperationAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    AsyncShardOperationAction.this.doStart();
                }
            });
        }

        void performOnPrimary(int primaryShardId, ShardRouting shard) {
            ClusterState clusterState = this.observer.observedState();
            if (this.raiseFailureIfHaveNotEnoughActiveShardCopies(shard, clusterState)) {
                return;
            }
            try {
                PrimaryResponse response = this.this$0.shardOperationOnPrimary(clusterState, new PrimaryOperationRequest(this.this$0, primaryShardId, this.internalRequest.concreteIndex(), this.internalRequest.request()));
                this.performReplicas(response);
            }
            catch (Throwable e) {
                ((ShardReplicationOperationRequest)this.internalRequest.request).setCanHaveDuplicates();
                if (this.this$0.retryPrimaryException(e)) {
                    this.primaryOperationStarted.set(false);
                    this.this$0.logger.trace("had an error while performing operation on primary ({}), scheduling a retry.", e.getMessage());
                    this.retry(e);
                    return;
                }
                if (e instanceof ElasticsearchException && ((ElasticsearchException)e).status() == RestStatus.CONFLICT) {
                    if (this.this$0.logger.isTraceEnabled()) {
                        this.this$0.logger.trace(shard.shortSummary() + ": Failed to execute [" + this.internalRequest.request() + "]", e, new Object[0]);
                    }
                } else if (this.this$0.logger.isDebugEnabled()) {
                    this.this$0.logger.debug(shard.shortSummary() + ": Failed to execute [" + this.internalRequest.request() + "]", e, new Object[0]);
                }
                this.listener.onFailure(e);
            }
        }

        void performReplicas(PrimaryResponse<Response, ReplicaRequest> response) {
            ShardRouting shard;
            if (this.this$0.ignoreReplicas()) {
                this.this$0.postPrimaryOperation(this.internalRequest, response);
                this.listener.onResponse(response.response());
                return;
            }
            ClusterState newState = this.this$0.clusterService.state();
            ShardRouting newPrimaryShard = null;
            if (this.observer.observedState() != newState) {
                this.shardIt.reset();
                ShardRouting originalPrimaryShard = null;
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (!shard.primary()) continue;
                    originalPrimaryShard = shard;
                    break;
                }
                if (originalPrimaryShard == null || !originalPrimaryShard.active()) {
                    throw new ElasticsearchIllegalStateException("unexpected state, failed to find primary shard on an index operation that succeeded");
                }
                this.observer.reset(newState);
                this.shardIt = this.this$0.shards(newState, this.internalRequest);
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (!shard.primary()) continue;
                    newPrimaryShard = originalPrimaryShard.currentNodeId().equals(shard.currentNodeId()) ? null : shard;
                    break;
                }
                this.shardIt.reset();
                ((ShardReplicationOperationRequest)this.internalRequest.request()).setCanHaveDuplicates();
            } else {
                this.shardIt.reset();
                while ((shard = this.shardIt.nextOrNull()) != null) {
                    if (shard.state() == ShardRoutingState.STARTED) continue;
                    ((ShardReplicationOperationRequest)this.internalRequest.request()).setCanHaveDuplicates();
                }
                this.shardIt.reset();
            }
            int replicaCounter = this.shardIt.assignedReplicasIncludingRelocating();
            if (newPrimaryShard != null) {
                ++replicaCounter;
            }
            if (replicaCounter == 0) {
                this.this$0.postPrimaryOperation(this.internalRequest, response);
                this.listener.onResponse(response.response());
                return;
            }
            if (this.replicationType == ReplicationType.ASYNC) {
                this.this$0.postPrimaryOperation(this.internalRequest, response);
                this.listener.onResponse(response.response());
                replicaCounter = Integer.MIN_VALUE;
            }
            AtomicInteger counter = new AtomicInteger(++replicaCounter);
            IndexMetaData indexMetaData = this.observer.observedState().metaData().index(this.internalRequest.concreteIndex());
            if (newPrimaryShard != null) {
                this.performOnReplica(response, counter, newPrimaryShard, newPrimaryShard.currentNodeId(), indexMetaData);
            }
            this.shardIt.reset();
            while ((shard = this.shardIt.nextOrNull()) != null) {
                if (shard.unassigned()) continue;
                boolean doOnlyOnRelocating = false;
                if (shard.primary()) {
                    if (!shard.relocating()) continue;
                    doOnlyOnRelocating = true;
                }
                if (!doOnlyOnRelocating) {
                    this.performOnReplica(response, counter, shard, shard.currentNodeId(), indexMetaData);
                }
                if (!shard.relocating()) continue;
                this.performOnReplica(response, counter, shard, shard.relocatingNodeId(), indexMetaData);
            }
            this.this$0.postPrimaryOperation(this.internalRequest, response);
            if (counter.decrementAndGet() == 0) {
                this.listener.onResponse(response.response());
            }
        }

        void performOnReplica(final PrimaryResponse<Response, ReplicaRequest> response, final AtomicInteger counter, final ShardRouting shard, String nodeId, final IndexMetaData indexMetaData) {
            block11: {
                if (!this.observer.observedState().nodes().nodeExists(nodeId)) {
                    if (counter.decrementAndGet() == 0) {
                        this.listener.onResponse(response.response());
                    }
                    return;
                }
                final ReplicaOperationRequest shardRequest = new ReplicaOperationRequest(this.this$0, this.shardIt.shardId(), (ShardReplicationOperationRequest)response.replicaRequest());
                if (!nodeId.equals(this.observer.observedState().nodes().localNodeId())) {
                    final DiscoveryNode node = this.observer.observedState().nodes().get(nodeId);
                    this.this$0.transportService.sendRequest(node, this.this$0.transportReplicaAction, shardRequest, this.this$0.transportOptions, new EmptyTransportResponseHandler("same"){

                        @Override
                        public void handleResponse(TransportResponse.Empty vResponse) {
                            this.finishIfPossible();
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            AsyncShardOperationAction.this.this$0.logger.trace("[{}] Transport failure during replica request [{}] ", exp, node, AsyncShardOperationAction.this.internalRequest.request());
                            if (!AsyncShardOperationAction.this.this$0.ignoreReplicaException(exp)) {
                                AsyncShardOperationAction.this.this$0.logger.warn("Failed to perform " + AsyncShardOperationAction.this.this$0.actionName + " on remote replica " + node + AsyncShardOperationAction.this.shardIt.shardId(), exp, new Object[0]);
                                AsyncShardOperationAction.this.this$0.shardStateAction.shardFailed(shard, indexMetaData.getUUID(), "Failed to perform [" + AsyncShardOperationAction.this.this$0.actionName + "] on replica, message [" + ExceptionsHelper.detailedMessage(exp) + "]");
                            }
                            this.finishIfPossible();
                        }

                        private void finishIfPossible() {
                            if (counter.decrementAndGet() == 0) {
                                AsyncShardOperationAction.this.listener.onResponse(response.response());
                            }
                        }
                    });
                } else {
                    if (((ShardReplicationOperationRequest)this.internalRequest.request()).operationThreaded()) {
                        ((ShardReplicationOperationRequest)this.internalRequest.request()).beforeLocalFork();
                        try {
                            this.this$0.threadPool.executor(this.this$0.executor).execute(new AbstractRunnable(){

                                @Override
                                public void run() {
                                    try {
                                        AsyncShardOperationAction.this.this$0.shardOperationOnReplica(shardRequest);
                                    }
                                    catch (Throwable e) {
                                        AsyncShardOperationAction.this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                                    }
                                    if (counter.decrementAndGet() == 0) {
                                        AsyncShardOperationAction.this.listener.onResponse(response.response());
                                    }
                                }

                                @Override
                                public boolean isForceExecution() {
                                    return true;
                                }
                            });
                        }
                        catch (Throwable e) {
                            this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                            if (counter.decrementAndGet() == 0) {
                                this.listener.onResponse(response.response());
                            }
                            break block11;
                        }
                    }
                    try {
                        this.this$0.shardOperationOnReplica(shardRequest);
                    }
                    catch (Throwable e) {
                        this.this$0.failReplicaIfNeeded(shard.index(), shard.id(), e);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.listener.onResponse(response.response());
                    }
                }
            }
        }

        boolean raiseFailureIfHaveNotEnoughActiveShardCopies(ShardRouting shard, ClusterState state) {
            int requiredNumber;
            int sizeActive;
            if (!this.this$0.checkWriteConsistency) {
                return false;
            }
            WriteConsistencyLevel consistencyLevel = ((ShardReplicationOperationRequest)this.internalRequest.request()).consistencyLevel() != WriteConsistencyLevel.DEFAULT ? ((ShardReplicationOperationRequest)this.internalRequest.request()).consistencyLevel() : this.this$0.defaultWriteConsistencyLevel;
            IndexRoutingTable indexRoutingTable = state.getRoutingTable().index(shard.index());
            if (indexRoutingTable != null) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(shard.getId());
                if (shardRoutingTable != null) {
                    sizeActive = shardRoutingTable.activeShards().size();
                    requiredNumber = consistencyLevel == WriteConsistencyLevel.QUORUM && shardRoutingTable.getSize() > 2 ? shardRoutingTable.getSize() / 2 + 1 : (consistencyLevel == WriteConsistencyLevel.ALL ? shardRoutingTable.getSize() : 1);
                } else {
                    sizeActive = 0;
                    requiredNumber = 1;
                }
            } else {
                sizeActive = 0;
                requiredNumber = 1;
            }
            if (sizeActive < requiredNumber) {
                this.this$0.logger.trace("not enough active copies of shard [{}] to meet write consistency of [{}] (have {}, needed {}), scheduling a retry.", new Object[]{shard.shardId(), consistencyLevel, sizeActive, requiredNumber});
                this.primaryOperationStarted.set(false);
                this.retryBecauseUnavailable(shard.shardId(), "Not enough active copies to meet write consistency of [" + (Object)((Object)consistencyLevel) + "] (have " + sizeActive + ", needed " + requiredNumber + ").");
                return true;
            }
            return false;
        }

        void retryBecauseUnavailable(ShardId shardId, String message) {
            this.retry(new UnavailableShardsException(shardId, message + " Timeout: [" + ((ShardReplicationOperationRequest)this.internalRequest.request()).timeout() + "], request: " + this.internalRequest.request().toString()));
        }
    }

    protected class ReplicaOperationRequest
    extends TransportRequest
    implements IndicesRequest {
        public ShardId shardId;
        public ReplicaRequest request;

        ReplicaOperationRequest() {
        }

        ReplicaOperationRequest(ShardId shardId, ReplicaRequest request) {
            super((TransportRequest)request);
            this.shardId = shardId;
            this.request = request;
        }

        @Override
        public String[] indices() {
            return ((ShardReplicationOperationRequest)this.request).indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return ((ShardReplicationOperationRequest)this.request).indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            int shard = -1;
            if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                this.shardId = ShardId.readShardId(in);
            } else {
                shard = in.readVInt();
            }
            this.request = TransportShardReplicationOperationAction.this.newReplicaRequestInstance();
            ((ShardReplicationOperationRequest)this.request).readFrom(in);
            if (in.getVersion().before(Version.V_1_4_0_Beta1)) {
                assert (shard >= 0);
                this.shardId = new ShardId(((ShardReplicationOperationRequest)this.request).index(), shard);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                this.shardId.writeTo(out);
            } else {
                out.writeVInt(this.shardId.id());
                ((ShardReplicationOperationRequest)this.request).index(this.shardId.getIndex());
            }
            ((ShardReplicationOperationRequest)this.request).writeTo(out);
        }
    }

    protected static class PrimaryOperationRequest {
        public ShardId shardId;
        public Request request;
        final /* synthetic */ TransportShardReplicationOperationAction this$0;

        public PrimaryOperationRequest(int shardId, String index, Request request) {
            this.this$0 = var1_1;
            this.shardId = new ShardId(index, shardId);
            this.request = request;
        }
    }

    class ReplicaOperationTransportHandler
    extends BaseTransportRequestHandler<ReplicaOperationRequest> {
        ReplicaOperationTransportHandler() {
        }

        @Override
        public ReplicaOperationRequest newInstance() {
            return new ReplicaOperationRequest();
        }

        @Override
        public String executor() {
            return TransportShardReplicationOperationAction.this.executor;
        }

        @Override
        public boolean isForceExecution() {
            return true;
        }

        @Override
        public void messageReceived(ReplicaOperationRequest request, TransportChannel channel) throws Exception {
            try {
                TransportShardReplicationOperationAction.this.shardOperationOnReplica(request);
            }
            catch (Throwable t) {
                TransportShardReplicationOperationAction.this.failReplicaIfNeeded(request.shardId.getIndex(), request.shardId.id(), t);
                throw t;
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class OperationTransportHandler
    extends BaseTransportRequestHandler<Request> {
        OperationTransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportShardReplicationOperationAction.this.newRequestInstance();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            ((ShardReplicationOperationRequest)request).operationThreaded(true);
            TransportShardReplicationOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Throwable e1) {
                        TransportShardReplicationOperationAction.this.logger.warn("Failed to send response for " + TransportShardReplicationOperationAction.this.actionName, e1, new Object[0]);
                    }
                }
            });
        }
    }
}

