/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.netty.NettyUtils;
import org.elasticsearch.common.netty.OpenChannelsHandler;
import org.elasticsearch.common.netty.ReleaseChannelFutureListener;
import org.elasticsearch.common.netty.bootstrap.ClientBootstrap;
import org.elasticsearch.common.netty.bootstrap.ServerBootstrap;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.ReceiveBufferSizePredictorFactory;
import org.elasticsearch.common.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.nio.NioWorkerPool;
import org.elasticsearch.common.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.elasticsearch.common.netty.util.HashedWheelTimer;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.netty.MessageChannelHandler;
import org.elasticsearch.transport.netty.NettyHeader;
import org.elasticsearch.transport.netty.SizeHeaderFrameDecoder;
import org.elasticsearch.transport.support.TransportStatus;

public class NettyTransport
extends AbstractLifecycleComponent<Transport>
implements Transport {
    public static final String WORKER_COUNT = "transport.netty.worker_count";
    public static final String CONNECTIONS_PER_NODE_RECOVERY = "transport.connections_per_node.recovery";
    public static final String CONNECTIONS_PER_NODE_BULK = "transport.connections_per_node.bulk";
    public static final String CONNECTIONS_PER_NODE_REG = "transport.connections_per_node.reg";
    public static final String CONNECTIONS_PER_NODE_STATE = "transport.connections_per_node.state";
    public static final String CONNECTIONS_PER_NODE_PING = "transport.connections_per_node.ping";
    private static final String DEFAULT_PORT_RANGE = "9300-9400";
    private final NetworkService networkService;
    final Version version;
    private final boolean blockingClient;
    private final TimeValue connectTimeout;
    private final ByteSizeValue maxCumulationBufferCapacity;
    private final int maxCompositeBufferComponents;
    final boolean compress;
    private final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    private final int workerCount;
    private final ByteSizeValue receivePredictorMin;
    private final ByteSizeValue receivePredictorMax;
    final int connectionsPerNodeRecovery;
    final int connectionsPerNodeBulk;
    final int connectionsPerNodeReg;
    final int connectionsPerNodeState;
    final int connectionsPerNodePing;
    final BigArrays bigArrays;
    private final ThreadPool threadPool;
    private volatile OpenChannelsHandler serverOpenChannels;
    private volatile ClientBootstrap clientBootstrap;
    final ConcurrentMap<DiscoveryNode, NodeChannels> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();
    private final Map<String, Channel> serverChannels = ConcurrentCollections.newConcurrentMap();
    private volatile TransportServiceAdapter transportServiceAdapter;
    private volatile BoundTransportAddress boundAddress;
    private final KeyedLock<String> connectionLock = new KeyedLock();
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();

    @Inject
    public NettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, Version version) {
        super(settings);
        this.threadPool = threadPool;
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.version = version;
        if (settings.getAsBoolean("netty.epollBugWorkaround", (Boolean)false).booleanValue()) {
            System.setProperty("org.elasticsearch.common.netty.epollBugWorkaround", "true");
        }
        this.workerCount = settings.getAsInt(WORKER_COUNT, (Integer)(EsExecutors.boundedNumberOfProcessors(settings) * 2));
        this.blockingClient = settings.getAsBoolean("transport.tcp.blocking_client", settings.getAsBoolean("network.tcp.blocking_client", settings.getAsBoolean("network.tcp.blocking", (Boolean)false)));
        this.connectTimeout = this.componentSettings.getAsTime("connect_timeout", settings.getAsTime("transport.tcp.connect_timeout", settings.getAsTime("network.tcp.connect_timeout", NetworkService.TcpSettings.TCP_DEFAULT_CONNECT_TIMEOUT)));
        this.maxCumulationBufferCapacity = this.componentSettings.getAsBytesSize("max_cumulation_buffer_capacity", null);
        this.maxCompositeBufferComponents = this.componentSettings.getAsInt("max_composite_buffer_components", (Integer)-1);
        this.compress = settings.getAsBoolean("transport.tcp.compress", (Boolean)false);
        this.connectionsPerNodeRecovery = this.componentSettings.getAsInt("connections_per_node.recovery", settings.getAsInt(CONNECTIONS_PER_NODE_RECOVERY, (Integer)2));
        this.connectionsPerNodeBulk = this.componentSettings.getAsInt("connections_per_node.bulk", settings.getAsInt(CONNECTIONS_PER_NODE_BULK, (Integer)3));
        this.connectionsPerNodeReg = this.componentSettings.getAsInt("connections_per_node.reg", settings.getAsInt(CONNECTIONS_PER_NODE_REG, (Integer)6));
        this.connectionsPerNodeState = this.componentSettings.getAsInt("connections_per_node.high", settings.getAsInt(CONNECTIONS_PER_NODE_STATE, (Integer)1));
        this.connectionsPerNodePing = this.componentSettings.getAsInt("connections_per_node.ping", settings.getAsInt(CONNECTIONS_PER_NODE_PING, (Integer)1));
        if (this.connectionsPerNodeReg == 0) {
            throw new ElasticsearchIllegalArgumentException("can't set [connection_per_node.reg] to 0");
        }
        if (this.connectionsPerNodePing == 0) {
            throw new ElasticsearchIllegalArgumentException("can't set [connection_per_node.ping] to 0");
        }
        if (this.connectionsPerNodeState == 0) {
            throw new ElasticsearchIllegalArgumentException("can't set [connection_per_node.state] to 0");
        }
        long defaultReceiverPredictor = 524288L;
        if (JvmInfo.jvmInfo().mem().directMemoryMax().bytes() > 0L) {
            long l = (long)(0.3 * (double)JvmInfo.jvmInfo().mem().directMemoryMax().bytes() / (double)this.workerCount);
            defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
        }
        this.receivePredictorMin = this.componentSettings.getAsBytesSize("receive_predictor_min", this.componentSettings.getAsBytesSize("receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        this.receivePredictorMax = this.componentSettings.getAsBytesSize("receive_predictor_max", this.componentSettings.getAsBytesSize("receive_predictor_size", new ByteSizeValue(defaultReceiverPredictor)));
        this.receiveBufferSizePredictorFactory = this.receivePredictorMax.bytes() == this.receivePredictorMin.bytes() ? new FixedReceiveBufferSizePredictorFactory((int)this.receivePredictorMax.bytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)this.receivePredictorMin.bytes(), (int)this.receivePredictorMin.bytes(), (int)this.receivePredictorMax.bytes());
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public void transportServiceAdapter(TransportServiceAdapter service) {
        this.transportServiceAdapter = service;
    }

    TransportServiceAdapter transportServiceAdapter() {
        return this.transportServiceAdapter;
    }

    ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        InetSocketAddress publishAddress;
        OpenChannelsHandler openChannels;
        this.clientBootstrap = this.createClientBootstrap();
        if (!this.settings.getAsBoolean("network.server", (Boolean)true).booleanValue()) {
            return;
        }
        this.serverOpenChannels = openChannels = new OpenChannelsHandler(this.logger);
        Map<String, Settings> profiles = this.settings.getGroups("transport.profiles", true);
        if (!profiles.containsKey("default")) {
            profiles = Maps.newHashMap(profiles);
            profiles.put("default", ImmutableSettings.EMPTY);
        }
        Settings fallbackSettings = this.createFallbackSettings();
        Settings defaultSettings = profiles.get("default");
        for (Map.Entry<String, Settings> entry : profiles.entrySet()) {
            Settings profileSettings = entry.getValue();
            String name = entry.getKey();
            if ("default".equals(name)) {
                profileSettings = ImmutableSettings.settingsBuilder().put(profileSettings).put("port", profileSettings.get("port", this.componentSettings.get("port", this.settings.get("transport.tcp.port", DEFAULT_PORT_RANGE)))).build();
            } else if (profileSettings.get("port") == null) {
                this.logger.info("No port configured for profile [{}], not binding", name);
                continue;
            }
            Settings mergedSettings = ImmutableSettings.settingsBuilder().put(fallbackSettings).put(defaultSettings).put(profileSettings).build();
            this.createServerBootstrap(name, mergedSettings);
            this.bindServerBootstrap(name, mergedSettings);
        }
        InetSocketAddress boundAddress = (InetSocketAddress)this.serverChannels.get("default").getLocalAddress();
        int publishPort = this.componentSettings.getAsInt("publish_port", this.settings.getAsInt("transport.publish_port", (Integer)0));
        if (0 == publishPort) {
            publishPort = boundAddress.getPort();
        }
        try {
            String publishHost = this.componentSettings.get("publish_host", this.settings.get("transport.publish_host", this.settings.get("transport.host")));
            publishAddress = new InetSocketAddress(this.networkService.resolvePublishHostAddress(publishHost), publishPort);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        this.boundAddress = new BoundTransportAddress(new InetSocketTransportAddress(boundAddress), new InetSocketTransportAddress(publishAddress));
    }

    private ClientBootstrap createClientBootstrap() {
        ByteSizeValue tcpReceiveBufferSize;
        ByteSizeValue tcpSendBufferSize;
        String tcpKeepAlive;
        if (this.blockingClient) {
            this.clientBootstrap = new ClientBootstrap(new OioClientSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_worker"))));
        } else {
            int bossCount = this.componentSettings.getAsInt("boss_count", (Integer)1);
            this.clientBootstrap = new ClientBootstrap(new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_boss")), bossCount, new NioWorkerPool(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_worker")), this.workerCount), new HashedWheelTimer(EsExecutors.daemonThreadFactory(this.settings, "transport_client_timer"))));
        }
        this.clientBootstrap.setPipelineFactory(this.configureClientChannelPipelineFactory());
        this.clientBootstrap.setOption("connectTimeoutMillis", this.connectTimeout.millis());
        String tcpNoDelay = this.componentSettings.get("tcp_no_delay", this.settings.get("network.tcp.no_delay", "true"));
        if (!"default".equals(tcpNoDelay)) {
            this.clientBootstrap.setOption("tcpNoDelay", Booleans.parseBoolean(tcpNoDelay, null));
        }
        if (!"default".equals(tcpKeepAlive = this.componentSettings.get("tcp_keep_alive", this.settings.get("network.tcp.keep_alive", "true")))) {
            this.clientBootstrap.setOption("keepAlive", Booleans.parseBoolean(tcpKeepAlive, null));
        }
        if ((tcpSendBufferSize = this.componentSettings.getAsBytesSize("tcp_send_buffer_size", this.settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE))) != null && tcpSendBufferSize.bytes() > 0L) {
            this.clientBootstrap.setOption("sendBufferSize", tcpSendBufferSize.bytes());
        }
        if ((tcpReceiveBufferSize = this.componentSettings.getAsBytesSize("tcp_receive_buffer_size", this.settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE))) != null && tcpReceiveBufferSize.bytes() > 0L) {
            this.clientBootstrap.setOption("receiveBufferSize", tcpReceiveBufferSize.bytes());
        }
        this.clientBootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        Boolean reuseAddress = this.componentSettings.getAsBoolean("reuse_address", this.settings.getAsBoolean("network.tcp.reuse_address", NetworkUtils.defaultReuseAddress()));
        if (reuseAddress != null) {
            this.clientBootstrap.setOption("reuseAddress", reuseAddress);
        }
        return this.clientBootstrap;
    }

    private Settings createFallbackSettings() {
        ByteSizeValue fallbackTcpBufferSize;
        ByteSizeValue fallbackTcpSendBufferSize;
        Boolean fallbackReuseAddress;
        String fallbackTcpKeepAlive;
        String fallbackTcpNoDelay;
        String fallbackPublishHost;
        ImmutableSettings.Builder fallbackSettingsBuilder = ImmutableSettings.settingsBuilder();
        String fallbackBindHost = this.componentSettings.get("bind_host", this.settings.get("transport.bind_host", this.settings.get("transport.host")));
        if (fallbackBindHost != null) {
            fallbackSettingsBuilder.put("bind_host", fallbackBindHost);
        }
        if ((fallbackPublishHost = this.componentSettings.get("publish_host", this.settings.get("transport.publish_host", this.settings.get("transport.host")))) != null) {
            fallbackSettingsBuilder.put("publish_host", fallbackPublishHost);
        }
        if ((fallbackTcpNoDelay = this.componentSettings.get("tcp_no_delay", this.settings.get("network.tcp.no_delay", "true"))) != null) {
            fallbackSettingsBuilder.put("tcp_no_delay", fallbackTcpNoDelay);
        }
        if ((fallbackTcpKeepAlive = this.componentSettings.get("tcp_keep_alive", this.settings.get("network.tcp.keep_alive", "true"))) != null) {
            fallbackSettingsBuilder.put("tcp_keep_alive", fallbackTcpKeepAlive);
        }
        if ((fallbackReuseAddress = this.componentSettings.getAsBoolean("reuse_address", this.settings.getAsBoolean("network.tcp.reuse_address", NetworkUtils.defaultReuseAddress()))) != null) {
            fallbackSettingsBuilder.put("reuse_address", fallbackReuseAddress);
        }
        if ((fallbackTcpSendBufferSize = this.componentSettings.getAsBytesSize("tcp_send_buffer_size", this.settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE))) != null) {
            fallbackSettingsBuilder.put("tcp_send_buffer_size", fallbackTcpSendBufferSize);
        }
        if ((fallbackTcpBufferSize = this.componentSettings.getAsBytesSize("tcp_receive_buffer_size", this.settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE))) != null) {
            fallbackSettingsBuilder.put("tcp_receive_buffer_size", fallbackTcpBufferSize);
        }
        return fallbackSettingsBuilder.build();
    }

    private void bindServerBootstrap(final String name, Settings settings) {
        InetAddress hostAddressX;
        String bindHost = settings.get("bind_host");
        try {
            hostAddressX = this.networkService.resolveBindHostAddress(bindHost);
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host [" + bindHost + "]", e);
        }
        final InetAddress hostAddress = hostAddressX;
        String port = settings.get("port");
        PortsRange portsRange = new PortsRange(port);
        final AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(new PortsRange.PortCallback(){

            @Override
            public boolean onPortNumber(int portNumber) {
                try {
                    NettyTransport.this.serverChannels.put(name, ((ServerBootstrap)NettyTransport.this.serverBootstraps.get(name)).bind(new InetSocketAddress(hostAddress, portNumber)));
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            }
        });
        if (!success) {
            throw new BindTransportException("Failed to bind to [" + port + "]", (Throwable)lastException.get());
        }
        this.logger.debug("Bound profile [{}] to address [{}]", name, this.serverChannels.get(name).getLocalAddress());
    }

    private void createServerBootstrap(String name, Settings settings) {
        boolean blockingServer = settings.getAsBoolean("transport.tcp.blocking_server", this.settings.getAsBoolean("network.tcp.blocking_server", this.settings.getAsBoolean("network.tcp.blocking", (Boolean)false)));
        String port = settings.get("port");
        String bindHost = settings.get("bind_host");
        String publishHost = settings.get("publish_host");
        String tcpNoDelay = settings.get("tcp_no_delay");
        String tcpKeepAlive = settings.get("tcp_keep_alive");
        Boolean reuseAddress = settings.getAsBoolean("reuse_address", NetworkUtils.defaultReuseAddress());
        ByteSizeValue tcpSendBufferSize = settings.getAsBytesSize("tcp_send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE);
        ByteSizeValue tcpReceiveBufferSize = settings.getAsBytesSize("tcp_receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE);
        this.logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}/{}/{}], receive_predictor[{}->{}]", name, this.workerCount, port, bindHost, publishHost, this.compress, this.connectTimeout, this.connectionsPerNodeRecovery, this.connectionsPerNodeBulk, this.connectionsPerNodeReg, this.connectionsPerNodeState, this.connectionsPerNodePing, this.receivePredictorMin, this.receivePredictorMax);
        ServerBootstrap serverBootstrap = blockingServer ? new ServerBootstrap(new OioServerSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_boss", name)), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_worker", name)))) : new ServerBootstrap(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_boss", name)), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_worker", name)), this.workerCount));
        serverBootstrap.setPipelineFactory(this.configureServerChannelPipelineFactory(name, settings));
        if (!"default".equals(tcpNoDelay)) {
            serverBootstrap.setOption("child.tcpNoDelay", Booleans.parseBoolean(tcpNoDelay, null));
        }
        if (!"default".equals(tcpKeepAlive)) {
            serverBootstrap.setOption("child.keepAlive", Booleans.parseBoolean(tcpKeepAlive, null));
        }
        if (tcpSendBufferSize != null && tcpSendBufferSize.bytes() > 0L) {
            serverBootstrap.setOption("child.sendBufferSize", tcpSendBufferSize.bytes());
        }
        if (tcpReceiveBufferSize != null && tcpReceiveBufferSize.bytes() > 0L) {
            serverBootstrap.setOption("child.receiveBufferSize", tcpReceiveBufferSize.bytes());
        }
        serverBootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        if (reuseAddress != null) {
            serverBootstrap.setOption("reuseAddress", reuseAddress);
            serverBootstrap.setOption("child.reuseAddress", reuseAddress);
        }
        this.serverBootstraps.put(name, serverBootstrap);
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.threadPool.generic().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NettyTransport.this.globalLock.writeLock().lock();
                try {
                    Iterator it = NettyTransport.this.connectedNodes.values().iterator();
                    while (it.hasNext()) {
                        NodeChannels nodeChannels = (NodeChannels)it.next();
                        it.remove();
                        nodeChannels.close();
                    }
                    Iterator serverChannelIterator = NettyTransport.this.serverChannels.entrySet().iterator();
                    while (serverChannelIterator.hasNext()) {
                        Map.Entry serverChannelEntry = serverChannelIterator.next();
                        String name = (String)serverChannelEntry.getKey();
                        Channel serverChannel = (Channel)serverChannelEntry.getValue();
                        try {
                            serverChannel.close().awaitUninterruptibly();
                        }
                        catch (Throwable t) {
                            NettyTransport.this.logger.debug("Error closing serverChannel for profile [{}]", t, name);
                        }
                        serverChannelIterator.remove();
                    }
                    if (NettyTransport.this.serverOpenChannels != null) {
                        NettyTransport.this.serverOpenChannels.close();
                        NettyTransport.this.serverOpenChannels = null;
                    }
                    Iterator serverBootstrapIterator = NettyTransport.this.serverBootstraps.entrySet().iterator();
                    while (serverBootstrapIterator.hasNext()) {
                        Map.Entry serverBootstrapEntry = serverBootstrapIterator.next();
                        String name = (String)serverBootstrapEntry.getKey();
                        ServerBootstrap serverBootstrap = (ServerBootstrap)serverBootstrapEntry.getValue();
                        try {
                            serverBootstrap.releaseExternalResources();
                        }
                        catch (Throwable t) {
                            NettyTransport.this.logger.debug("Error closing serverBootstrap for profile [{}]", t, name);
                        }
                        serverBootstrapIterator.remove();
                    }
                    Iterator it2 = NettyTransport.this.connectedNodes.values().iterator();
                    while (it2.hasNext()) {
                        NodeChannels nodeChannels = (NodeChannels)it2.next();
                        it2.remove();
                        nodeChannels.close();
                    }
                    if (NettyTransport.this.clientBootstrap != null) {
                        NettyTransport.this.clientBootstrap.releaseExternalResources();
                        NettyTransport.this.clientBootstrap = null;
                    }
                }
                finally {
                    NettyTransport.this.globalLock.writeLock().unlock();
                    latch.countDown();
                }
            }
        });
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public TransportAddress[] addressesFromString(String address) throws Exception {
        int index = address.indexOf(91);
        if (index != -1) {
            String host = address.substring(0, index);
            Set<String> ports = Strings.commaDelimitedListToSet(address.substring(index + 1, address.indexOf(93)));
            ArrayList<InetSocketTransportAddress> addresses = Lists.newArrayList();
            for (String port : ports) {
                int[] iPorts;
                for (int iPort : iPorts = new PortsRange(port).ports()) {
                    addresses.add(new InetSocketTransportAddress(host, iPort));
                }
            }
            return addresses.toArray(new TransportAddress[addresses.size()]);
        }
        index = address.lastIndexOf(58);
        if (index == -1) {
            int[] iPorts;
            ArrayList<InetSocketTransportAddress> addresses = Lists.newArrayList();
            String defaultPort = this.settings.get("transport.profiles.default.port", this.componentSettings.get("port", this.settings.get("transport.tcp.port", DEFAULT_PORT_RANGE)));
            for (int iPort : iPorts = new PortsRange(defaultPort).ports()) {
                addresses.add(new InetSocketTransportAddress(address, iPort));
            }
            return addresses.toArray(new TransportAddress[addresses.size()]);
        }
        String host = address.substring(0, index);
        int port = Integer.parseInt(address.substring(index + 1));
        return new TransportAddress[]{new InetSocketTransportAddress(host, port)};
    }

    @Override
    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return InetSocketTransportAddress.class.equals(address);
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!this.lifecycle.started()) {
            return;
        }
        if (NetworkExceptionHelper.isCloseConnectionException(e.getCause())) {
            this.logger.trace("close connection exception caught on transport layer [{}], disconnecting from relevant node", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else if (NetworkExceptionHelper.isConnectException(e.getCause())) {
            this.logger.trace("connect exception caught on transport layer [{}]", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else if (e.getCause() instanceof CancelledKeyException) {
            this.logger.trace("cancelled key exception caught on transport layer [{}], disconnecting from relevant node", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        } else {
            this.logger.warn("exception caught on transport layer [{}], closing connection", e.getCause(), ctx.getChannel());
            ctx.getChannel().close();
            this.disconnectFromNodeChannel(ctx.getChannel(), e.getCause());
        }
    }

    TransportAddress wrapAddress(SocketAddress socketAddress) {
        return new InetSocketTransportAddress((InetSocketAddress)socketAddress);
    }

    @Override
    public long serverOpen() {
        OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendRequest(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        Channel targetChannel = this.nodeChannel(node, options);
        if (this.compress) {
            options.withCompress(true);
        }
        byte status = 0;
        status = TransportStatus.setRequest(status);
        ReleasableBytesStreamOutput bStream = new ReleasableBytesStreamOutput(this.bigArrays);
        boolean addedReleaseListener = false;
        try {
            ChannelBuffer buffer;
            ReleasableBytesReference bytes;
            bStream.skip(19);
            StreamOutput stream = bStream;
            if (options.compress() && !(request instanceof BytesTransportRequest)) {
                status = TransportStatus.setCompress(status);
                stream = CompressorFactory.defaultCompressor().streamOutput(stream);
            }
            stream = new HandlesStreamOutput(stream);
            Version version = Version.smallest(this.version, node.version());
            stream.setVersion(version);
            stream.writeString(this.transportServiceAdapter.action(action, version));
            if (request instanceof BytesTransportRequest) {
                BytesTransportRequest bRequest = (BytesTransportRequest)request;
                assert (node.version().equals(bRequest.version()));
                bRequest.writeThin(stream);
                stream.close();
                bytes = bStream.bytes();
                ChannelBuffer headerBuffer = bytes.toChannelBuffer();
                ChannelBuffer contentBuffer = bRequest.bytes().toChannelBuffer();
                buffer = ChannelBuffers.wrappedBuffer(NettyUtils.DEFAULT_GATHERING, headerBuffer, contentBuffer);
            } else {
                request.writeTo(stream);
                stream.close();
                bytes = bStream.bytes();
                buffer = bytes.toChannelBuffer();
            }
            NettyHeader.writeHeader(buffer, requestId, status, version);
            ChannelFuture future = targetChannel.write(buffer);
            ReleaseChannelFutureListener listener = new ReleaseChannelFutureListener(bytes);
            future.addListener(listener);
            return;
        }
        catch (Throwable throwable) {
            if (addedReleaseListener) throw throwable;
            Releasables.close(bStream.bytes());
            throw throwable;
        }
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node, true);
    }

    @Override
    public void connectToNode(DiscoveryNode node) {
        this.connectToNode(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToNode(DiscoveryNode node, boolean light) {
        if (!this.lifecycle.started()) {
            throw new ElasticsearchIllegalStateException("can't add nodes to a stopped transport");
        }
        if (node == null) {
            throw new ConnectTransportException(null, "can't connect to a null node");
        }
        this.globalLock.readLock().lock();
        try {
            this.connectionLock.acquire(node.id());
            try {
                if (!this.lifecycle.started()) {
                    throw new ElasticsearchIllegalStateException("can't add nodes to a stopped transport");
                }
                NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
                if (nodeChannels != null) {
                    return;
                }
                try {
                    if (light) {
                        nodeChannels = this.connectToChannelsLight(node);
                    } else {
                        nodeChannels = new NodeChannels(new Channel[this.connectionsPerNodeRecovery], new Channel[this.connectionsPerNodeBulk], new Channel[this.connectionsPerNodeReg], new Channel[this.connectionsPerNodeState], new Channel[this.connectionsPerNodePing]);
                        try {
                            this.connectToChannels(nodeChannels, node);
                        }
                        catch (Throwable e) {
                            this.logger.trace("failed to connect to [{}], cleaning dangling connections", e, node);
                            nodeChannels.close();
                            throw e;
                        }
                    }
                    this.connectedNodes.put(node, nodeChannels);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("connected to node [{}]", node);
                    }
                    this.transportServiceAdapter.raiseNodeConnected(node);
                }
                catch (ConnectTransportException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConnectTransportException(node, "general node connection failure", e);
                }
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private NodeChannels connectToChannelsLight(DiscoveryNode node) {
        InetSocketAddress address = ((InetSocketTransportAddress)node.address()).address();
        ChannelFuture connect = this.clientBootstrap.connect(address);
        connect.awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
        if (!connect.isSuccess()) {
            throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connect.getCause());
        }
        Channel[] channels = new Channel[]{connect.getChannel()};
        channels[0].getCloseFuture().addListener(new ChannelCloseListener(node));
        return new NodeChannels(channels, channels, channels, channels, channels);
    }

    private void connectToChannels(NodeChannels nodeChannels, DiscoveryNode node) {
        int i;
        Object[] connectRecovery = new ChannelFuture[nodeChannels.recovery.length];
        Object[] connectBulk = new ChannelFuture[nodeChannels.bulk.length];
        Object[] connectReg = new ChannelFuture[nodeChannels.reg.length];
        Object[] connectState = new ChannelFuture[nodeChannels.state.length];
        Object[] connectPing = new ChannelFuture[nodeChannels.ping.length];
        InetSocketAddress address = ((InetSocketTransportAddress)node.address()).address();
        for (i = 0; i < connectRecovery.length; ++i) {
            connectRecovery[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectBulk.length; ++i) {
            connectBulk[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectReg.length; ++i) {
            connectReg[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectState.length; ++i) {
            connectState[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectPing.length; ++i) {
            connectPing[i] = this.clientBootstrap.connect(address);
        }
        try {
            for (i = 0; i < connectRecovery.length; ++i) {
                connectRecovery[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectRecovery[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectRecovery[i].getCause());
                }
                ((NodeChannels)nodeChannels).recovery[i] = connectRecovery[i].getChannel();
                nodeChannels.recovery[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectBulk.length; ++i) {
                connectBulk[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectBulk[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectBulk[i].getCause());
                }
                ((NodeChannels)nodeChannels).bulk[i] = connectBulk[i].getChannel();
                nodeChannels.bulk[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectReg.length; ++i) {
                connectReg[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectReg[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectReg[i].getCause());
                }
                ((NodeChannels)nodeChannels).reg[i] = connectReg[i].getChannel();
                nodeChannels.reg[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectState.length; ++i) {
                connectState[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectState[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectState[i].getCause());
                }
                ((NodeChannels)nodeChannels).state[i] = connectState[i].getChannel();
                nodeChannels.state[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectPing.length; ++i) {
                connectPing[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectPing[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectPing[i].getCause());
                }
                ((NodeChannels)nodeChannels).ping[i] = connectPing[i].getChannel();
                nodeChannels.ping[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            if (nodeChannels.recovery.length == 0) {
                if (nodeChannels.bulk.length > 0) {
                    NodeChannels.access$802(nodeChannels, nodeChannels.bulk);
                } else {
                    NodeChannels.access$802(nodeChannels, nodeChannels.reg);
                }
            }
            if (nodeChannels.bulk.length == 0) {
                NodeChannels.access$902(nodeChannels, nodeChannels.reg);
            }
        }
        catch (RuntimeException e) {
            for (ChannelFuture future : ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(connectRecovery)).add(connectBulk)).add(connectReg)).add(connectState)).add(connectPing)).build()) {
                future.cancel();
                if (future.getChannel() == null || !future.getChannel().isOpen()) continue;
                try {
                    future.getChannel().close();
                }
                catch (Exception e1) {}
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        block5: {
            this.connectionLock.acquire(node.id());
            try {
                NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.remove(node);
                if (nodeChannels == null) break block5;
                try {
                    this.logger.debug("disconnecting from [{}] due to explicit disconnect call", node);
                    nodeChannels.close();
                }
                catch (Throwable throwable) {
                    this.logger.trace("disconnected from [{}] due to explicit disconnect call", node);
                    this.transportServiceAdapter.raiseNodeDisconnected(node);
                    throw throwable;
                }
                this.logger.trace("disconnected from [{}] due to explicit disconnect call", node);
                this.transportServiceAdapter.raiseNodeDisconnected(node);
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disconnectFromNode(DiscoveryNode node, Channel channel, String reason) {
        block5: {
            NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
            if (nodeChannels == null || !nodeChannels.hasChannel(channel)) break block5;
            this.connectionLock.acquire(node.id());
            try {
                nodeChannels = (NodeChannels)this.connectedNodes.get(node);
                if (nodeChannels == null || !nodeChannels.hasChannel(channel)) break block5;
                this.connectedNodes.remove(node);
                try {
                    this.logger.debug("disconnecting from [{}], {}", node, reason);
                    nodeChannels.close();
                }
                catch (Throwable throwable) {
                    this.logger.trace("disconnected from [{}], {}", node, reason);
                    this.transportServiceAdapter.raiseNodeDisconnected(node);
                    throw throwable;
                }
                this.logger.trace("disconnected from [{}], {}", node, reason);
                this.transportServiceAdapter.raiseNodeDisconnected(node);
                boolean bl = true;
                return bl;
            }
            finally {
                this.connectionLock.release(node.id());
            }
        }
        return false;
    }

    private void disconnectFromNodeChannel(final Channel channel, final Throwable failure) {
        this.threadPool().generic().execute(new Runnable(){

            @Override
            public void run() {
                DiscoveryNode node;
                Iterator i$ = NettyTransport.this.connectedNodes.keySet().iterator();
                while (i$.hasNext() && !NettyTransport.this.disconnectFromNode(node = (DiscoveryNode)i$.next(), channel, ExceptionsHelper.detailedMessage(failure))) {
                }
            }
        });
    }

    private Channel nodeChannel(DiscoveryNode node, TransportRequestOptions options) throws ConnectTransportException {
        NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
        if (nodeChannels == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return nodeChannels.channel(options.type());
    }

    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        return new ClientChannelPipelineFactory(this);
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings settings) {
        return new ServerChannelPipelineFactory(this, name, settings);
    }

    static {
        NettyUtils.setup();
    }

    public static class NodeChannels {
        private Channel[] recovery;
        private final AtomicInteger recoveryCounter = new AtomicInteger();
        private Channel[] bulk;
        private final AtomicInteger bulkCounter = new AtomicInteger();
        private Channel[] reg;
        private final AtomicInteger regCounter = new AtomicInteger();
        private Channel[] state;
        private final AtomicInteger stateCounter = new AtomicInteger();
        private Channel[] ping;
        private final AtomicInteger pingCounter = new AtomicInteger();

        public NodeChannels(Channel[] recovery, Channel[] bulk, Channel[] reg, Channel[] state, Channel[] ping) {
            this.recovery = recovery;
            this.bulk = bulk;
            this.reg = reg;
            this.state = state;
            this.ping = ping;
        }

        public boolean hasChannel(Channel channel) {
            return this.hasChannel(channel, this.recovery) || this.hasChannel(channel, this.bulk) || this.hasChannel(channel, this.reg) || this.hasChannel(channel, this.state) || this.hasChannel(channel, this.ping);
        }

        private boolean hasChannel(Channel channel, Channel[] channels) {
            for (Channel channel1 : channels) {
                if (!channel.equals(channel1)) continue;
                return true;
            }
            return false;
        }

        public Channel channel(TransportRequestOptions.Type type) {
            if (type == TransportRequestOptions.Type.REG) {
                return this.reg[MathUtils.mod(this.regCounter.incrementAndGet(), this.reg.length)];
            }
            if (type == TransportRequestOptions.Type.STATE) {
                return this.state[MathUtils.mod(this.stateCounter.incrementAndGet(), this.state.length)];
            }
            if (type == TransportRequestOptions.Type.PING) {
                return this.ping[MathUtils.mod(this.pingCounter.incrementAndGet(), this.ping.length)];
            }
            if (type == TransportRequestOptions.Type.BULK) {
                return this.bulk[MathUtils.mod(this.bulkCounter.incrementAndGet(), this.bulk.length)];
            }
            if (type == TransportRequestOptions.Type.RECOVERY) {
                return this.recovery[MathUtils.mod(this.recoveryCounter.incrementAndGet(), this.recovery.length)];
            }
            throw new ElasticsearchIllegalArgumentException("no type channel for [" + (Object)((Object)type) + "]");
        }

        public synchronized void close() {
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            this.closeChannelsAndWait(this.recovery, futures);
            this.closeChannelsAndWait(this.bulk, futures);
            this.closeChannelsAndWait(this.reg, futures);
            this.closeChannelsAndWait(this.state, futures);
            this.closeChannelsAndWait(this.ping, futures);
            for (ChannelFuture future : futures) {
                future.awaitUninterruptibly();
            }
        }

        private void closeChannelsAndWait(Channel[] channels, List<ChannelFuture> futures) {
            for (Channel channel : channels) {
                try {
                    if (channel == null || !channel.isOpen()) continue;
                    futures.add(channel.close());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Channel[] access$802(NodeChannels x0, Channel[] x1) {
            x0.recovery = x1;
            return x1;
        }

        static /* synthetic */ Channel[] access$902(NodeChannels x0, Channel[] x1) {
            x0.bulk = x1;
            return x1;
        }
    }

    private class ChannelCloseListener
    implements ChannelFutureListener {
        private final DiscoveryNode node;

        private ChannelCloseListener(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void operationComplete(final ChannelFuture future) throws Exception {
            NodeChannels nodeChannels = (NodeChannels)NettyTransport.this.connectedNodes.get(this.node);
            if (nodeChannels != null && nodeChannels.hasChannel(future.getChannel())) {
                NettyTransport.this.threadPool().generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyTransport.this.disconnectFromNode(ChannelCloseListener.this.node, future.getChannel(), "channel closed event");
                    }
                });
            }
        }
    }

    protected static class ServerChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final NettyTransport nettyTransport;
        protected final String name;
        protected final Settings settings;

        public ServerChannelPipelineFactory(NettyTransport nettyTransport, String name, Settings settings) {
            this.nettyTransport = nettyTransport;
            this.name = name;
            this.settings = settings;
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline channelPipeline = Channels.pipeline();
            channelPipeline.addLast("openChannels", this.nettyTransport.serverOpenChannels);
            SizeHeaderFrameDecoder sizeHeader = new SizeHeaderFrameDecoder();
            if (this.nettyTransport.maxCumulationBufferCapacity != null) {
                if (this.nettyTransport.maxCumulationBufferCapacity.bytes() > Integer.MAX_VALUE) {
                    sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    sizeHeader.setMaxCumulationBufferCapacity((int)this.nettyTransport.maxCumulationBufferCapacity.bytes());
                }
            }
            if (this.nettyTransport.maxCompositeBufferComponents != -1) {
                sizeHeader.setMaxCumulationBufferComponents(this.nettyTransport.maxCompositeBufferComponents);
            }
            channelPipeline.addLast("size", sizeHeader);
            channelPipeline.addLast("dispatcher", new MessageChannelHandler(this.nettyTransport, this.nettyTransport.logger));
            return channelPipeline;
        }
    }

    protected static class ClientChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected NettyTransport nettyTransport;

        public ClientChannelPipelineFactory(NettyTransport nettyTransport) {
            this.nettyTransport = nettyTransport;
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline channelPipeline = Channels.pipeline();
            SizeHeaderFrameDecoder sizeHeader = new SizeHeaderFrameDecoder();
            if (this.nettyTransport.maxCumulationBufferCapacity != null) {
                if (this.nettyTransport.maxCumulationBufferCapacity.bytes() > Integer.MAX_VALUE) {
                    sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    sizeHeader.setMaxCumulationBufferCapacity((int)this.nettyTransport.maxCumulationBufferCapacity.bytes());
                }
            }
            if (this.nettyTransport.maxCompositeBufferComponents != -1) {
                sizeHeader.setMaxCumulationBufferComponents(this.nettyTransport.maxCompositeBufferComponents);
            }
            channelPipeline.addLast("size", sizeHeader);
            channelPipeline.addLast("dispatcher", new MessageChannelHandler(this.nettyTransport, this.nettyTransport.logger));
            return channelPipeline;
        }
    }
}

