/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricAggregator;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptedMetricParser
implements Aggregator.Parser {
    public static final ParseField PARAMS_FIELD = new ParseField("params", new String[0]);
    public static final ParseField REDUCE_PARAMS_FIELD = new ParseField("reduce_params", new String[0]);
    public static final ParseField INIT_SCRIPT_FIELD = new ParseField("init_script", new String[0]);
    public static final ParseField MAP_SCRIPT_FIELD = new ParseField("map_script", new String[0]);
    public static final ParseField COMBINE_SCRIPT_FIELD = new ParseField("combine_script", new String[0]);
    public static final ParseField REDUCE_SCRIPT_FIELD = new ParseField("reduce_script", new String[0]);
    public static final ParseField INIT_SCRIPT_FILE_FIELD = new ParseField("init_script_file", new String[0]);
    public static final ParseField MAP_SCRIPT_FILE_FIELD = new ParseField("map_script_file", new String[0]);
    public static final ParseField COMBINE_SCRIPT_FILE_FIELD = new ParseField("combine_script_file", new String[0]);
    public static final ParseField REDUCE_SCRIPT_FILE_FIELD = new ParseField("reduce_script_file", new String[0]);
    public static final ParseField INIT_SCRIPT_ID_FIELD = new ParseField("init_script_id", new String[0]);
    public static final ParseField MAP_SCRIPT_ID_FIELD = new ParseField("map_script_id", new String[0]);
    public static final ParseField COMBINE_SCRIPT_ID_FIELD = new ParseField("combine_script_id", new String[0]);
    public static final ParseField REDUCE_SCRIPT_ID_FIELD = new ParseField("reduce_script_id", new String[0]);
    public static final ParseField LANG_FIELD = new ParseField("lang", new String[0]);

    @Override
    public String type() {
        return InternalScriptedMetric.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String initScript = null;
        String mapScript = null;
        String combineScript = null;
        String reduceScript = null;
        String scriptLang = null;
        ScriptService.ScriptType initScriptType = ScriptService.ScriptType.INLINE;
        ScriptService.ScriptType mapScriptType = ScriptService.ScriptType.INLINE;
        ScriptService.ScriptType combineScriptType = ScriptService.ScriptType.INLINE;
        ScriptService.ScriptType reduceScriptType = ScriptService.ScriptType.INLINE;
        Map<String, Object> params = null;
        Map<String, Object> reduceParams = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (PARAMS_FIELD.match(currentFieldName)) {
                    params = parser.map();
                    continue;
                }
                if (REDUCE_PARAMS_FIELD.match(currentFieldName)) {
                    reduceParams = parser.map();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token.isValue()) {
                if (INIT_SCRIPT_FIELD.match(currentFieldName)) {
                    if (initScript != null) {
                        throw new SearchParseException(context, "Only one of [init_script, init_script_file, init_script_id] is allowed in [" + aggregationName + "].");
                    }
                    initScript = parser.text();
                    initScriptType = ScriptService.ScriptType.INLINE;
                    continue;
                }
                if (MAP_SCRIPT_FIELD.match(currentFieldName)) {
                    if (mapScript != null) {
                        throw new SearchParseException(context, "Only one of [map_script, map_script_file, map_script_id] is allowed in [" + aggregationName + "].");
                    }
                    mapScript = parser.text();
                    mapScriptType = ScriptService.ScriptType.INLINE;
                    continue;
                }
                if (COMBINE_SCRIPT_FIELD.match(currentFieldName)) {
                    if (combineScript != null) {
                        throw new SearchParseException(context, "Only one of [combine_script, combine_script_file, combine_script_id] is allowed in [" + aggregationName + "].");
                    }
                    combineScript = parser.text();
                    combineScriptType = ScriptService.ScriptType.INLINE;
                    continue;
                }
                if (REDUCE_SCRIPT_FIELD.match(currentFieldName)) {
                    if (reduceScript != null) {
                        throw new SearchParseException(context, "Only one of [reduce_script, reduce_script_file, reduce_script_id] is allowed in [" + aggregationName + "].");
                    }
                    reduceScript = parser.text();
                    reduceScriptType = ScriptService.ScriptType.INLINE;
                    continue;
                }
                if (INIT_SCRIPT_FILE_FIELD.match(currentFieldName)) {
                    if (initScript != null) {
                        throw new SearchParseException(context, "Only one of [init_script, init_script_file, init_script_id] is allowed in [" + aggregationName + "].");
                    }
                    initScript = parser.text();
                    initScriptType = ScriptService.ScriptType.FILE;
                    continue;
                }
                if (MAP_SCRIPT_FILE_FIELD.match(currentFieldName)) {
                    if (mapScript != null) {
                        throw new SearchParseException(context, "Only one of [map_script, map_script_file, map_script_id] is allowed in [" + aggregationName + "].");
                    }
                    mapScript = parser.text();
                    mapScriptType = ScriptService.ScriptType.FILE;
                    continue;
                }
                if (COMBINE_SCRIPT_FILE_FIELD.match(currentFieldName)) {
                    if (combineScript != null) {
                        throw new SearchParseException(context, "Only one of [combine_script, combine_script_file, combine_script_id] is allowed in [" + aggregationName + "].");
                    }
                    combineScript = parser.text();
                    combineScriptType = ScriptService.ScriptType.FILE;
                    continue;
                }
                if (REDUCE_SCRIPT_FILE_FIELD.match(currentFieldName)) {
                    if (reduceScript != null) {
                        throw new SearchParseException(context, "Only one of [reduce_script, reduce_script_file, reduce_script_id] is allowed in [" + aggregationName + "].");
                    }
                    reduceScript = parser.text();
                    reduceScriptType = ScriptService.ScriptType.FILE;
                    continue;
                }
                if (INIT_SCRIPT_ID_FIELD.match(currentFieldName)) {
                    if (initScript != null) {
                        throw new SearchParseException(context, "Only one of [init_script, init_script_file, init_script_id] is allowed in [" + aggregationName + "].");
                    }
                    initScript = parser.text();
                    initScriptType = ScriptService.ScriptType.INDEXED;
                    continue;
                }
                if (MAP_SCRIPT_ID_FIELD.match(currentFieldName)) {
                    if (mapScript != null) {
                        throw new SearchParseException(context, "Only one of [map_script, map_script_file, map_script_id] is allowed in [" + aggregationName + "].");
                    }
                    mapScript = parser.text();
                    mapScriptType = ScriptService.ScriptType.INDEXED;
                    continue;
                }
                if (COMBINE_SCRIPT_ID_FIELD.match(currentFieldName)) {
                    if (combineScript != null) {
                        throw new SearchParseException(context, "Only one of [combine_script, combine_script_file, combine_script_id] is allowed in [" + aggregationName + "].");
                    }
                    combineScript = parser.text();
                    combineScriptType = ScriptService.ScriptType.INDEXED;
                    continue;
                }
                if (REDUCE_SCRIPT_ID_FIELD.match(currentFieldName)) {
                    if (reduceScript != null) {
                        throw new SearchParseException(context, "Only one of [reduce_script, reduce_script_file, reduce_script_id] is allowed in [" + aggregationName + "].");
                    }
                    reduceScript = parser.text();
                    reduceScriptType = ScriptService.ScriptType.INDEXED;
                    continue;
                }
                if (LANG_FIELD.match(currentFieldName)) {
                    scriptLang = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (mapScript == null) {
            throw new SearchParseException(context, "map_script field is required in [" + aggregationName + "].");
        }
        return new ScriptedMetricAggregator.Factory(aggregationName, scriptLang, initScriptType, initScript, mapScriptType, mapScript, combineScriptType, combineScript, reduceScriptType, reduceScript, params, reduceParams);
    }
}

