/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParametersParser;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;

public class TermsBuilder
extends ValuesSourceAggregationBuilder<TermsBuilder> {
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(-1L, -1L, -1, -1);
    private Terms.ValueType valueType;
    private Terms.Order order;
    private String includePattern;
    private int includeFlags;
    private String excludePattern;
    private int excludeFlags;
    private String executionHint;
    private Aggregator.SubAggCollectionMode collectionMode;
    private Boolean showTermDocCountError;

    public TermsBuilder(String name) {
        super(name, "terms");
    }

    public TermsBuilder size(int size) {
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public TermsBuilder shardSize(int shardSize) {
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public TermsBuilder minDocCount(long minDocCount) {
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public TermsBuilder shardMinDocCount(long shardMinDocCount) {
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    public TermsBuilder include(String regex) {
        return this.include(regex, 0);
    }

    public TermsBuilder include(String regex, int flags) {
        this.includePattern = regex;
        this.includeFlags = flags;
        return this;
    }

    public TermsBuilder exclude(String regex) {
        return this.exclude(regex, 0);
    }

    public TermsBuilder exclude(String regex, int flags) {
        this.excludePattern = regex;
        this.excludeFlags = flags;
        return this;
    }

    public TermsBuilder valueType(Terms.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public TermsBuilder order(Terms.Order order) {
        this.order = order;
        return this;
    }

    public TermsBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    public TermsBuilder collectMode(Aggregator.SubAggCollectionMode mode) {
        this.collectionMode = mode;
        return this;
    }

    public TermsBuilder showTermDocCountError(boolean showTermDocCountError) {
        this.showTermDocCountError = showTermDocCountError;
        return this;
    }

    @Override
    protected XContentBuilder doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.bucketCountThresholds.toXContent(builder);
        if (this.showTermDocCountError != null) {
            builder.field(AbstractTermsParametersParser.SHOW_TERM_DOC_COUNT_ERROR.getPreferredName(), (Object)this.showTermDocCountError);
        }
        if (this.executionHint != null) {
            builder.field(AbstractTermsParametersParser.EXECUTION_HINT_FIELD_NAME.getPreferredName(), this.executionHint);
        }
        if (this.valueType != null) {
            builder.field("value_type", this.valueType.name().toLowerCase(Locale.ROOT));
        }
        if (this.order != null) {
            builder.field("order");
            this.order.toXContent(builder, params);
        }
        if (this.collectionMode != null) {
            builder.field(Aggregator.COLLECT_MODE.getPreferredName(), this.collectionMode.parseField().getPreferredName());
        }
        if (this.includePattern != null) {
            if (this.includeFlags == 0) {
                builder.field("include", this.includePattern);
            } else {
                builder.startObject("include").field("pattern", this.includePattern).field("flags", this.includeFlags).endObject();
            }
        }
        if (this.excludePattern != null) {
            if (this.excludeFlags == 0) {
                builder.field("exclude", this.excludePattern);
            } else {
                builder.startObject("exclude").field("pattern", this.excludePattern).field("flags", this.excludeFlags).endObject();
            }
        }
        return builder;
    }
}

