/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;

public interface Terms
extends MultiBucketsAggregation {
    public List<Bucket> getBuckets();

    public Bucket getBucketByKey(String var1);

    public long getDocCountError();

    public long getSumOfOtherDocCounts();

    public static abstract class Order
    implements ToXContent {
        public static Order count(boolean asc) {
            return asc ? InternalOrder.COUNT_ASC : InternalOrder.COUNT_DESC;
        }

        public static Order term(boolean asc) {
            return asc ? InternalOrder.TERM_ASC : InternalOrder.TERM_DESC;
        }

        public static Order aggregation(String path, boolean asc) {
            return new InternalOrder.Aggregation(path, asc);
        }

        public static Order aggregation(String aggregationName, String metricName, boolean asc) {
            return new InternalOrder.Aggregation(aggregationName + "." + metricName, asc);
        }

        protected abstract Comparator<Bucket> comparator(Aggregator var1);
    }

    public static abstract class Bucket
    implements MultiBucketsAggregation.Bucket {
        public abstract Number getKeyAsNumber();

        abstract int compareTerm(Bucket var1);

        public abstract long getDocCountError();
    }

    public static enum ValueType {
        STRING(org.elasticsearch.search.aggregations.support.ValueType.STRING),
        LONG(org.elasticsearch.search.aggregations.support.ValueType.LONG),
        DOUBLE(org.elasticsearch.search.aggregations.support.ValueType.DOUBLE);

        final org.elasticsearch.search.aggregations.support.ValueType scriptValueType;

        private ValueType(org.elasticsearch.search.aggregations.support.ValueType scriptValueType) {
            this.scriptValueType = scriptValueType;
        }

        static ValueType resolveType(String type) {
            if ("string".equals(type)) {
                return STRING;
            }
            if ("double".equals(type) || "float".equals(type)) {
                return DOUBLE;
            }
            if ("long".equals(type) || "integer".equals(type) || "short".equals(type) || "byte".equals(type)) {
                return LONG;
            }
            return null;
        }
    }
}

