/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Comparator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Comparators;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.OrderPath;

class InternalOrder
extends Terms.Order {
    public static final InternalOrder COUNT_DESC = new InternalOrder(1, "_count", false, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            int cmp = -Long.compare(o1.getDocCount(), o2.getDocCount());
            if (cmp == 0) {
                cmp = o1.compareTerm(o2);
            }
            return cmp;
        }
    });
    public static final InternalOrder COUNT_ASC = new InternalOrder(2, "_count", true, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            int cmp = Long.compare(o1.getDocCount(), o2.getDocCount());
            if (cmp == 0) {
                cmp = o1.compareTerm(o2);
            }
            return cmp;
        }
    });
    public static final InternalOrder TERM_DESC = new InternalOrder(3, "_term", false, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            return -o1.compareTerm(o2);
        }
    });
    public static final InternalOrder TERM_ASC = new InternalOrder(4, "_term", true, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            return o1.compareTerm(o2);
        }
    });
    final byte id;
    final String key;
    final boolean asc;
    protected final Comparator<Terms.Bucket> comparator;

    InternalOrder(byte id, String key, boolean asc, Comparator<Terms.Bucket> comparator) {
        this.id = id;
        this.key = key;
        this.asc = asc;
        this.comparator = comparator;
    }

    byte id() {
        return this.id;
    }

    @Override
    protected Comparator<Terms.Bucket> comparator(Aggregator aggregator) {
        return this.comparator;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(this.key, this.asc ? "asc" : "desc").endObject();
    }

    public static InternalOrder validate(InternalOrder order, Aggregator termsAggregator) {
        if (!(order instanceof Aggregation)) {
            return order;
        }
        OrderPath path = ((Aggregation)order).path();
        path.validate(termsAggregator);
        return order;
    }

    public static class Streams {
        public static void writeOrder(InternalOrder order, StreamOutput out) throws IOException {
            out.writeByte(order.id());
            if (order instanceof Aggregation) {
                out.writeBoolean(((MultiBucketsAggregation.Bucket.SubAggregationComparator)order.comparator).asc());
                OrderPath path = ((Aggregation)order).path();
                if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
                    out.writeString(path.toString());
                } else {
                    OrderPath.Token token = path.lastToken();
                    out.writeString(token.name);
                    boolean hasValueName = token.key != null;
                    out.writeBoolean(hasValueName);
                    if (hasValueName) {
                        out.writeString(token.key);
                    }
                }
            }
        }

        public static InternalOrder readOrder(StreamInput in) throws IOException {
            byte id = in.readByte();
            switch (id) {
                case 1: {
                    return COUNT_DESC;
                }
                case 2: {
                    return COUNT_ASC;
                }
                case 3: {
                    return TERM_DESC;
                }
                case 4: {
                    return TERM_ASC;
                }
                case 0: {
                    boolean asc = in.readBoolean();
                    String key = in.readString();
                    if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
                        return new Aggregation(key, asc);
                    }
                    boolean hasValueNmae = in.readBoolean();
                    if (hasValueNmae) {
                        return new Aggregation(key + "." + in.readString(), asc);
                    }
                    return new Aggregation(key, asc);
                }
            }
            throw new RuntimeException("unknown terms order");
        }
    }

    static class Aggregation
    extends InternalOrder {
        static final byte ID = 0;

        Aggregation(String key, boolean asc) {
            super((byte)0, key, asc, new MultiBucketsAggregation.Bucket.SubAggregationComparator<Terms.Bucket>(key, asc));
        }

        OrderPath path() {
            return ((MultiBucketsAggregation.Bucket.SubAggregationComparator)this.comparator).path();
        }

        @Override
        protected Comparator<Terms.Bucket> comparator(Aggregator termsAggregator) {
            if (termsAggregator == null) {
                return this.comparator;
            }
            OrderPath path = this.path();
            final Aggregator aggregator = path.resolveAggregator(termsAggregator);
            final String key = path.tokens[path.tokens.length - 1].key;
            if (aggregator instanceof SingleBucketAggregator) {
                assert (key == null) : "this should be picked up before the aggregation is executed - on validate";
                return new Comparator<Terms.Bucket>(){

                    @Override
                    public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                        int mul = Aggregation.this.asc ? 1 : -1;
                        int v1 = ((SingleBucketAggregator)aggregator).bucketDocCount(((InternalTerms.Bucket)o1).bucketOrd);
                        int v2 = ((SingleBucketAggregator)aggregator).bucketDocCount(((InternalTerms.Bucket)o2).bucketOrd);
                        return mul * (v1 - v2);
                    }
                };
            }
            assert (!(aggregator instanceof BucketsAggregator)) : "this should be picked up before the aggregation is executed - on validate";
            if (aggregator instanceof NumericMetricsAggregator.MultiValue) {
                assert (key != null) : "this should be picked up before the aggregation is executed - on validate";
                return new Comparator<Terms.Bucket>(){

                    @Override
                    public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                        double v1 = ((NumericMetricsAggregator.MultiValue)aggregator).metric(key, ((InternalTerms.Bucket)o1).bucketOrd);
                        double v2 = ((NumericMetricsAggregator.MultiValue)aggregator).metric(key, ((InternalTerms.Bucket)o2).bucketOrd);
                        return Comparators.compareDiscardNaN(v1, v2, Aggregation.this.asc);
                    }
                };
            }
            return new Comparator<Terms.Bucket>(){

                @Override
                public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                    double v1 = ((NumericMetricsAggregator.SingleValue)aggregator).metric(((InternalTerms.Bucket)o1).bucketOrd);
                    double v2 = ((NumericMetricsAggregator.SingleValue)aggregator).metric(((InternalTerms.Bucket)o2).bucketOrd);
                    return Comparators.compareDiscardNaN(v1, v2, Aggregation.this.asc);
                }
            };
        }
    }
}

