/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public abstract class AbstractTermsParametersParser {
    public static final ParseField EXECUTION_HINT_FIELD_NAME = new ParseField("execution_hint", new String[0]);
    public static final ParseField SHARD_SIZE_FIELD_NAME = new ParseField("shard_size", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD_NAME = new ParseField("min_doc_count", new String[0]);
    public static final ParseField SHARD_MIN_DOC_COUNT_FIELD_NAME = new ParseField("shard_min_doc_count", new String[0]);
    public static final ParseField REQUIRED_SIZE_FIELD_NAME = new ParseField("size", new String[0]);
    public static final ParseField SHOW_TERM_DOC_COUNT_ERROR = new ParseField("show_term_doc_count_error", new String[0]);
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds();
    private String executionHint = null;
    private Aggregator.SubAggCollectionMode collectMode = Aggregator.SubAggCollectionMode.DEPTH_FIRST;
    IncludeExclude includeExclude;

    public TermsAggregator.BucketCountThresholds getBucketCountThresholds() {
        return this.bucketCountThresholds;
    }

    public String getExecutionHint() {
        return this.executionHint;
    }

    public IncludeExclude getIncludeExclude() {
        return this.includeExclude;
    }

    public Aggregator.SubAggCollectionMode getCollectionMode() {
        return this.collectMode;
    }

    public void parse(String aggregationName, XContentParser parser, SearchContext context, ValuesSourceParser vsParser, IncludeExclude.Parser incExcParser) throws IOException {
        XContentParser.Token token;
        this.bucketCountThresholds = this.getDefaultBucketCountThresholds();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser) || incExcParser.token(currentFieldName, token, parser)) continue;
            if (token == XContentParser.Token.VALUE_STRING) {
                if (EXECUTION_HINT_FIELD_NAME.match(currentFieldName)) {
                    this.executionHint = parser.text();
                    continue;
                }
                if (Aggregator.COLLECT_MODE.match(currentFieldName)) {
                    this.collectMode = Aggregator.SubAggCollectionMode.parse(parser.text());
                    continue;
                }
                this.parseSpecial(aggregationName, parser, context, token, currentFieldName);
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (REQUIRED_SIZE_FIELD_NAME.match(currentFieldName)) {
                    this.bucketCountThresholds.setRequiredSize(parser.intValue());
                    continue;
                }
                if (SHARD_SIZE_FIELD_NAME.match(currentFieldName)) {
                    this.bucketCountThresholds.setShardSize(parser.intValue());
                    continue;
                }
                if (MIN_DOC_COUNT_FIELD_NAME.match(currentFieldName)) {
                    this.bucketCountThresholds.setMinDocCount(parser.intValue());
                    continue;
                }
                if (SHARD_MIN_DOC_COUNT_FIELD_NAME.match(currentFieldName)) {
                    this.bucketCountThresholds.setShardMinDocCount(parser.longValue());
                    continue;
                }
                this.parseSpecial(aggregationName, parser, context, token, currentFieldName);
                continue;
            }
            this.parseSpecial(aggregationName, parser, context, token, currentFieldName);
        }
        this.includeExclude = incExcParser.includeExclude();
    }

    public abstract void parseSpecial(String var1, XContentParser var2, SearchContext var3, XContentParser.Token var4, String var5) throws IOException;

    protected abstract TermsAggregator.BucketCountThresholds getDefaultBucketCountThresholds();
}

