/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import org.elasticsearch.common.Classes;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositorySettings;
import org.elasticsearch.repositories.RepositoryTypesRegistry;

public class RepositoryModule
extends AbstractModule
implements SpawnModules {
    private RepositoryName repositoryName;
    private final Settings globalSettings;
    private final Settings settings;
    private final RepositoryTypesRegistry typesRegistry;

    public RepositoryModule(RepositoryName repositoryName, Settings settings, Settings globalSettings, RepositoryTypesRegistry typesRegistry) {
        this.repositoryName = repositoryName;
        this.globalSettings = globalSettings;
        this.settings = settings;
        this.typesRegistry = typesRegistry;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        return ImmutableList.of(Modules.createModule(this.loadTypeModule(this.repositoryName.type(), "org.elasticsearch.repositories.", "RepositoryModule"), this.globalSettings));
    }

    @Override
    protected void configure() {
        this.bind(RepositorySettings.class).toInstance(new RepositorySettings(this.globalSettings, this.settings));
    }

    private Class<? extends Module> loadTypeModule(String type, String prefixPackage, String suffixClassName) {
        Class<? extends Module> registered = this.typesRegistry.type(type);
        if (registered != null) {
            return registered;
        }
        return Classes.loadClass(this.globalSettings.getClassLoader(), type, prefixPackage, suffixClassName);
    }
}

