/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class WrapperFilterParser
implements FilterParser {
    public static final String NAME = "wrapper";

    @Inject
    public WrapperFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[wrapper] filter malformed");
        }
        String fieldName = parser.currentName();
        if (!fieldName.equals("filter")) {
            throw new QueryParsingException(parseContext.index(), "[wrapper] filter malformed");
        }
        parser.nextToken();
        byte[] querySource = parser.binaryValue();
        try (XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);){
            QueryParseContext context = new QueryParseContext(parseContext.index(), parseContext.indexQueryParserService());
            context.reset(qSourceParser);
            Filter result = context.parseInnerFilter();
            parser.nextToken();
            Filter filter = result;
            return filter;
        }
    }
}

