/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.SimpleQueryStringFlag;

public class SimpleQueryStringBuilder
extends BaseQueryBuilder {
    private Map<String, Float> fields = new HashMap<String, Float>();
    private String analyzer;
    private Operator operator;
    private final String queryText;
    private String queryName;
    private int flags = -1;
    private Boolean lowercaseExpandedTerms;
    private Boolean lenient;
    private Locale locale;

    public SimpleQueryStringBuilder(String text) {
        this.queryText = text;
    }

    public SimpleQueryStringBuilder field(String field) {
        this.fields.put(field, null);
        return this;
    }

    public SimpleQueryStringBuilder field(String field, float boost) {
        this.fields.put(field, Float.valueOf(boost));
        return this;
    }

    public SimpleQueryStringBuilder queryName(String name) {
        this.queryName = name;
        return this;
    }

    public SimpleQueryStringBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public SimpleQueryStringBuilder defaultOperator(Operator defaultOperator) {
        this.operator = defaultOperator;
        return this;
    }

    public SimpleQueryStringBuilder flags(SimpleQueryStringFlag ... flags) {
        int value = 0;
        if (flags.length == 0) {
            value = SimpleQueryStringFlag.ALL.value;
        } else {
            for (SimpleQueryStringFlag flag : flags) {
                value |= flag.value;
            }
        }
        this.flags = value;
        return this;
    }

    public SimpleQueryStringBuilder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        return this;
    }

    public SimpleQueryStringBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public SimpleQueryStringBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("simple_query_string");
        builder.field("query", this.queryText);
        if (this.fields.size() > 0) {
            builder.startArray("fields");
            for (Map.Entry<String, Float> entry : this.fields.entrySet()) {
                String field = entry.getKey();
                Float boost = entry.getValue();
                if (boost != null) {
                    builder.value(field + "^" + boost);
                    continue;
                }
                builder.value(field);
            }
            builder.endArray();
        }
        if (this.flags != -1) {
            builder.field("flags", this.flags);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.operator != null) {
            builder.field("default_operator", this.operator.name().toLowerCase(Locale.ROOT));
        }
        if (this.lowercaseExpandedTerms != null) {
            builder.field("lowercase_expanded_terms", (Object)this.lowercaseExpandedTerms);
        }
        if (this.lenient != null) {
            builder.field("lenient", (Object)this.lenient);
        }
        if (this.locale != null) {
            builder.field("locale", this.locale.toString());
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }

    public static enum Operator {
        AND,
        OR;

    }
}

