/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import org.apache.lucene.index.LogDocMergePolicy;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.policy.AbstractMergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.store.Store;

public class LogDocMergePolicyProvider
extends AbstractMergePolicyProvider<LogDocMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    private final ApplySettings applySettings = new ApplySettings();
    private final LogDocMergePolicy mergePolicy = new LogDocMergePolicy();
    public static final String MAX_MERGE_DOCS_KEY = "index.merge.policy.max_merge_docs";
    public static final String MIN_MERGE_DOCS_KEY = "index.merge.policy.min_merge_docs";
    public static final String MERGE_FACTORY_KEY = "index.merge.policy.merge_factor";
    public static final String INDEX_MERGE_POLICY_MIN_MERGE_DOCS = "index.merge.policy.min_merge_docs";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_DOCS = "index.merge.policy.max_merge_docs";
    public static final String INDEX_MERGE_POLICY_MERGE_FACTOR = "index.merge.policy.merge_factor";
    public static final String INDEX_MERGE_POLICY_CALIBRATE_SIZE_BY_DELETES = "index.merge.policy.calibrate_size_by_deletes";

    @Inject
    public LogDocMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store);
        Preconditions.checkNotNull(store, "Store must be provided to merge policy");
        this.indexSettingsService = indexSettingsService;
        int minMergeDocs = this.componentSettings.getAsInt("min_merge_docs", (Integer)1000);
        int maxMergeDocs = this.componentSettings.getAsInt("max_merge_docs", (Integer)Integer.MAX_VALUE);
        int mergeFactor = this.componentSettings.getAsInt("merge_factor", (Integer)10);
        boolean calibrateSizeByDeletes = this.componentSettings.getAsBoolean("calibrate_size_by_deletes", (Boolean)true);
        this.mergePolicy.setMinMergeDocs(minMergeDocs);
        this.mergePolicy.setMaxMergeDocs(maxMergeDocs);
        this.mergePolicy.setMergeFactor(mergeFactor);
        this.mergePolicy.setCalibrateSizeByDeletes(calibrateSizeByDeletes);
        this.mergePolicy.setNoCFSRatio(this.noCFSRatio);
        this.logger.debug("using [log_doc] merge policy with merge_factor[{}], min_merge_docs[{}], max_merge_docs[{}], calibrate_size_by_deletes[{}]", mergeFactor, minMergeDocs, maxMergeDocs, calibrateSizeByDeletes);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public void close() throws ElasticsearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    @Override
    public LogDocMergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            double noCFSRatio;
            int oldMinMergeDocs = LogDocMergePolicyProvider.this.mergePolicy.getMinMergeDocs();
            int minMergeDocs = settings.getAsInt("index.merge.policy.min_merge_docs", (Integer)1000);
            if (minMergeDocs != oldMinMergeDocs) {
                LogDocMergePolicyProvider.this.logger.info("updating min_merge_docs from [{}] to [{}]", oldMinMergeDocs, minMergeDocs);
                LogDocMergePolicyProvider.this.mergePolicy.setMinMergeDocs(minMergeDocs);
            }
            int oldMaxMergeDocs = LogDocMergePolicyProvider.this.mergePolicy.getMaxMergeDocs();
            int maxMergeDocs = settings.getAsInt("index.merge.policy.max_merge_docs", (Integer)Integer.MAX_VALUE);
            if (maxMergeDocs != oldMaxMergeDocs) {
                LogDocMergePolicyProvider.this.logger.info("updating max_merge_docs from [{}] to [{}]", oldMaxMergeDocs, maxMergeDocs);
                LogDocMergePolicyProvider.this.mergePolicy.setMaxMergeDocs(maxMergeDocs);
            }
            int oldMergeFactor = LogDocMergePolicyProvider.this.mergePolicy.getMergeFactor();
            int mergeFactor = settings.getAsInt("index.merge.policy.merge_factor", (Integer)10);
            if (mergeFactor != oldMergeFactor) {
                LogDocMergePolicyProvider.this.logger.info("updating merge_factor from [{}] to [{}]", oldMergeFactor, mergeFactor);
                LogDocMergePolicyProvider.this.mergePolicy.setMergeFactor(mergeFactor);
            }
            boolean oldCalibrateSizeByDeletes = LogDocMergePolicyProvider.this.mergePolicy.getCalibrateSizeByDeletes();
            boolean calibrateSizeByDeletes = settings.getAsBoolean(LogDocMergePolicyProvider.INDEX_MERGE_POLICY_CALIBRATE_SIZE_BY_DELETES, (Boolean)true);
            if (calibrateSizeByDeletes != oldCalibrateSizeByDeletes) {
                LogDocMergePolicyProvider.this.logger.info("updating calibrate_size_by_deletes from [{}] to [{}]", oldCalibrateSizeByDeletes, calibrateSizeByDeletes);
                LogDocMergePolicyProvider.this.mergePolicy.setCalibrateSizeByDeletes(calibrateSizeByDeletes);
            }
            if ((noCFSRatio = AbstractMergePolicyProvider.parseNoCFSRatio(settings.get("index.compound_format", Double.toString(LogDocMergePolicyProvider.this.noCFSRatio)))) != LogDocMergePolicyProvider.this.noCFSRatio) {
                LogDocMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", AbstractMergePolicyProvider.formatNoCFSRatio(LogDocMergePolicyProvider.this.noCFSRatio), AbstractMergePolicyProvider.formatNoCFSRatio(noCFSRatio));
                LogDocMergePolicyProvider.this.noCFSRatio = noCFSRatio;
                LogDocMergePolicyProvider.this.mergePolicy.setNoCFSRatio(noCFSRatio);
            }
        }
    }
}

