/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;

public class FsBlobContainer
extends AbstractBlobContainer {
    protected final FsBlobStore blobStore;
    protected final File path;

    public FsBlobContainer(FsBlobStore blobStore, BlobPath blobPath, File path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public File filePath() {
        return this.path;
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        File[] files = this.path.listFiles();
        if (files == null || files.length == 0) {
            return ImmutableMap.of();
        }
        MapBuilder<String, PlainBlobMetaData> builder = MapBuilder.newMapBuilder();
        for (File file : files) {
            if (!file.isFile()) continue;
            builder.put(file.getName(), new PlainBlobMetaData(file.getName(), file.length()));
        }
        return builder.immutableMap();
    }

    @Override
    public boolean deleteBlob(String blobName) throws IOException {
        return new File(this.path, blobName).delete();
    }

    @Override
    public boolean blobExists(String blobName) {
        return new File(this.path, blobName).exists();
    }

    @Override
    public InputStream openInput(String name) throws IOException {
        return new BufferedInputStream(new FileInputStream(new File(this.path, name)), this.blobStore.bufferSizeInBytes());
    }

    @Override
    public OutputStream createOutput(String blobName) throws IOException {
        final File file = new File(this.path, blobName);
        return new BufferedOutputStream(new FilterOutputStream(new FileOutputStream(file)){

            @Override
            public void close() throws IOException {
                super.close();
                IOUtils.fsync((File)file, (boolean)false);
                IOUtils.fsync((File)FsBlobContainer.this.path, (boolean)true);
            }
        }, this.blobStore.bufferSizeInBytes());
    }
}

