/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.shard.service.IndexShard;

public class ShardStats
extends BroadcastShardOperationResponse
implements ToXContent {
    private ShardRouting shardRouting;
    CommonStats stats;

    ShardStats() {
    }

    public ShardStats(IndexShard indexShard, ShardRouting shardRouting, CommonStatsFlags flags) {
        super(indexShard.shardId());
        this.shardRouting = shardRouting;
        this.stats = new CommonStats(indexShard, flags);
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public CommonStats getStats() {
        return this.stats;
    }

    public static ShardStats readShardStats(StreamInput in) throws IOException {
        ShardStats stats = new ShardStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardRouting = ImmutableShardRouting.readShardRoutingEntry(in);
        this.stats = CommonStats.readCommonStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardRouting.writeTo(out);
        this.stats.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.ROUTING).field(Fields.STATE, (Object)this.shardRouting.state()).field(Fields.PRIMARY, this.shardRouting.primary()).field(Fields.NODE, this.shardRouting.currentNodeId()).field(Fields.RELOCATING_NODE, this.shardRouting.relocatingNodeId()).endObject();
        this.stats.toXContent(builder, params);
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString ROUTING = new XContentBuilderString("routing");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");
        static final XContentBuilderString NODE = new XContentBuilderString("node");
        static final XContentBuilderString RELOCATING_NODE = new XContentBuilderString("relocating_node");

        Fields() {
        }
    }
}

