/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetIndexAction
extends TransportClusterInfoAction<GetIndexRequest, GetIndexResponse> {
    @Inject
    public TransportGetIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings, "indices:admin/get", transportService, clusterService, threadPool, actionFilters);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(GetIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, state.metaData().concreteIndices(request.indicesOptions(), request.indices()));
    }

    @Override
    protected GetIndexRequest newRequest() {
        return new GetIndexRequest();
    }

    @Override
    protected GetIndexResponse newResponse() {
        return new GetIndexResponse();
    }

    @Override
    protected void doMasterOperation(GetIndexRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetIndexResponse> listener) throws ElasticsearchException {
        ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> warmersResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappingsResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, ImmutableList<AliasMetaData>> aliasesResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
        String[] features = request.features();
        boolean doneAliases = false;
        boolean doneMappings = false;
        boolean doneSettings = false;
        boolean doneWarmers = false;
        String[] arr$ = features;
        int len$ = arr$.length;
        block15: for (int i$ = 0; i$ < len$; ++i$) {
            String feature;
            switch (feature = arr$[i$]) {
                case "_warmer": 
                case "_warmers": {
                    if (doneWarmers) continue block15;
                    warmersResult = state.metaData().findWarmers(concreteIndices, request.types(), Strings.EMPTY_ARRAY);
                    doneWarmers = true;
                    continue block15;
                }
                case "_mapping": 
                case "_mappings": {
                    if (doneMappings) continue block15;
                    mappingsResult = state.metaData().findMappings(concreteIndices, request.types());
                    doneMappings = true;
                    continue block15;
                }
                case "_alias": 
                case "_aliases": {
                    if (doneAliases) continue block15;
                    aliasesResult = state.metaData().findAliases(Strings.EMPTY_ARRAY, concreteIndices);
                    doneAliases = true;
                    continue block15;
                }
                case "_settings": {
                    if (doneSettings) continue block15;
                    ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
                    for (String index : concreteIndices) {
                        settingsMapBuilder.put(index, state.metaData().index(index).getSettings());
                    }
                    settings = settingsMapBuilder.build();
                    doneSettings = true;
                    continue block15;
                }
                default: {
                    throw new ElasticsearchIllegalStateException("feature [" + feature + "] is not valid");
                }
            }
        }
        listener.onResponse(new GetIndexResponse(concreteIndices, warmersResult, mappingsResult, aliasesResult, settings));
    }
}

