/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;

public abstract class NoCacheFilter
extends Filter {
    public static Filter wrap(Filter filter) {
        if (filter instanceof NoCacheFilter) {
            return filter;
        }
        return new NoCacheFilterWrapper(filter);
    }

    private static final class NoCacheFilterWrapper
    extends NoCacheFilter {
        private final Filter delegate;

        private NoCacheFilterWrapper(Filter delegate) {
            this.delegate = delegate;
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            return this.delegate.getDocIdSet(context, acceptDocs);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NoCacheFilterWrapper) {
                return this.delegate.equals(((NoCacheFilterWrapper)((Object)obj)).delegate);
            }
            return false;
        }

        public String toString() {
            return "no_cache(" + this.delegate + ")";
        }
    }
}

