/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.TimeoutClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.cluster.metadata.RestoreMetaData;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RestoreService
extends AbstractComponent
implements ClusterStateListener {
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final AllocationService allocationService;
    private final MetaDataCreateIndexService createIndexService;
    private final CopyOnWriteArrayList<RestoreCompletionListener> listeners = new CopyOnWriteArrayList();

    @Inject
    public RestoreService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService, AllocationService allocationService, MetaDataCreateIndexService createIndexService) {
        super(settings);
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        transportService.registerHandler("cluster/snapshot/update_restore", new UpdateRestoreStateRequestHandler());
        clusterService.add(this);
    }

    public void restoreSnapshot(final RestoreRequest request, final RestoreSnapshotListener listener) {
        try {
            Repository repository = this.repositoriesService.repository(request.repository());
            final SnapshotId snapshotId = new SnapshotId(request.repository(), request.name());
            final Snapshot snapshot = repository.readSnapshot(snapshotId);
            ImmutableList<String> filteredIndices = SnapshotUtils.filterIndices(snapshot.indices(), request.indices(), request.indicesOptions());
            final MetaData metaData = repository.readSnapshotMetaData(snapshotId, filteredIndices);
            if (snapshot.state() != SnapshotState.SUCCESS) {
                throw new SnapshotRestoreException(snapshotId, "unsupported snapshot state [" + (Object)((Object)snapshot.state()) + "]");
            }
            if (Version.CURRENT.before(snapshot.version())) {
                throw new SnapshotRestoreException(snapshotId, "incompatible snapshot version [" + snapshot.version() + "]");
            }
            final HashMap<String, String> renamedIndices = Maps.newHashMap();
            Iterator i$ = filteredIndices.iterator();
            while (i$.hasNext()) {
                String previousIndex;
                String index;
                String renamedIndex = index = (String)i$.next();
                if (request.renameReplacement() != null && request.renamePattern() != null) {
                    renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
                }
                if ((previousIndex = renamedIndices.put(renamedIndex, index)) == null) continue;
                throw new SnapshotRestoreException(snapshotId, "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
            }
            this.clusterService.submitStateUpdateTask(request.cause(), new TimeoutClusterStateUpdateTask(){
                RestoreInfo restoreInfo = null;

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RestoreMetaData restoreMetaData = (RestoreMetaData)currentState.metaData().custom("restore");
                    if (restoreMetaData != null && !restoreMetaData.entries().isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(snapshotId, "Restore process is already running in this cluster");
                    }
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
                    if (!metaData.indices().isEmpty()) {
                        ImmutableMap.Builder<ShardId, RestoreMetaData.ShardRestoreStatus> shards = ImmutableMap.builder();
                        for (Map.Entry indexEntry : renamedIndices.entrySet()) {
                            IndexMetaData updatedIndexMetaData;
                            IndexMetaData.Builder indexMdBuilder;
                            String index = (String)indexEntry.getValue();
                            if (RestoreService.this.failed(snapshot, index)) {
                                throw new SnapshotRestoreException(snapshotId, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                            }
                            RestoreSource restoreSource = new RestoreSource(snapshotId, index);
                            String renamedIndex = (String)indexEntry.getKey();
                            IndexMetaData snapshotIndexMetaData = metaData.index(index);
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(renamedIndex);
                            if (currentIndexMetaData == null) {
                                RestoreService.this.createIndexService.validateIndexName(renamedIndex, currentState);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN).index(renamedIndex);
                                updatedIndexMetaData = indexMdBuilder.build();
                                rtBuilder.addAsNewRestore(updatedIndexMetaData, restoreSource);
                                mdBuilder.put(updatedIndexMetaData, true);
                            } else {
                                if (currentIndexMetaData.state() != IndexMetaData.State.CLOSE) {
                                    throw new SnapshotRestoreException(snapshotId, "cannot restore index [" + renamedIndex + "] because it's open");
                                }
                                if (currentIndexMetaData.getNumberOfShards() != snapshotIndexMetaData.getNumberOfShards()) {
                                    throw new SnapshotRestoreException(snapshotId, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetaData.getNumberOfShards() + "] shard from snapshot with [" + snapshotIndexMetaData.getNumberOfShards() + "] shards");
                                }
                                indexMdBuilder = IndexMetaData.builder(currentIndexMetaData).state(IndexMetaData.State.OPEN);
                                updatedIndexMetaData = indexMdBuilder.index(renamedIndex).build();
                                rtBuilder.addAsRestore(updatedIndexMetaData, restoreSource);
                                blocks.removeIndexBlock(index, MetaDataIndexStateService.INDEX_CLOSED_BLOCK);
                                mdBuilder.put(updatedIndexMetaData, true);
                            }
                            for (int shard = 0; shard < snapshotIndexMetaData.getNumberOfShards(); ++shard) {
                                shards.put(new ShardId(renamedIndex, shard), new RestoreMetaData.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().localNodeId()));
                            }
                        }
                        RestoreMetaData.Entry entry = new RestoreMetaData.Entry(snapshotId, RestoreMetaData.State.INIT, ImmutableList.copyOf(renamedIndices.keySet()), shards.build());
                        mdBuilder.putCustom("restore", new RestoreMetaData(entry));
                    }
                    if (request.includeGlobalState()) {
                        if (metaData.persistentSettings() != null) {
                            mdBuilder.persistentSettings(metaData.persistentSettings());
                        }
                        if (metaData.templates() != null) {
                            for (ObjectCursor objectCursor : metaData.templates().values()) {
                                mdBuilder.put((IndexTemplateMetaData)objectCursor.value);
                            }
                        }
                        if (metaData.customs() != null) {
                            for (ObjectObjectCursor objectObjectCursor : metaData.customs()) {
                                if ("repositories".equals(objectObjectCursor.key)) continue;
                                mdBuilder.putCustom((String)objectObjectCursor.key, (MetaData.Custom)objectObjectCursor.value);
                            }
                        }
                    }
                    if (metaData.indices().isEmpty()) {
                        this.restoreInfo = new RestoreInfo(request.name(), ImmutableList.<String>of(), 0, 0);
                    }
                    ClusterState updatedState = ClusterState.builder(currentState).metaData(mdBuilder).blocks(blocks).routingTable(rtBuilder).build();
                    RoutingAllocation.Result result = RestoreService.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(rtBuilder).build());
                    return ClusterState.builder(updatedState).routingResult(result).build();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    RestoreService.this.logger.warn("[{}] failed to restore snapshot", t, snapshotId);
                    listener.onFailure(t);
                }

                @Override
                public TimeValue timeout() {
                    return request.masterNodeTimeout();
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(this.restoreInfo);
                }
            });
        }
        catch (Throwable e) {
            this.logger.warn("[{}][{}] failed to restore snapshot", e, request.repository(), request.name());
            listener.onFailure(e);
        }
    }

    public void indexShardRestoreCompleted(SnapshotId snapshotId, ShardId shardId) {
        this.logger.trace("[{}] successfully restored shard  [{}]", snapshotId, shardId);
        UpdateIndexShardRestoreStatusRequest request = new UpdateIndexShardRestoreStatusRequest(snapshotId, shardId, new RestoreMetaData.ShardRestoreStatus(this.clusterService.state().nodes().localNodeId(), RestoreMetaData.State.SUCCESS));
        if (this.clusterService.state().nodes().localNodeMaster()) {
            this.innerUpdateRestoreState(request);
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/snapshot/update_restore", request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerUpdateRestoreState(final UpdateIndexShardRestoreStatusRequest request) {
        this.clusterService.submitStateUpdateTask("update snapshot state", new ProcessedClusterStateUpdateTask(){
            private boolean completed = true;
            private RestoreInfo restoreInfo = null;

            @Override
            public ClusterState execute(ClusterState currentState) {
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                RestoreMetaData restore = (RestoreMetaData)metaData.custom("restore");
                if (restore != null) {
                    boolean changed = false;
                    ArrayList<RestoreMetaData.Entry> entries = Lists.newArrayList();
                    for (RestoreMetaData.Entry entry : restore.entries()) {
                        if (entry.snapshotId().equals(request.snapshotId())) {
                            HashMap<ShardId, RestoreMetaData.ShardRestoreStatus> shards = Maps.newHashMap(entry.shards());
                            RestoreService.this.logger.trace("[{}] Updating shard [{}] with status [{}]", new Object[]{request.snapshotId(), request.shardId(), request.status().state()});
                            shards.put(request.shardId(), request.status());
                            for (RestoreMetaData.ShardRestoreStatus status : shards.values()) {
                                if (status.state().completed()) continue;
                                this.completed = false;
                                break;
                            }
                            if (!this.completed) {
                                entries.add(new RestoreMetaData.Entry(entry.snapshotId(), RestoreMetaData.State.STARTED, entry.indices(), ImmutableMap.copyOf(shards)));
                            } else {
                                RestoreService.this.logger.info("restore [{}] is done", request.snapshotId());
                                int failedShards = 0;
                                for (RestoreMetaData.ShardRestoreStatus status : shards.values()) {
                                    if (status.state() != RestoreMetaData.State.FAILURE) continue;
                                    ++failedShards;
                                }
                                this.restoreInfo = new RestoreInfo(entry.snapshotId().getSnapshot(), entry.indices(), shards.size(), shards.size() - failedShards);
                            }
                            changed = true;
                            continue;
                        }
                        entries.add(entry);
                    }
                    if (changed) {
                        restore = new RestoreMetaData(entries.toArray(new RestoreMetaData.Entry[entries.size()]));
                        mdBuilder.putCustom("restore", restore);
                        return ClusterState.builder(currentState).metaData(mdBuilder).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Throwable t) {
                RestoreService.this.logger.warn("[{}][{}] failed to update snapshot status to [{}]", t, request.snapshotId(), request.shardId(), request.status());
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.restoreInfo != null) {
                    for (RestoreCompletionListener listener : RestoreService.this.listeners) {
                        try {
                            listener.onRestoreCompletion(request.snapshotId, this.restoreInfo);
                        }
                        catch (Throwable e) {
                            RestoreService.this.logger.warn("failed to update snapshot status for [{}]", e, listener);
                        }
                    }
                }
            }
        });
    }

    private void processDeletedIndices(ClusterChangedEvent event) {
        MetaData metaData = event.state().metaData();
        RestoreMetaData restore = (RestoreMetaData)metaData.custom("restore");
        if (restore == null) {
            return;
        }
        if (!event.indicesDeleted().isEmpty()) {
            for (RestoreMetaData.Entry entry : restore.entries()) {
                ArrayList<ShardId> shardsToFail = null;
                for (Map.Entry shard : entry.shards().entrySet()) {
                    if (((RestoreMetaData.ShardRestoreStatus)shard.getValue()).state().completed() || event.state().metaData().hasIndex(((ShardId)shard.getKey()).getIndex())) continue;
                    if (shardsToFail == null) {
                        shardsToFail = Lists.newArrayList();
                    }
                    shardsToFail.add((ShardId)shard.getKey());
                }
                if (shardsToFail == null) continue;
                for (ShardId shardId : shardsToFail) {
                    this.logger.trace("[{}] failing running shard restore [{}]", entry.snapshotId(), shardId);
                    this.innerUpdateRestoreState(new UpdateIndexShardRestoreStatusRequest(entry.snapshotId(), shardId, new RestoreMetaData.ShardRestoreStatus(null, RestoreMetaData.State.FAILURE, "index was deleted")));
                }
            }
        }
    }

    private boolean failed(Snapshot snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    private boolean failed(Snapshot snapshot, String index, int shard) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index()) || shard != failure.shardId()) continue;
            return true;
        }
        return false;
    }

    public void addListener(RestoreCompletionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RestoreCompletionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.processDeletedIndices(event);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to update restore state ", t, new Object[0]);
        }
    }

    public static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        MetaData metaData = clusterState.metaData();
        RestoreMetaData snapshots = (RestoreMetaData)metaData.custom("restore");
        if (snapshots != null) {
            for (RestoreMetaData.Entry snapshot : snapshots.entries()) {
                if (!repository.equals(snapshot.snapshotId().getRepository())) continue;
                return true;
            }
        }
        return false;
    }

    private class UpdateRestoreStateRequestHandler
    extends BaseTransportRequestHandler<UpdateIndexShardRestoreStatusRequest> {
        static final String ACTION = "cluster/snapshot/update_restore";

        private UpdateRestoreStateRequestHandler() {
        }

        @Override
        public UpdateIndexShardRestoreStatusRequest newInstance() {
            return new UpdateIndexShardRestoreStatusRequest();
        }

        @Override
        public void messageReceived(UpdateIndexShardRestoreStatusRequest request, TransportChannel channel) throws Exception {
            RestoreService.this.innerUpdateRestoreState(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private static class UpdateIndexShardRestoreStatusRequest
    extends TransportRequest {
        private SnapshotId snapshotId;
        private ShardId shardId;
        private RestoreMetaData.ShardRestoreStatus status;

        private UpdateIndexShardRestoreStatusRequest() {
        }

        private UpdateIndexShardRestoreStatusRequest(SnapshotId snapshotId, ShardId shardId, RestoreMetaData.ShardRestoreStatus status) {
            this.snapshotId = snapshotId;
            this.shardId = shardId;
            this.status = status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshotId = SnapshotId.readSnapshotId(in);
            this.shardId = ShardId.readShardId(in);
            this.status = RestoreMetaData.ShardRestoreStatus.readShardRestoreStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshotId.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public RestoreMetaData.ShardRestoreStatus status() {
            return this.status;
        }
    }

    public static interface RestoreCompletionListener {
        public void onRestoreCompletion(SnapshotId var1, RestoreInfo var2);
    }

    public static interface RestoreSnapshotListener {
        public void onResponse(RestoreInfo var1);

        public void onFailure(Throwable var1);
    }

    public static class RestoreRequest {
        private String cause;
        private String name;
        private String repository;
        private String[] indices;
        private String renamePattern;
        private String renameReplacement;
        private IndicesOptions indicesOptions = IndicesOptions.strict();
        private Settings settings;
        private TimeValue masterNodeTimeout;
        private boolean includeGlobalState = false;

        public RestoreRequest(String cause, String repository, String name) {
            this.cause = cause;
            this.name = name;
            this.repository = repository;
        }

        public RestoreRequest indices(String[] indices) {
            this.indices = indices;
            return this;
        }

        public RestoreRequest indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public RestoreRequest includeGlobalState(boolean includeGlobalState) {
            this.includeGlobalState = includeGlobalState;
            return this;
        }

        public RestoreRequest settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public RestoreRequest masterNodeTimeout(TimeValue masterNodeTimeout) {
            this.masterNodeTimeout = masterNodeTimeout;
            return this;
        }

        public RestoreRequest renamePattern(String renamePattern) {
            this.renamePattern = renamePattern;
            return this;
        }

        public RestoreRequest renameReplacement(String renameReplacement) {
            this.renameReplacement = renameReplacement;
            return this;
        }

        public String cause() {
            return this.cause;
        }

        public String name() {
            return this.name;
        }

        public String repository() {
            return this.repository;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public String renamePattern() {
            return this.renamePattern;
        }

        public String renameReplacement() {
            return this.renameReplacement;
        }

        public Settings settings() {
            return this.settings;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public TimeValue masterNodeTimeout() {
            return this.masterNodeTimeout;
        }
    }
}

