/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoringRewrite;
import org.apache.lucene.search.TopTermsRewrite;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.postingshighlight.CustomPassageFormatter;
import org.apache.lucene.search.postingshighlight.CustomPostingsHighlighter;
import org.apache.lucene.search.postingshighlight.Snippet;
import org.apache.lucene.search.postingshighlight.WholeBreakIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightUtils;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.HighlighterContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class PostingsHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-postings";

    @Override
    public String[] names() {
        return new String[]{"postings", "postings-highlighter"};
    }

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        FieldMapper<?> fieldMapper = highlighterContext.mapper;
        SearchContextHighlight.Field field = highlighterContext.field;
        if (fieldMapper.fieldType().indexOptions() != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
            throw new ElasticsearchIllegalArgumentException("the field [" + field.field() + "] should be indexed with positions and offsets in the postings list to be used with postings highlighter");
        }
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            Query query;
            try {
                query = PostingsHighlighter.rewrite(highlighterContext, hitContext.topLevelReader());
            }
            catch (IOException e) {
                throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
            }
            SortedSet<Term> queryTerms = PostingsHighlighter.extractTerms(query);
            hitContext.cache().put(CACHE_KEY, new HighlighterEntry(queryTerms));
        }
        HighlighterEntry highlighterEntry = (HighlighterEntry)hitContext.cache().get(CACHE_KEY);
        MapperHighlighterEntry mapperHighlighterEntry = highlighterEntry.mappers.get(fieldMapper);
        if (mapperHighlighterEntry == null) {
            Encoder encoder = field.encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
            CustomPassageFormatter passageFormatter = new CustomPassageFormatter(field.preTags()[0], field.postTags()[0], encoder);
            BytesRef[] filteredQueryTerms = PostingsHighlighter.filterTerms(highlighterEntry.queryTerms, fieldMapper.names().indexName(), field.requireFieldMatch());
            mapperHighlighterEntry = new MapperHighlighterEntry(passageFormatter, filteredQueryTerms);
        }
        boolean mergeValues = field.numberOfFragments() != 0;
        List<Snippet> snippets = new ArrayList<Snippet>();
        try {
            int numberOfFragments;
            List<Object> textsToHighlight = HighlightUtils.loadFieldValues(fieldMapper, context, hitContext, field.forceSource());
            CustomPostingsHighlighter highlighter = new CustomPostingsHighlighter(mapperHighlighterEntry.passageFormatter, textsToHighlight, mergeValues, 0x7FFFFFFE, field.noMatchSize());
            if (field.numberOfFragments() == 0) {
                highlighter.setBreakIterator((BreakIterator)new WholeBreakIterator());
                numberOfFragments = 1;
            } else {
                numberOfFragments = field.numberOfFragments();
            }
            int values = mergeValues ? 1 : textsToHighlight.size();
            for (int i = 0; i < values; ++i) {
                Snippet[] fieldSnippets = highlighter.highlightDoc(fieldMapper.names().indexName(), mapperHighlighterEntry.filteredQueryTerms, hitContext.searcher(), hitContext.docId(), numberOfFragments);
                if (fieldSnippets == null) continue;
                for (Snippet fieldSnippet : fieldSnippets) {
                    if (!Strings.hasText(fieldSnippet.getText())) continue;
                    snippets.add(fieldSnippet);
                }
            }
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        snippets = PostingsHighlighter.filterSnippets(snippets, field.numberOfFragments());
        if (field.scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(snippets, (Comparator)new Comparator<Snippet>(){

                @Override
                public int compare(Snippet o1, Snippet o2) {
                    return (int)Math.signum(o2.getScore() - o1.getScore());
                }
            });
        }
        String[] fragments = new String[snippets.size()];
        for (int i = 0; i < fragments.length; ++i) {
            fragments[i] = snippets.get(i).getText();
        }
        if (fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, StringText.convertFromStringArray(fragments));
        }
        return null;
    }

    private static Query rewrite(HighlighterContext highlighterContext, IndexReader reader) throws IOException {
        boolean mustRewrite = !highlighterContext.query.queryRewritten();
        Query original = highlighterContext.query.originalQuery();
        MultiTermQuery originalMultiTermQuery = null;
        MultiTermQuery.RewriteMethod originalRewriteMethod = null;
        if (original instanceof MultiTermQuery && !PostingsHighlighter.allowsForTermExtraction((originalMultiTermQuery = (MultiTermQuery)original).getRewriteMethod())) {
            originalRewriteMethod = originalMultiTermQuery.getRewriteMethod();
            originalMultiTermQuery.setRewriteMethod((MultiTermQuery.RewriteMethod)new MultiTermQuery.TopTermsScoringBooleanQueryRewrite(50));
            mustRewrite = true;
        }
        if (!mustRewrite) {
            return highlighterContext.query.query();
        }
        Query query = original;
        Query rewrittenQuery = query.rewrite(reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(reader);
        }
        if (originalMultiTermQuery != null && originalRewriteMethod != null) {
            originalMultiTermQuery.setRewriteMethod(originalRewriteMethod);
        }
        return query;
    }

    private static boolean allowsForTermExtraction(MultiTermQuery.RewriteMethod rewriteMethod) {
        return rewriteMethod instanceof TopTermsRewrite || rewriteMethod instanceof ScoringRewrite;
    }

    private static SortedSet<Term> extractTerms(Query query) {
        TreeSet<Term> queryTerms = new TreeSet<Term>();
        query.extractTerms(queryTerms);
        return queryTerms;
    }

    private static BytesRef[] filterTerms(SortedSet<Term> queryTerms, String field, boolean requireFieldMatch) {
        SortedSet<Term> fieldTerms;
        if (requireFieldMatch) {
            Term floor = new Term(field, "");
            Term ceiling = new Term(field, UnicodeUtil.BIG_TERM);
            fieldTerms = queryTerms.subSet(floor, ceiling);
        } else {
            fieldTerms = queryTerms;
        }
        BytesRef[] terms = new BytesRef[fieldTerms.size()];
        int termUpto = 0;
        for (Term term : fieldTerms) {
            terms[termUpto++] = term.bytes();
        }
        return terms;
    }

    private static List<Snippet> filterSnippets(List<Snippet> snippets, int numberOfFragments) {
        ArrayList<Snippet> filteredSnippets = new ArrayList<Snippet>(snippets.size());
        for (Snippet snippet : snippets) {
            if (!snippet.isHighlighted()) continue;
            filteredSnippets.add(snippet);
        }
        if (filteredSnippets.size() == 0 && snippets.size() > 0) {
            Snippet snippet = snippets.get(0);
            if (numberOfFragments == 0) {
                BreakIterator bi = BreakIterator.getSentenceInstance(Locale.ROOT);
                String text = snippet.getText();
                bi.setText(text);
                int next = bi.next();
                if (next != -1) {
                    String newText = text.substring(0, next).trim();
                    snippet = new Snippet(newText, snippet.getScore(), snippet.isHighlighted());
                }
            }
            filteredSnippets.add(snippet);
        }
        return filteredSnippets;
    }

    private static class MapperHighlighterEntry {
        final CustomPassageFormatter passageFormatter;
        final BytesRef[] filteredQueryTerms;

        private MapperHighlighterEntry(CustomPassageFormatter passageFormatter, BytesRef[] filteredQueryTerms) {
            this.passageFormatter = passageFormatter;
            this.filteredQueryTerms = filteredQueryTerms;
        }
    }

    private static class HighlighterEntry {
        final SortedSet<Term> queryTerms;
        Map<FieldMapper<?>, MapperHighlighterEntry> mappers = Maps.newHashMap();

        private HighlighterEntry(SortedSet<Term> queryTerms) {
            this.queryTerms = queryTerms;
        }
    }
}

