/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class AggregatorFactories {
    public static final AggregatorFactories EMPTY = new Empty();
    private final AggregatorFactory[] factories;

    public static Builder builder() {
        return new Builder();
    }

    private AggregatorFactories(AggregatorFactory[] factories) {
        this.factories = factories;
    }

    public Aggregator[] createSubAggregators(Aggregator parent, final long estimatedBucketsCount) {
        Aggregator[] aggregators = new Aggregator[this.count()];
        for (int i = 0; i < this.factories.length; ++i) {
            final AggregatorFactory factory = this.factories[i];
            final Aggregator first = factory.create(parent.context(), parent, estimatedBucketsCount);
            aggregators[i] = first.bucketAggregationMode() == Aggregator.BucketAggregationMode.MULTI_BUCKETS ? first : new Aggregator(first.name(), Aggregator.BucketAggregationMode.MULTI_BUCKETS, EMPTY, 1L, first.context(), first.parent()){
                ObjectArray<Aggregator> aggregators;
                {
                    super(x0, x1, x2, x3, x4, x5);
                    this.aggregators = BigArrays.newObjectArray(estimatedBucketsCount, this.context.pageCacheRecycler());
                    this.aggregators.set(0L, first);
                    for (long i = 1L; i < estimatedBucketsCount; ++i) {
                        this.aggregators.set(i, factory.create(this.parent.context(), this.parent, estimatedBucketsCount));
                    }
                }

                @Override
                public boolean shouldCollect() {
                    return first.shouldCollect();
                }

                @Override
                protected void doPostCollection() {
                    for (long i = 0L; i < this.aggregators.size(); ++i) {
                        Aggregator aggregator = this.aggregators.get(i);
                        if (aggregator == null) continue;
                        aggregator.postCollection();
                    }
                }

                @Override
                public void collect(int doc, long owningBucketOrdinal) throws IOException {
                    this.aggregators = BigArrays.grow(this.aggregators, owningBucketOrdinal + 1L);
                    Aggregator aggregator = this.aggregators.get(owningBucketOrdinal);
                    if (aggregator == null) {
                        aggregator = factory.create(this.parent.context(), this.parent, estimatedBucketsCount);
                        this.aggregators.set(owningBucketOrdinal, aggregator);
                    }
                    aggregator.collect(doc, 0L);
                }

                @Override
                public InternalAggregation buildAggregation(long owningBucketOrdinal) {
                    return this.aggregators.get(owningBucketOrdinal).buildAggregation(0L);
                }

                @Override
                public InternalAggregation buildEmptyAggregation() {
                    return first.buildEmptyAggregation();
                }

                @Override
                public void doRelease() {
                    Releasables.release(this.aggregators);
                }
            };
        }
        return aggregators;
    }

    public Aggregator[] createTopLevelAggregators(AggregationContext ctx) {
        Aggregator[] aggregators = new Aggregator[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            aggregators[i] = this.factories[i].create(ctx, null, 0L);
        }
        return aggregators;
    }

    public int count() {
        return this.factories.length;
    }

    void setParent(AggregatorFactory parent) {
        for (AggregatorFactory factory : this.factories) {
            factory.parent = parent;
        }
    }

    public void validate() {
        for (AggregatorFactory factory : this.factories) {
            factory.validate();
        }
    }

    public static class Builder {
        private List<AggregatorFactory> factories = new ArrayList<AggregatorFactory>();

        public Builder add(AggregatorFactory factory) {
            this.factories.add(factory);
            return this;
        }

        public AggregatorFactories build() {
            if (this.factories.isEmpty()) {
                return EMPTY;
            }
            return new AggregatorFactories(this.factories.toArray(new AggregatorFactory[this.factories.size()]));
        }
    }

    private static final class Empty
    extends AggregatorFactories {
        private static final AggregatorFactory[] EMPTY_FACTORIES = new AggregatorFactory[0];
        private static final Aggregator[] EMPTY_AGGREGATORS = new Aggregator[0];

        private Empty() {
            super(EMPTY_FACTORIES);
        }

        @Override
        public Aggregator[] createSubAggregators(Aggregator parent, long estimatedBucketsCount) {
            return EMPTY_AGGREGATORS;
        }

        @Override
        public Aggregator[] createTopLevelAggregators(AggregationContext ctx) {
            return EMPTY_AGGREGATORS;
        }
    }
}

