/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalNode;

public class NodeBuilder {
    private final ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
    private boolean loadConfigSettings = true;

    public static NodeBuilder nodeBuilder() {
        return new NodeBuilder();
    }

    public ImmutableSettings.Builder settings() {
        return this.settings;
    }

    public ImmutableSettings.Builder getSettings() {
        return this.settings;
    }

    public NodeBuilder settings(Settings.Builder settings) {
        return this.settings(settings.build());
    }

    public NodeBuilder settings(Settings settings) {
        this.settings.put(settings);
        return this;
    }

    public NodeBuilder loadConfigSettings(boolean loadConfigSettings) {
        this.loadConfigSettings = loadConfigSettings;
        return this;
    }

    public NodeBuilder client(boolean client) {
        this.settings.put("node.client", client);
        return this;
    }

    public NodeBuilder data(boolean data) {
        this.settings.put("node.data", data);
        return this;
    }

    public NodeBuilder local(boolean local) {
        this.settings.put("node.local", local);
        return this;
    }

    public NodeBuilder clusterName(String clusterName) {
        this.settings.put("cluster.name", clusterName);
        return this;
    }

    public Node build() {
        return new InternalNode(this.settings.build(), this.loadConfigSettings);
    }

    public Node node() {
        return this.build().start();
    }
}

