/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.XSearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.HashedBytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CreateFailedEngineException;
import org.elasticsearch.index.engine.DeleteByQueryFailedEngineException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineAlreadyStartedException;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.merge.policy.IndexUpgraderMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.search.nested.IncludeNestedDocsQuery;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.indices.warmer.InternalIndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalEngine
extends AbstractIndexShardComponent
implements Engine {
    private volatile ByteSizeValue indexingBufferSize;
    private volatile int indexConcurrency;
    private volatile boolean compoundOnFlush = true;
    private long gcDeletesInMillis;
    private volatile boolean enableGcDeletes = true;
    private volatile String codecName;
    private final ThreadPool threadPool;
    private final ShardIndexingService indexingService;
    private final IndexSettingsService indexSettingsService;
    @Nullable
    private final InternalIndicesWarmer warmer;
    private final Store store;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final Translog translog;
    private final MergePolicyProvider mergePolicyProvider;
    private final MergeSchedulerProvider mergeScheduler;
    private final AnalysisService analysisService;
    private final SimilarityService similarityService;
    private final CodecService codecService;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private volatile IndexWriter indexWriter;
    private final SearcherFactory searcherFactory = new SearchFactory();
    private volatile XSearcherManager searcherManager;
    private volatile boolean closed = false;
    private volatile boolean dirty = false;
    private volatile boolean possibleMergeNeeded = false;
    private final AtomicBoolean optimizeMutex = new AtomicBoolean();
    private volatile boolean flushNeeded = false;
    private final AtomicInteger flushing = new AtomicInteger();
    private final Lock flushLock = new ReentrantLock();
    private final RecoveryCounter onGoingRecoveries = new RecoveryCounter();
    private final ConcurrentMap<HashedBytesRef, VersionValue> versionMap;
    private final Object[] dirtyLocks;
    private final Object refreshMutex = new Object();
    private final ApplySettings applySettings = new ApplySettings();
    private volatile boolean failOnMergeFailure;
    private Throwable failedEngine = null;
    private final Object failedEngineMutex = new Object();
    private final CopyOnWriteArrayList<Engine.FailedEngineListener> failedEngineListeners = new CopyOnWriteArrayList();
    private final AtomicLong translogIdGenerator = new AtomicLong();
    private SegmentInfos lastCommittedSegmentInfos;
    public static final String INDEX_INDEX_CONCURRENCY = "index.index_concurrency";
    public static final String INDEX_COMPOUND_ON_FLUSH = "index.compound_on_flush";
    public static final String INDEX_GC_DELETES = "index.gc_deletes";
    public static final String INDEX_FAIL_ON_MERGE_FAILURE = "index.fail_on_merge_failure";

    @Inject
    public InternalEngine(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexSettingsService indexSettingsService, ShardIndexingService indexingService, @Nullable IndicesWarmer warmer, Store store, SnapshotDeletionPolicy deletionPolicy, Translog translog, MergePolicyProvider mergePolicyProvider, MergeSchedulerProvider mergeScheduler, AnalysisService analysisService, SimilarityService similarityService, CodecService codecService) throws EngineException {
        super(shardId, indexSettings);
        Preconditions.checkNotNull(store, "Store must be provided to the engine");
        Preconditions.checkNotNull(deletionPolicy, "Snapshot deletion policy must be provided to the engine");
        Preconditions.checkNotNull(translog, "Translog must be provided to the engine");
        this.gcDeletesInMillis = indexSettings.getAsTime(INDEX_GC_DELETES, TimeValue.timeValueSeconds(60L)).millis();
        this.indexingBufferSize = this.componentSettings.getAsBytesSize("index_buffer_size", new ByteSizeValue(64L, ByteSizeUnit.MB));
        this.codecName = indexSettings.get("index.codec", "default");
        this.threadPool = threadPool;
        this.indexSettingsService = indexSettingsService;
        this.indexingService = indexingService;
        this.warmer = (InternalIndicesWarmer)warmer;
        this.store = store;
        this.deletionPolicy = deletionPolicy;
        this.translog = translog;
        this.mergePolicyProvider = mergePolicyProvider;
        this.mergeScheduler = mergeScheduler;
        this.analysisService = analysisService;
        this.similarityService = similarityService;
        this.codecService = codecService;
        this.compoundOnFlush = indexSettings.getAsBoolean(INDEX_COMPOUND_ON_FLUSH, (Boolean)this.compoundOnFlush);
        this.indexConcurrency = indexSettings.getAsInt(INDEX_INDEX_CONCURRENCY, (Integer)Math.max(8, (int)((double)EsExecutors.boundedNumberOfProcessors(indexSettings) * 0.65)));
        this.versionMap = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        this.dirtyLocks = new Object[this.indexConcurrency * 50];
        for (int i = 0; i < this.dirtyLocks.length; ++i) {
            this.dirtyLocks[i] = new Object();
        }
        this.indexSettingsService.addListener(this.applySettings);
        this.failOnMergeFailure = indexSettings.getAsBoolean(INDEX_FAIL_ON_MERGE_FAILURE, (Boolean)true);
        if (this.failOnMergeFailure) {
            this.mergeScheduler.addFailureListener(new FailEngineOnMergeFailure());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndexingBufferSize(ByteSizeValue indexingBufferSize) {
        ByteSizeValue preValue = this.indexingBufferSize;
        this.rwl.readLock().lock();
        try {
            this.indexingBufferSize = indexingBufferSize;
            IndexWriter indexWriter = this.indexWriter;
            if (indexWriter != null) {
                indexWriter.getConfig().setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (preValue.bytes() != indexingBufferSize.bytes()) {
            if (indexingBufferSize == Engine.INACTIVE_SHARD_INDEXING_BUFFER && preValue != Engine.INACTIVE_SHARD_INDEXING_BUFFER) {
                this.logger.debug("updating index_buffer_size from [{}] to (inactive) [{}]", preValue, indexingBufferSize);
                try {
                    this.flush(new Engine.Flush().type(Engine.Flush.Type.NEW_WRITER));
                }
                catch (EngineClosedException e) {
                }
                catch (FlushNotAllowedEngineException e) {
                }
                catch (Throwable e) {
                    this.logger.warn("failed to flush after setting shard to inactive", e, new Object[0]);
                }
            } else {
                this.logger.debug("updating index_buffer_size from [{}] to [{}]", preValue, indexingBufferSize);
            }
        }
    }

    @Override
    public void addFailedEngineListener(Engine.FailedEngineListener listener) {
        this.failedEngineListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void start() throws EngineException {
        this.rwl.writeLock().lock();
        try {
            if (this.indexWriter != null) {
                throw new EngineAlreadyStartedException(this.shardId);
            }
            if (this.closed) {
                throw new EngineClosedException(this.shardId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("starting engine", new Object[0]);
            }
            try {
                this.indexWriter = this.createWriter();
            }
            catch (IOException e) {
                throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)e);
            }
            try {
                if (Lucene.indexExists(this.store.directory())) {
                    Map commitUserData = Lucene.readSegmentInfos(this.store.directory()).getUserData();
                    if (commitUserData.containsKey("translog_id")) {
                        this.translogIdGenerator.set(Long.parseLong((String)commitUserData.get("translog_id")));
                    } else {
                        this.translogIdGenerator.set(System.currentTimeMillis());
                        this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(this.translogIdGenerator.get())).map());
                        this.indexWriter.commit();
                    }
                } else {
                    this.translogIdGenerator.set(System.currentTimeMillis());
                    this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(this.translogIdGenerator.get())).map());
                    this.indexWriter.commit();
                }
                this.translog.newTranslog(this.translogIdGenerator.get());
                this.searcherManager = this.buildSearchManager(this.indexWriter);
                this.readLastCommittedSegmentsInfo();
            }
            catch (IOException e) {
                block19: {
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException iOException) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexWriter});
                        break block19;
                        catch (Throwable throwable) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexWriter});
                            throw throwable;
                        }
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexWriter});
                }
                throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", (Throwable)e);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private void readLastCommittedSegmentsInfo() throws IOException {
        SegmentInfos infos = new SegmentInfos();
        infos.read(this.store.directory());
        this.lastCommittedSegmentInfos = infos;
    }

    @Override
    public TimeValue defaultRefreshInterval() {
        return new TimeValue(1L, TimeUnit.SECONDS);
    }

    @Override
    public void enableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.GetResult get(Engine.Get get) throws EngineException {
        block16: {
            this.rwl.readLock().lock();
            if (get.realtime() && (versionValue = (VersionValue)this.versionMap.get(this.versionKey(get.uid()))) != null) {
                if (versionValue.delete()) {
                    var3_3 = Engine.GetResult.NOT_EXISTS;
                    this.rwl.readLock().unlock();
                    return var3_3;
                }
            }
            ** GOTO lbl-1000
            {
                catch (Throwable var6_14) {
                    throw var6_14;
                }
                if (get.version() != 0L && get.versionType().isVersionConflict(versionValue.version(), get.version())) {
                    uid = Uid.createUid(get.uid().text());
                    throw new VersionConflictEngineException(this.shardId, uid.type(), uid.id(), versionValue.version(), get.version());
                }
                if (!get.loadSource()) {
                    return new Engine.GetResult(true, versionValue.version(), null);
                }
                data = this.translog.read(versionValue.translogLocation());
                if (data == null) ** GOTO lbl-1000
                try {
                    source = TranslogStreams.readSource(data);
                    return new Engine.GetResult(true, versionValue.version(), source);
                }
                catch (IOException e) {}
lbl-1000:
                // 3 sources

                {
                    searcher = this.acquireSearcher("get");
                    try {
                        docIdAndVersion = Versions.loadDocIdAndVersion(searcher.reader(), get.uid());
                    }
                    catch (Throwable e) {
                        searcher.release();
                        throw new EngineException(this.shardId(), "Couldn't resolve version", e);
                    }
                    if (get.version() != 0L && docIdAndVersion != null && get.versionType().isVersionConflict(docIdAndVersion.version, get.version())) {
                        searcher.release();
                        uid = Uid.createUid(get.uid().text());
                        throw new VersionConflictEngineException(this.shardId, uid.type(), uid.id(), docIdAndVersion.version, get.version());
                    }
                    if (docIdAndVersion == null) break block16;
                    return new Engine.GetResult(searcher, docIdAndVersion);
                }
            }
        }
        searcher.release();
        return Engine.GetResult.NOT_EXISTS;
    }

    @Override
    public void create(Engine.Create create) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerCreate(create, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new CreateFailedEngineException(this.shardId, create, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new CreateFailedEngineException(this.shardId, create, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new CreateFailedEngineException(this.shardId, create, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCreate(Engine.Create create, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(create.uid());
        synchronized (object) {
            long updatedVersion;
            HashedBytesRef versionKey = this.versionKey(create.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(create.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            long expectedVersion = create.version();
            if (create.origin() == Engine.Operation.Origin.PRIMARY) {
                if (create.versionType().isVersionConflict(currentVersion, expectedVersion)) {
                    throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
                }
                updatedVersion = create.versionType().updateVersion(currentVersion, expectedVersion);
            } else {
                if (VersionType.EXTERNAL.isVersionConflict(currentVersion, expectedVersion)) {
                    if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
                }
                updatedVersion = VersionType.EXTERNAL.updateVersion(currentVersion, expectedVersion);
            }
            if (versionValue != null) {
                if (!versionValue.delete()) {
                    if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new DocumentAlreadyExistsException(this.shardId, create.type(), create.id());
                }
            } else if (currentVersion != -1L) {
                if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                    return;
                }
                throw new DocumentAlreadyExistsException(this.shardId, create.type(), create.id());
            }
            create.version(updatedVersion);
            if (create.docs().size() > 1) {
                writer.addDocuments(create.docs(), create.analyzer());
            } else {
                writer.addDocument((Iterable)create.docs().get(0), create.analyzer());
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Create(create));
            this.versionMap.put(versionKey, new VersionValue(updatedVersion, false, this.threadPool.estimatedTimeInMillis(), translogLocation));
            this.indexingService.postCreateUnderLock(create);
        }
    }

    @Override
    public void index(Engine.Index index) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerIndex(index, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerIndex(Engine.Index index, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(index.uid());
        synchronized (object) {
            long updatedVersion;
            HashedBytesRef versionKey = this.versionKey(index.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(index.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            long expectedVersion = index.version();
            if (index.origin() == Engine.Operation.Origin.PRIMARY) {
                if (index.versionType().isVersionConflict(currentVersion, expectedVersion)) {
                    throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
                }
                updatedVersion = index.versionType().updateVersion(currentVersion, expectedVersion);
            } else {
                if (VersionType.EXTERNAL.isVersionConflict(currentVersion, expectedVersion)) {
                    if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
                }
                updatedVersion = VersionType.EXTERNAL.updateVersion(currentVersion, expectedVersion);
            }
            index.version(updatedVersion);
            if (currentVersion == -1L) {
                index.created(true);
                if (index.docs().size() > 1) {
                    writer.addDocuments(index.docs(), index.analyzer());
                } else {
                    writer.addDocument((Iterable)index.docs().get(0), index.analyzer());
                }
            } else {
                if (versionValue != null) {
                    index.created(versionValue.delete());
                }
                if (index.docs().size() > 1) {
                    writer.updateDocuments(index.uid(), index.docs(), index.analyzer());
                } else {
                    writer.updateDocument(index.uid(), (Iterable)index.docs().get(0), index.analyzer());
                }
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Index(index));
            this.versionMap.put(versionKey, new VersionValue(updatedVersion, false, this.threadPool.estimatedTimeInMillis(), translogLocation));
            this.indexingService.postIndexUnderLock(index);
        }
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerDelete(delete, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new DeleteFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new DeleteFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new DeleteFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDelete(Engine.Delete delete, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(delete.uid());
        synchronized (object) {
            long updatedVersion;
            HashedBytesRef versionKey = this.versionKey(delete.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(delete.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            long expectedVersion = delete.version();
            if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
                if (delete.versionType().isVersionConflict(currentVersion, expectedVersion)) {
                    throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion, expectedVersion);
                }
                updatedVersion = delete.versionType().updateVersion(currentVersion, expectedVersion);
            } else {
                if (VersionType.EXTERNAL.isVersionConflict(currentVersion, expectedVersion)) {
                    if (delete.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion - 1L, expectedVersion);
                }
                updatedVersion = VersionType.EXTERNAL.updateVersion(currentVersion, expectedVersion);
            }
            if (currentVersion == -1L) {
                delete.version(updatedVersion).found(false);
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            } else if (versionValue != null && versionValue.delete()) {
                delete.version(updatedVersion).found(false);
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            } else {
                delete.version(updatedVersion).found(true);
                writer.deleteDocuments(delete.uid());
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            }
            this.indexingService.postDeleteUnderLock(delete);
        }
    }

    @Override
    public void delete(Engine.DeleteByQuery delete) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId);
            }
            Query query = delete.nested() && delete.aliasFilter() != null ? new IncludeNestedDocsQuery((Query)new XFilteredQuery(delete.query(), delete.aliasFilter()), delete.parentFilter()) : (delete.nested() ? new IncludeNestedDocsQuery(delete.query(), delete.parentFilter()) : (delete.aliasFilter() != null ? new XFilteredQuery(delete.query(), delete.aliasFilter()) : delete.query()));
            writer.deleteDocuments(query);
            this.translog.add(new Translog.DeleteByQuery(delete));
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new DeleteByQueryFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        this.refreshVersioningTable(System.currentTimeMillis());
    }

    @Override
    public final Engine.Searcher acquireSearcher(String source) throws EngineException {
        XSearcherManager manager = this.searcherManager;
        if (manager == null) {
            throw new EngineClosedException(this.shardId);
        }
        try {
            IndexSearcher searcher = (IndexSearcher)manager.acquire();
            return this.newSearcher(source, searcher, manager);
        }
        catch (Throwable ex) {
            this.logger.error("failed to acquire searcher, source {}", ex, source);
            throw new EngineException(this.shardId, ex.getMessage());
        }
    }

    protected Engine.Searcher newSearcher(String source, IndexSearcher searcher, XSearcherManager manager) {
        return new EngineSearcher(source, searcher, manager);
    }

    @Override
    public boolean refreshNeeded() {
        return this.dirty;
    }

    @Override
    public boolean possibleMergeNeeded() {
        return this.possibleMergeNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Engine.Refresh refresh) throws EngineException {
        block17: {
            if (this.indexWriter == null) {
                throw new EngineClosedException(this.shardId);
            }
            this.rwl.readLock().lock();
            try {
                IndexWriter currentWriter = this.indexWriter;
                if (currentWriter == null) {
                    throw new EngineClosedException(this.shardId, this.failedEngine);
                }
                try {
                    Object object = this.refreshMutex;
                    synchronized (object) {
                        if (this.dirty || refresh.force()) {
                            this.dirty = false;
                            this.searcherManager.maybeRefresh();
                        }
                    }
                }
                catch (AlreadyClosedException e) {
                }
                catch (OutOfMemoryError e) {
                    this.failEngine(e);
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("OutOfMemoryError")) {
                        this.failEngine(e);
                    }
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
                catch (Throwable e) {
                    if (this.indexWriter == null) {
                        throw new EngineClosedException(this.shardId, this.failedEngine);
                    }
                    if (currentWriter != this.indexWriter) {
                        break block17;
                    }
                    throw new RefreshFailedEngineException(this.shardId, e);
                }
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush(Engine.Flush flush) throws EngineException {
        this.ensureOpen();
        if ((flush.type() == Engine.Flush.Type.NEW_WRITER || flush.type() == Engine.Flush.Type.COMMIT_TRANSLOG) && this.onGoingRecoveries.get() > 0) {
            throw new FlushNotAllowedEngineException(this.shardId, "recovery is in progress, flush [" + (Object)((Object)flush.type()) + "] is not allowed");
        }
        int currentFlushing = this.flushing.incrementAndGet();
        if (currentFlushing > 1 && !flush.waitIfOngoing()) {
            this.flushing.decrementAndGet();
            throw new FlushNotAllowedEngineException(this.shardId, "already flushing...");
        }
        this.flushLock.lock();
        try {
            block38: {
                if (flush.type() == Engine.Flush.Type.NEW_WRITER) {
                    this.rwl.writeLock().lock();
                    try {
                        this.ensureOpen();
                        if (this.onGoingRecoveries.get() > 0) {
                            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                        }
                        this.dirty = false;
                        try {
                            this.indexWriter.close(false);
                            this.indexWriter = this.createWriter();
                            if (this.flushNeeded || flush.force()) {
                                this.flushNeeded = false;
                                long translogId = this.translogIdGenerator.incrementAndGet();
                                this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                                this.indexWriter.commit();
                                this.translog.newTranslog(translogId);
                            }
                            XSearcherManager current = this.searcherManager;
                            this.searcherManager = this.buildSearchManager(this.indexWriter);
                            try {
                                IOUtils.close((Closeable[])new Closeable[]{current});
                            }
                            catch (Throwable t) {
                                this.logger.warn("Failed to close current SearcherManager", t, new Object[0]);
                            }
                            this.refreshVersioningTable(this.threadPool.estimatedTimeInMillis());
                            break block38;
                        }
                        catch (OutOfMemoryError e) {
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (Throwable e) {
                            throw new FlushFailedEngineException(this.shardId, e);
                        }
                    }
                    finally {
                        this.rwl.writeLock().unlock();
                    }
                }
                if (flush.type() == Engine.Flush.Type.COMMIT_TRANSLOG) {
                    this.rwl.readLock().lock();
                    try {
                        this.ensureOpen();
                        if (this.onGoingRecoveries.get() > 0) {
                            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                        }
                        if (!this.flushNeeded && !flush.force()) break block38;
                        this.flushNeeded = false;
                        try {
                            long translogId = this.translogIdGenerator.incrementAndGet();
                            this.translog.newTransientTranslog(translogId);
                            this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                            this.indexWriter.commit();
                            this.refreshVersioningTable(this.threadPool.estimatedTimeInMillis());
                            this.translog.makeTransientCurrent();
                            break block38;
                        }
                        catch (OutOfMemoryError e) {
                            this.translog.revertTransient();
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (Throwable e) {
                            this.translog.revertTransient();
                            throw new FlushFailedEngineException(this.shardId, e);
                        }
                    }
                    finally {
                        this.rwl.readLock().unlock();
                    }
                }
                if (flush.type() != Engine.Flush.Type.COMMIT) throw new ElasticsearchIllegalStateException("flush type [" + (Object)((Object)flush.type()) + "] not supported");
                this.rwl.readLock().lock();
                try {
                    this.ensureOpen();
                    try {
                        long translogId = this.translog.currentId();
                        this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                        this.indexWriter.commit();
                    }
                    catch (OutOfMemoryError e) {
                        this.translog.revertTransient();
                        this.failEngine(e);
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        this.failEngine(e);
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    catch (Throwable e) {
                        throw new FlushFailedEngineException(this.shardId, e);
                    }
                }
                finally {
                    this.rwl.readLock().unlock();
                }
            }
            this.rwl.readLock().lock();
            try {
                this.ensureOpen();
                this.readLastCommittedSegmentsInfo();
                this.rwl.readLock().unlock();
                return;
            }
            catch (Throwable e) {
                try {
                    if (this.closed) return;
                    this.logger.warn("failed to read latest segment infos on flush", e, new Object[0]);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.rwl.readLock().unlock();
                }
            }
        }
        finally {
            this.flushLock.unlock();
            this.flushing.decrementAndGet();
        }
    }

    private void ensureOpen() {
        if (this.indexWriter == null) {
            throw new EngineClosedException(this.shardId, this.failedEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshVersioningTable(long time) {
        this.refresh(new Engine.Refresh("version_table").force(true));
        for (Map.Entry entry : this.versionMap.entrySet()) {
            HashedBytesRef uid = (HashedBytesRef)entry.getKey();
            Object object = this.dirtyLock(uid.bytes);
            synchronized (object) {
                VersionValue versionValue = (VersionValue)this.versionMap.get(uid);
                if (versionValue == null) {
                    continue;
                }
                if (time - versionValue.time() <= 0L) {
                    continue;
                }
                if (versionValue.delete()) {
                    if (this.enableGcDeletes && time - versionValue.time() > this.gcDeletesInMillis) {
                        this.versionMap.remove(uid);
                    }
                } else {
                    this.versionMap.remove(uid);
                }
            }
        }
    }

    @Override
    public void maybeMerge() throws EngineException {
        if (!this.possibleMergeNeeded) {
            return;
        }
        this.possibleMergeNeeded = false;
        this.rwl.readLock().lock();
        try {
            this.ensureOpen();
            this.indexWriter.maybeMerge();
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        catch (Throwable e) {
            throw new OptimizeFailedEngineException(this.shardId, e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws EngineException {
        if (optimize.flush()) {
            this.flush(new Engine.Flush().force(true).waitIfOngoing(true));
        }
        if (this.optimizeMutex.compareAndSet(false, true)) {
            this.rwl.readLock().lock();
            try {
                this.ensureOpen();
                if (optimize.onlyExpungeDeletes()) {
                    this.indexWriter.forceMergeDeletes(false);
                } else if (optimize.maxNumSegments() <= 0) {
                    this.indexWriter.maybeMerge();
                    this.possibleMergeNeeded = false;
                } else {
                    this.indexWriter.forceMerge(optimize.maxNumSegments(), false);
                }
            }
            catch (OutOfMemoryError e) {
                this.failEngine(e);
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("OutOfMemoryError")) {
                    this.failEngine(e);
                }
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            catch (Throwable e) {
                throw new OptimizeFailedEngineException(this.shardId, e);
            }
            finally {
                this.rwl.readLock().unlock();
                this.optimizeMutex.set(false);
            }
        }
        if (optimize.waitForMerge()) {
            this.indexWriter.waitForMerges();
        }
        if (optimize.flush()) {
            this.flush(new Engine.Flush().force(true).waitIfOngoing(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T snapshot(Engine.SnapshotHandler<T> snapshotHandler) throws EngineException {
        SnapshotIndexCommit snapshotIndexCommit = null;
        Translog.Snapshot traslogSnapshot = null;
        this.rwl.readLock().lock();
        try {
            snapshotIndexCommit = this.deletionPolicy.snapshot();
            traslogSnapshot = this.translog.snapshot();
        }
        catch (Throwable e) {
            if (snapshotIndexCommit != null) {
                snapshotIndexCommit.release();
            }
            throw new SnapshotFailedEngineException(this.shardId, e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        try {
            T t = snapshotHandler.snapshot(snapshotIndexCommit, traslogSnapshot);
            return t;
        }
        finally {
            snapshotIndexCommit.release();
            traslogSnapshot.release();
        }
    }

    @Override
    public SnapshotIndexCommit snapshotIndex() throws EngineException {
        this.rwl.readLock().lock();
        try {
            this.flush(new Engine.Flush().type(Engine.Flush.Type.COMMIT).waitIfOngoing(true));
            this.ensureOpen();
            SnapshotIndexCommit snapshotIndexCommit = this.deletionPolicy.snapshot();
            return snapshotIndexCommit;
        }
        catch (IOException e) {
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        Translog.Snapshot phase2Snapshot;
        SnapshotIndexCommit phase1Snapshot;
        this.rwl.writeLock().lock();
        try {
            if (this.closed) {
                throw new EngineClosedException(this.shardId);
            }
            this.onGoingRecoveries.increment();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        try {
            phase1Snapshot = this.deletionPolicy.snapshot();
        }
        catch (Throwable e) {
            this.onGoingRecoveries.decrement();
            throw new RecoveryEngineException(this.shardId, 1, "Snapshot failed", e);
        }
        try {
            recoveryHandler.phase1(phase1Snapshot);
        }
        catch (Throwable e2) {
            EngineClosedException e2;
            this.onGoingRecoveries.decrement();
            phase1Snapshot.release();
            if (this.closed) {
                e2 = new EngineClosedException(this.shardId, e2);
            }
            throw new RecoveryEngineException(this.shardId, 1, "Execution failed", (Throwable)e2);
        }
        try {
            phase2Snapshot = this.translog.snapshot();
        }
        catch (Throwable e3) {
            EngineClosedException e3;
            this.onGoingRecoveries.decrement();
            phase1Snapshot.release();
            if (this.closed) {
                e3 = new EngineClosedException(this.shardId, e3);
            }
            throw new RecoveryEngineException(this.shardId, 2, "Snapshot failed", (Throwable)e3);
        }
        try {
            recoveryHandler.phase2(phase2Snapshot);
        }
        catch (Throwable e4) {
            EngineClosedException e4;
            this.onGoingRecoveries.decrement();
            phase1Snapshot.release();
            phase2Snapshot.release();
            if (this.closed) {
                e4 = new EngineClosedException(this.shardId, e4);
            }
            throw new RecoveryEngineException(this.shardId, 2, "Execution failed", (Throwable)e4);
        }
        this.rwl.writeLock().lock();
        Translog.Snapshot phase3Snapshot = null;
        try {
            phase3Snapshot = this.translog.snapshot(phase2Snapshot);
            recoveryHandler.phase3(phase3Snapshot);
        }
        catch (Throwable e) {
            throw new RecoveryEngineException(this.shardId, 3, "Execution failed", e);
        }
        finally {
            this.onGoingRecoveries.decrement();
            this.rwl.writeLock().unlock();
            phase1Snapshot.release();
            phase2Snapshot.release();
            if (phase3Snapshot != null) {
                phase3Snapshot.release();
            }
        }
    }

    private long getReaderRamBytesUsed(AtomicReaderContext reader) {
        return SegmentReaderUtils.segmentReader(reader.reader()).ramBytesUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentsStats segmentsStats() {
        this.rwl.readLock().lock();
        try {
            SegmentsStats segmentsStats;
            this.ensureOpen();
            Engine.Searcher searcher = this.acquireSearcher("segments_stats");
            try {
                SegmentsStats stats = new SegmentsStats();
                for (AtomicReaderContext reader : searcher.reader().leaves()) {
                    stats.add(1L, this.getReaderRamBytesUsed(reader));
                }
                segmentsStats = stats;
            }
            catch (Throwable throwable) {
                searcher.release();
                throw throwable;
            }
            searcher.release();
            return segmentsStats;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Segment> segments() {
        this.rwl.readLock().lock();
        try {
            Segment segment;
            this.ensureOpen();
            HashMap<String, Segment> segments = new HashMap<String, Segment>();
            Engine.Searcher searcher = this.acquireSearcher("segments");
            try {
                for (AtomicReaderContext reader : searcher.reader().leaves()) {
                    assert (reader.reader() instanceof SegmentReader);
                    SegmentCommitInfo info = SegmentReaderUtils.segmentReader(reader.reader()).getSegmentInfo();
                    assert (!segments.containsKey(info.info.name));
                    segment = new Segment(info.info.name);
                    segment.search = true;
                    segment.docCount = reader.reader().numDocs();
                    segment.delDocCount = reader.reader().numDeletedDocs();
                    segment.version = info.info.getVersion();
                    segment.compound = info.info.getUseCompoundFile();
                    try {
                        segment.sizeInBytes = info.sizeInBytes();
                    }
                    catch (IOException e) {
                        this.logger.trace("failed to get size for [{}]", e, info.info.name);
                    }
                    segment.memoryInBytes = this.getReaderRamBytesUsed(reader);
                    segments.put(info.info.name, segment);
                }
            }
            finally {
                searcher.release();
            }
            if (this.lastCommittedSegmentInfos != null) {
                SegmentInfos infos = this.lastCommittedSegmentInfos;
                for (SegmentCommitInfo info : infos) {
                    segment = (Segment)segments.get(info.info.name);
                    if (segment == null) {
                        segment = new Segment(info.info.name);
                        segment.search = false;
                        segment.committed = true;
                        segment.docCount = info.info.getDocCount();
                        segment.delDocCount = info.getDelCount();
                        segment.version = info.info.getVersion();
                        segment.compound = info.info.getUseCompoundFile();
                        try {
                            segment.sizeInBytes = info.sizeInBytes();
                        }
                        catch (IOException e) {
                            this.logger.trace("failed to get size for [{}]", e, info.info.name);
                        }
                        segments.put(info.info.name, segment);
                        continue;
                    }
                    segment.committed = true;
                }
            }
            Segment[] segmentsArr = segments.values().toArray(new Segment[segments.values().size()]);
            Arrays.sort(segmentsArr, new Comparator<Segment>(){

                @Override
                public int compare(Segment o1, Segment o2) {
                    return (int)(o1.getGeneration() - o2.getGeneration());
                }
            });
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block13: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment2 : segmentsArr) {
                        if (!segment2.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment2.mergeId = onGoingMerge.getId();
                        continue block13;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ElasticsearchException {
        this.rwl.writeLock().lock();
        try {
            this.innerClose();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        try {
            int ongoingRecoveries = this.onGoingRecoveries.awaitNoRecoveries(5000L);
            if (ongoingRecoveries > 0) {
                this.logger.debug("Waiting for ongoing recoveries timed out on close currently ongoing disoveries: [{}]", ongoingRecoveries);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failEngine(Throwable failure) {
        Object object = this.failedEngineMutex;
        synchronized (object) {
            if (this.failedEngine != null) {
                return;
            }
            this.logger.warn("failed engine", failure, new Object[0]);
            this.failedEngine = failure;
            for (Engine.FailedEngineListener listener : this.failedEngineListeners) {
                listener.onFailedEngine(this.shardId, failure);
            }
            this.innerClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() {
        if (this.closed) {
            return;
        }
        this.indexSettingsService.removeListener(this.applySettings);
        this.closed = true;
        this.versionMap.clear();
        this.failedEngineListeners.clear();
        try {
            try {
                IOUtils.close((Closeable[])new Closeable[]{this.searcherManager});
            }
            catch (Throwable t) {
                this.logger.warn("Failed to close SearcherManager", t, new Object[0]);
            }
            if (this.indexWriter != null) {
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException e) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            this.logger.debug("failed to rollback writer on close", e, new Object[0]);
        }
        finally {
            this.indexWriter = null;
        }
    }

    private HashedBytesRef versionKey(Term uid) {
        return new HashedBytesRef(uid.bytes());
    }

    private Object dirtyLock(BytesRef uid) {
        int hash = DjbHashFunction.DJB_HASH(uid.bytes, uid.offset, uid.length);
        if (hash == Integer.MIN_VALUE) {
            hash = 0;
        }
        return this.dirtyLocks[Math.abs(hash) % this.dirtyLocks.length];
    }

    private Object dirtyLock(Term uid) {
        return this.dirtyLock(uid.bytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadCurrentVersionFromIndex(Term uid) throws IOException {
        Engine.Searcher searcher = this.acquireSearcher("load_version");
        try {
            long l = Versions.loadVersion(searcher.reader(), uid);
            return l;
        }
        finally {
            searcher.release();
        }
    }

    private static boolean isMergedSegment(AtomicReader reader) {
        Map diagnostics = SegmentReaderUtils.segmentReader((AtomicReader)reader).getSegmentInfo().info.getDiagnostics();
        String source = (String)diagnostics.get("source");
        assert (Arrays.asList("addIndexes(IndexReader...)", "flush", "merge").contains(source)) : "Unknown source " + source;
        return "merge".equals(source);
    }

    private IndexWriter createWriter() throws IOException {
        try {
            if (IndexWriter.isLocked((Directory)this.store.directory())) {
                this.logger.warn("shard is locked, releasing lock", new Object[0]);
                IndexWriter.unlock((Directory)this.store.directory());
            }
            boolean create = !Lucene.indexExists(this.store.directory());
            IndexWriterConfig config = new IndexWriterConfig(Lucene.VERSION, (Analyzer)this.analysisService.defaultIndexAnalyzer());
            config.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
            config.setIndexDeletionPolicy((IndexDeletionPolicy)this.deletionPolicy);
            config.setMergeScheduler(this.mergeScheduler.newMergeScheduler());
            Object mergePolicy = this.mergePolicyProvider.newMergePolicy();
            mergePolicy = new IndexUpgraderMergePolicy((MergePolicy)mergePolicy);
            config.setMergePolicy(mergePolicy);
            config.setSimilarity(this.similarityService.similarity());
            config.setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            config.setMaxThreadStates(this.indexConcurrency);
            config.setCodec(this.codecService.codec(this.codecName));
            config.setWriteLockTimeout(5000L);
            config.setUseCompoundFile(this.compoundOnFlush);
            config.setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

                public void warm(AtomicReader reader) throws IOException {
                    block5: {
                        try {
                            assert (InternalEngine.isMergedSegment(reader));
                            Engine.SimpleSearcher searcher = new Engine.SimpleSearcher("warmer", new IndexSearcher((IndexReader)reader));
                            IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, searcher);
                            if (InternalEngine.this.warmer != null) {
                                InternalEngine.this.warmer.warm(context);
                            }
                        }
                        catch (Throwable t) {
                            if (!InternalEngine.this.closed) {
                                InternalEngine.this.logger.warn("Warm-up failed", t, new Object[0]);
                            }
                            if (!(t instanceof Error)) break block5;
                            throw (Error)t;
                        }
                    }
                }
            });
            return new IndexWriter(this.store.directory(), config);
        }
        catch (LockObtainFailedException ex) {
            boolean isLocked = IndexWriter.isLocked((Directory)this.store.directory());
            this.logger.warn("Could not lock IndexWriter isLocked [{}]", ex, isLocked);
            throw ex;
        }
    }

    private XSearcherManager buildSearchManager(IndexWriter indexWriter) throws IOException {
        return new XSearcherManager(indexWriter, true, this.searcherFactory);
    }

    private static final class RecoveryCounter {
        private volatile int ongoingRecoveries = 0;

        private RecoveryCounter() {
        }

        synchronized void increment() {
            ++this.ongoingRecoveries;
        }

        synchronized void decrement() {
            --this.ongoingRecoveries;
            if (this.ongoingRecoveries == 0) {
                this.notifyAll();
            }
            assert (this.ongoingRecoveries >= 0) : "ongoingRecoveries must be >= 0 but was: " + this.ongoingRecoveries;
        }

        int get() {
            return this.ongoingRecoveries;
        }

        synchronized int awaitNoRecoveries(long timeout) throws InterruptedException {
            if (this.ongoingRecoveries > 0) {
                this.wait(timeout);
            }
            return this.ongoingRecoveries;
        }
    }

    class SearchFactory
    extends SearcherFactory {
        SearchFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexSearcher newSearcher(IndexReader reader) throws IOException {
            IndexSearcher searcher = new IndexSearcher(reader);
            searcher.setSimilarity(InternalEngine.this.similarityService.similarity());
            if (InternalEngine.this.warmer != null) {
                boolean closeNewSearcher;
                IndexSearcher newSearcher;
                block16: {
                    Releasable currentSearcher = null;
                    newSearcher = null;
                    closeNewSearcher = false;
                    try {
                        if (InternalEngine.this.searcherManager == null) {
                            newSearcher = searcher;
                        } else {
                            currentSearcher = InternalEngine.this.acquireSearcher("search_factory");
                            ArrayList<AtomicReader> readers = Lists.newArrayList();
                            for (AtomicReaderContext newReaderContext : searcher.getIndexReader().leaves()) {
                                if (InternalEngine.isMergedSegment(newReaderContext.reader())) continue;
                                boolean found = false;
                                for (AtomicReaderContext currentReaderContext : currentSearcher.reader().leaves()) {
                                    if (!currentReaderContext.reader().getCoreCacheKey().equals(newReaderContext.reader().getCoreCacheKey())) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                readers.add(newReaderContext.reader());
                            }
                            if (!readers.isEmpty()) {
                                newSearcher = new IndexSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[readers.size()]), false));
                                closeNewSearcher = true;
                            }
                        }
                        if (newSearcher != null) {
                            IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, new Engine.SimpleSearcher("warmer", newSearcher));
                            InternalEngine.this.warmer.warm(context);
                        }
                        if (currentSearcher == null) break block16;
                    }
                    catch (Throwable e) {
                        block17: {
                            try {
                                if (!InternalEngine.this.closed) {
                                    InternalEngine.this.logger.warn("failed to prepare/warm", e, new Object[0]);
                                }
                                if (currentSearcher == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (currentSearcher != null) {
                                    currentSearcher.release();
                                }
                                if (newSearcher != null && closeNewSearcher) {
                                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                                }
                                throw throwable;
                            }
                            currentSearcher.release();
                        }
                        if (newSearcher != null && closeNewSearcher) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                        }
                    }
                    currentSearcher.release();
                }
                if (newSearcher != null && closeNewSearcher) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                }
            }
            return searcher;
        }
    }

    static class VersionValue {
        private final long version;
        private final boolean delete;
        private final long time;
        private final Translog.Location translogLocation;

        VersionValue(long version, boolean delete, long time, Translog.Location translogLocation) {
            this.version = version;
            this.delete = delete;
            this.time = time;
            this.translogLocation = translogLocation;
        }

        public long time() {
            return this.time;
        }

        public long version() {
            return this.version;
        }

        public boolean delete() {
            return this.delete;
        }

        public Translog.Location translogLocation() {
            return this.translogLocation;
        }
    }

    class EngineSearcher
    implements Engine.Searcher {
        private final String source;
        private final IndexSearcher searcher;
        private final XSearcherManager manager;
        private final AtomicBoolean released;

        private EngineSearcher(String source, IndexSearcher searcher, XSearcherManager manager) {
            this.source = source;
            this.searcher = searcher;
            this.manager = manager;
            this.released = new AtomicBoolean(false);
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        @Override
        public IndexSearcher searcher() {
            return this.searcher;
        }

        @Override
        public boolean release() throws ElasticsearchException {
            if (!this.released.compareAndSet(false, true)) {
                InternalEngine.this.logger.warn("Searcher was released twice", new ElasticsearchIllegalStateException("Double release"), new Object[0]);
                return false;
            }
            try {
                this.manager.release(this.searcher);
                return true;
            }
            catch (IOException e) {
                return false;
            }
            catch (AlreadyClosedException e) {
                return false;
            }
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            boolean compoundOnFlush;
            long gcDeletesInMillis = settings.getAsTime(InternalEngine.INDEX_GC_DELETES, TimeValue.timeValueMillis(InternalEngine.this.gcDeletesInMillis)).millis();
            if (gcDeletesInMillis != InternalEngine.this.gcDeletesInMillis) {
                InternalEngine.this.logger.info("updating index.gc_deletes from [{}] to [{}]", TimeValue.timeValueMillis(InternalEngine.this.gcDeletesInMillis), TimeValue.timeValueMillis(gcDeletesInMillis));
                InternalEngine.this.gcDeletesInMillis = gcDeletesInMillis;
            }
            if ((compoundOnFlush = settings.getAsBoolean(InternalEngine.INDEX_COMPOUND_ON_FLUSH, (Boolean)InternalEngine.this.compoundOnFlush).booleanValue()) != InternalEngine.this.compoundOnFlush) {
                InternalEngine.this.logger.info("updating {} from [{}] to [{}]", InternalEngine.INDEX_COMPOUND_ON_FLUSH, InternalEngine.this.compoundOnFlush, compoundOnFlush);
                InternalEngine.this.compoundOnFlush = compoundOnFlush;
                InternalEngine.this.indexWriter.getConfig().setUseCompoundFile(compoundOnFlush);
            }
            int indexConcurrency = settings.getAsInt(InternalEngine.INDEX_INDEX_CONCURRENCY, (Integer)InternalEngine.this.indexConcurrency);
            boolean failOnMergeFailure = settings.getAsBoolean(InternalEngine.INDEX_FAIL_ON_MERGE_FAILURE, (Boolean)InternalEngine.this.failOnMergeFailure);
            String codecName = settings.get("index.codec", InternalEngine.this.codecName);
            boolean codecBloomLoad = settings.getAsBoolean("index.codec.bloom.load", (Boolean)InternalEngine.this.codecService.isLoadBloomFilter());
            boolean requiresFlushing = false;
            if (indexConcurrency != InternalEngine.this.indexConcurrency || !codecName.equals(InternalEngine.this.codecName) || failOnMergeFailure != InternalEngine.this.failOnMergeFailure || codecBloomLoad != InternalEngine.this.codecService.isLoadBloomFilter()) {
                InternalEngine.this.rwl.readLock().lock();
                try {
                    if (indexConcurrency != InternalEngine.this.indexConcurrency) {
                        InternalEngine.this.logger.info("updating index.index_concurrency from [{}] to [{}]", InternalEngine.this.indexConcurrency, indexConcurrency);
                        InternalEngine.this.indexConcurrency = indexConcurrency;
                        requiresFlushing = true;
                    }
                    if (!codecName.equals(InternalEngine.this.codecName)) {
                        InternalEngine.this.logger.info("updating index.codec from [{}] to [{}]", InternalEngine.this.codecName, codecName);
                        InternalEngine.this.codecName = codecName;
                        requiresFlushing = true;
                    }
                    if (failOnMergeFailure != InternalEngine.this.failOnMergeFailure) {
                        InternalEngine.this.logger.info("updating {} from [{}] to [{}]", InternalEngine.INDEX_FAIL_ON_MERGE_FAILURE, InternalEngine.this.failOnMergeFailure, failOnMergeFailure);
                        InternalEngine.this.failOnMergeFailure = failOnMergeFailure;
                    }
                    if (codecBloomLoad != InternalEngine.this.codecService.isLoadBloomFilter()) {
                        InternalEngine.this.logger.info("updating {} from [{}] to [{}]", "index.codec.bloom.load", InternalEngine.this.codecService.isLoadBloomFilter(), codecBloomLoad);
                        InternalEngine.this.codecService.setLoadBloomFilter(codecBloomLoad);
                        requiresFlushing = true;
                    }
                }
                finally {
                    InternalEngine.this.rwl.readLock().unlock();
                }
                if (requiresFlushing) {
                    InternalEngine.this.flush(new Engine.Flush().type(Engine.Flush.Type.NEW_WRITER));
                }
            }
        }
    }

    class FailEngineOnMergeFailure
    implements MergeSchedulerProvider.FailureListener {
        FailEngineOnMergeFailure() {
        }

        @Override
        public void onFailedMerge(MergePolicy.MergeException e) {
            InternalEngine.this.failEngine((Throwable)e);
        }
    }
}

