/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.smile.SmileXContent;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;

public class XContentFactory {
    private static int GUESS_HEADER_LENGTH = 20;

    public static XContentBuilder jsonBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.JSON);
    }

    public static XContentBuilder jsonBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(JsonXContent.jsonXContent, os);
    }

    public static XContentBuilder smileBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.SMILE);
    }

    public static XContentBuilder smileBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(SmileXContent.smileXContent, os);
    }

    public static XContentBuilder yamlBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.SMILE);
    }

    public static XContentBuilder yamlBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(YamlXContent.yamlXContent, os);
    }

    public static XContentBuilder contentBuilder(XContentType type, OutputStream outputStream) throws IOException {
        if (type == XContentType.JSON) {
            return XContentFactory.jsonBuilder(outputStream);
        }
        if (type == XContentType.SMILE) {
            return XContentFactory.smileBuilder(outputStream);
        }
        if (type == XContentType.YAML) {
            return XContentFactory.yamlBuilder(outputStream);
        }
        throw new ElasticsearchIllegalArgumentException("No matching content type for " + (Object)((Object)type));
    }

    public static XContentBuilder contentBuilder(XContentType type) throws IOException {
        if (type == XContentType.JSON) {
            return JsonXContent.contentBuilder();
        }
        if (type == XContentType.SMILE) {
            return SmileXContent.contentBuilder();
        }
        if (type == XContentType.YAML) {
            return YamlXContent.contentBuilder();
        }
        throw new ElasticsearchIllegalArgumentException("No matching content type for " + (Object)((Object)type));
    }

    public static XContent xContent(XContentType type) {
        return type.xContent();
    }

    public static XContentType xContentType(CharSequence content) {
        int length;
        int n = length = content.length() < GUESS_HEADER_LENGTH ? content.length() : GUESS_HEADER_LENGTH;
        if (length == 0) {
            return null;
        }
        char first = content.charAt(0);
        if (first == '{') {
            return XContentType.JSON;
        }
        if (length > 2 && first == ':' && content.charAt(1) == ')' && content.charAt(2) == '\n') {
            return XContentType.SMILE;
        }
        if (length > 2 && first == '-' && content.charAt(1) == '-' && content.charAt(2) == '-') {
            return XContentType.YAML;
        }
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            if (c != '{') continue;
            return XContentType.JSON;
        }
        return null;
    }

    public static XContent xContent(CharSequence content) {
        XContentType type = XContentFactory.xContentType(content);
        if (type == null) {
            throw new ElasticsearchParseException("Failed to derive xcontent from " + content);
        }
        return XContentFactory.xContent(type);
    }

    public static XContent xContent(byte[] data) {
        return XContentFactory.xContent(data, 0, data.length);
    }

    public static XContent xContent(byte[] data, int offset, int length) {
        XContentType type = XContentFactory.xContentType(data, offset, length);
        if (type == null) {
            throw new ElasticsearchParseException("Failed to derive xcontent from (offset=" + offset + ", length=" + length + "): " + Arrays.toString(data));
        }
        return XContentFactory.xContent(type);
    }

    public static XContentType xContentType(byte[] data) {
        return XContentFactory.xContentType(data, 0, data.length);
    }

    public static XContentType xContentType(InputStream si) throws IOException {
        int third;
        int first = si.read();
        if (first == -1) {
            return null;
        }
        int second = si.read();
        if (second == -1) {
            return null;
        }
        if (first == 58 && second == 41 && (third = si.read()) == 10) {
            return XContentType.SMILE;
        }
        if (first == 123 || second == 123) {
            return XContentType.JSON;
        }
        if (first == 45 && second == 45 && (third = si.read()) == 45) {
            return XContentType.YAML;
        }
        for (int i = 2; i < GUESS_HEADER_LENGTH; ++i) {
            int val = si.read();
            if (val == -1) {
                return null;
            }
            if (val != 123) continue;
            return XContentType.JSON;
        }
        return null;
    }

    public static XContentType xContentType(byte[] data, int offset, int length) {
        return XContentFactory.xContentType(new BytesArray(data, offset, length));
    }

    public static XContent xContent(BytesReference bytes) {
        XContentType type = XContentFactory.xContentType(bytes);
        if (type == null) {
            throw new ElasticsearchParseException("Failed to derive xcontent from " + bytes);
        }
        return XContentFactory.xContent(type);
    }

    public static XContentType xContentType(BytesReference bytes) {
        int length;
        int n = length = bytes.length() < GUESS_HEADER_LENGTH ? bytes.length() : GUESS_HEADER_LENGTH;
        if (length == 0) {
            return null;
        }
        byte first = bytes.get(0);
        if (first == 123) {
            return XContentType.JSON;
        }
        if (length > 2 && first == 58 && bytes.get(1) == 41 && bytes.get(2) == 10) {
            return XContentType.SMILE;
        }
        if (length > 2 && first == 45 && bytes.get(1) == 45 && bytes.get(2) == 45) {
            return XContentType.YAML;
        }
        for (int i = 0; i < length; ++i) {
            if (bytes.get(i) != 123) continue;
            return XContentType.JSON;
        }
        return null;
    }
}

