/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.util.BytesRef;

public class HashedBytesRef {
    public BytesRef bytes;
    public int hash;

    public HashedBytesRef() {
    }

    public HashedBytesRef(String bytes) {
        this(new BytesRef((CharSequence)bytes));
    }

    public HashedBytesRef(BytesRef bytes) {
        this(bytes, bytes.hashCode());
    }

    public HashedBytesRef(BytesRef bytes, int hash) {
        this.bytes = bytes;
        this.hash = hash;
    }

    public HashedBytesRef resetHashCode() {
        this.hash = this.bytes.hashCode();
        return this;
    }

    public HashedBytesRef reset(BytesRef bytes, int hash) {
        this.bytes = bytes;
        this.hash = hash;
        return this;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other instanceof HashedBytesRef) {
            return this.bytes.equals((Object)((HashedBytesRef)other).bytes);
        }
        return false;
    }

    public String toString() {
        return this.bytes.toString();
    }

    public HashedBytesRef deepCopy() {
        return HashedBytesRef.deepCopyOf(this);
    }

    public static HashedBytesRef deepCopyOf(HashedBytesRef other) {
        BytesRef copy = new BytesRef();
        copy.copyBytes(other.bytes);
        return new HashedBytesRef(copy, other.hash);
    }
}

