/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.put;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateListener;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.MetaDataUpdateSettingsService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateSettingsAction
extends TransportMasterNodeOperationAction<UpdateSettingsRequest, UpdateSettingsResponse> {
    private final MetaDataUpdateSettingsService updateSettingsService;

    @Inject
    public TransportUpdateSettingsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataUpdateSettingsService updateSettingsService) {
        super(settings, transportService, clusterService, threadPool);
        this.updateSettingsService = updateSettingsService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "indices/settings/update";
    }

    @Override
    protected UpdateSettingsRequest newRequest() {
        return new UpdateSettingsRequest();
    }

    @Override
    protected UpdateSettingsResponse newResponse() {
        return new UpdateSettingsResponse();
    }

    @Override
    protected void doExecute(UpdateSettingsRequest request, ActionListener<UpdateSettingsResponse> listener) {
        request.indices(this.clusterService.state().metaData().concreteIndices(request.indices(), request.indicesOptions()));
        super.doExecute(request, listener);
    }

    @Override
    protected void masterOperation(final UpdateSettingsRequest request, ClusterState state, final ActionListener<UpdateSettingsResponse> listener) throws ElasticsearchException {
        UpdateSettingsClusterStateUpdateRequest clusterStateUpdateRequest = (UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)new UpdateSettingsClusterStateUpdateRequest().indices(request.indices())).settings(request.settings()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
        this.updateSettingsService.updateSettings(clusterStateUpdateRequest, new ClusterStateUpdateListener(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new UpdateSettingsResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Throwable t) {
                TransportUpdateSettingsAction.this.logger.debug("failed to update settings on indices [{}]", t, (Object[])request.indices());
                listener.onFailure(t);
            }
        });
    }
}

