/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetFieldMappingsAction
extends TransportClusterInfoAction<GetFieldMappingsRequest, GetFieldMappingsResponse> {
    private final IndicesService indicesService;
    private static final ToXContent.Params includeDefaultsParams = new ToXContent.Params(){
        static final String INCLUDE_DEFAULTS = "include_defaults";

        @Override
        public String param(String key) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return null;
        }

        @Override
        public String param(String key, String defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        @Override
        @Deprecated
        public Boolean paramAsBooleanOptional(String key, Boolean defaultValue) {
            return this.paramAsBoolean(key, defaultValue);
        }
    };

    @Inject
    public TransportGetFieldMappingsAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool) {
        super(settings, transportService, clusterService, threadPool);
        this.indicesService = indicesService;
    }

    @Override
    protected String transportAction() {
        return "mappings/fields/get";
    }

    @Override
    protected GetFieldMappingsRequest newRequest() {
        return new GetFieldMappingsRequest();
    }

    @Override
    protected GetFieldMappingsResponse newResponse() {
        return new GetFieldMappingsResponse();
    }

    @Override
    protected void doMasterOperation(GetFieldMappingsRequest request, ClusterState state, ActionListener<GetFieldMappingsResponse> listener) throws ElasticsearchException {
        listener.onResponse(new GetFieldMappingsResponse(this.findMappings(request.indices(), request.types(), request.fields(), request.includeDefaults())));
    }

    private ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>>> findMappings(String[] concreteIndices, final String[] types, String[] fields, boolean includeDefaults) {
        assert (types != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableMap.of();
        }
        boolean isProbablySingleFieldRequest = concreteIndices.length == 1 && types.length == 1 && fields.length == 1;
        ImmutableMap.Builder indexMapBuilder = ImmutableMap.builder();
        Sets.SetView<String> intersection = Sets.intersection(Sets.newHashSet(concreteIndices), this.indicesService.indices());
        for (String index : intersection) {
            IndexService indexService = this.indicesService.indexService(index);
            Collection<String> typeIntersection = types.length == 0 ? indexService.mapperService().types() : Collections2.filter(indexService.mapperService().types(), new Predicate<String>(){

                @Override
                public boolean apply(String type) {
                    return Regex.simpleMatch(types, type);
                }
            });
            MapBuilder<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>> typeMappings = new MapBuilder<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>>();
            for (String type : typeIntersection) {
                DocumentMapper documentMapper = indexService.mapperService().documentMapper(type);
                ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMapping = this.findFieldMappingsByType(documentMapper, fields, includeDefaults, isProbablySingleFieldRequest);
                if (fieldMapping.isEmpty()) continue;
                typeMappings.put(type, fieldMapping);
            }
            if (typeMappings.isEmpty()) continue;
            indexMapBuilder.put(index, typeMappings.immutableMap());
        }
        return indexMapBuilder.build();
    }

    private ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData> findFieldMappingsByType(DocumentMapper documentMapper, String[] fields, boolean includeDefaults, boolean isProbablySingleFieldRequest) throws ElasticsearchException {
        MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappings = new MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData>();
        ImmutableList<FieldMapper> allFieldMappers = documentMapper.mappers().mappers();
        for (String field : fields) {
            if (Regex.isMatchAllPattern(field)) {
                for (FieldMapper fieldMapper : allFieldMappers) {
                    this.addFieldMapper(fieldMapper.names().fullName(), fieldMapper, fieldMappings, includeDefaults);
                }
                continue;
            }
            if (Regex.isSimpleMatchPattern(field)) {
                FieldMapper fieldMapper;
                int i;
                boolean[] resolved = new boolean[allFieldMappers.size()];
                for (i = 0; i < allFieldMappers.size(); ++i) {
                    fieldMapper = (FieldMapper)allFieldMappers.get(i);
                    if (!Regex.simpleMatch(field, fieldMapper.names().fullName())) continue;
                    this.addFieldMapper(fieldMapper.names().fullName(), fieldMapper, fieldMappings, includeDefaults);
                    resolved[i] = true;
                }
                for (i = 0; i < allFieldMappers.size(); ++i) {
                    if (resolved[i] || !Regex.simpleMatch(field, (fieldMapper = (FieldMapper)allFieldMappers.get(i)).names().indexName())) continue;
                    this.addFieldMapper(fieldMapper.names().indexName(), fieldMapper, fieldMappings, includeDefaults);
                    resolved[i] = true;
                }
                for (i = 0; i < allFieldMappers.size(); ++i) {
                    if (resolved[i] || !Regex.simpleMatch(field, (fieldMapper = (FieldMapper)allFieldMappers.get(i)).names().name())) continue;
                    this.addFieldMapper(fieldMapper.names().name(), fieldMapper, fieldMappings, includeDefaults);
                    resolved[i] = true;
                }
                continue;
            }
            FieldMapper fieldMapper = documentMapper.mappers().smartNameFieldMapper(field);
            if (fieldMapper != null) {
                this.addFieldMapper(field, fieldMapper, fieldMappings, includeDefaults);
                continue;
            }
            if (!isProbablySingleFieldRequest) continue;
            fieldMappings.put(field, GetFieldMappingsResponse.FieldMappingMetaData.NULL);
        }
        return fieldMappings.immutableMap();
    }

    private void addFieldMapper(String field, FieldMapper fieldMapper, MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappings, boolean includeDefaults) {
        if (fieldMappings.containsKey(field)) {
            return;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            fieldMapper.toXContent(builder, includeDefaults ? includeDefaultsParams : ToXContent.EMPTY_PARAMS);
            builder.endObject();
            fieldMappings.put(field, new GetFieldMappingsResponse.FieldMappingMetaData(fieldMapper.names().fullName(), builder.bytes()));
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to serialize XContent of field [" + field + "]", e);
        }
    }
}

