/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ektorp.InvalidDocumentException;
import org.ektorp.util.Assert;
import org.ektorp.util.DocumentAccessor;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Documents {
    private static final Logger LOG = LoggerFactory.getLogger(Documents.class);
    private static final ConcurrentMap<Class<?>, DocumentAccessor> accessors = new ConcurrentHashMap();
    private static final String ID_FIELD_NAME = "_id";
    private static final String REV_FIELD_NAME = "_rev";

    public static void registerAccessor(Class<?> documentType, DocumentAccessor accessor) {
        Assert.notNull(documentType, "documentType may not be null");
        Assert.notNull(accessor, "accessor may not be null");
        if (accessors.containsKey(documentType)) {
            DocumentAccessor existing = Documents.getAccessor(documentType);
            LOG.warn(String.format("DocumentAccessor for class %s already exists: %s will be overridden by %s", documentType, existing.getClass(), accessor.getClass()));
        }
        Documents.putAccessor(documentType, accessor);
        LOG.debug("Registered document accessor: {} for class: {}", accessor.getClass(), documentType);
    }

    public static String getId(Object document) {
        return Documents.getAccessor(document).getId(document);
    }

    public static void setId(Object document, String id) {
        DocumentAccessor d = Documents.getAccessor(document);
        if (d.hasIdMutator()) {
            d.setId(document, id);
        }
    }

    public static String getRevision(Object document) {
        return Documents.getAccessor(document).getRevision(document);
    }

    public static void setRevision(Object document, String rev) {
        Documents.getAccessor(document).setRevision(document, rev);
    }

    public static boolean isNew(Object document) {
        return Documents.getRevision(document) == null;
    }

    private static <T> void putAccessor(Class<? extends T> documentType, DocumentAccessor accessor) {
        accessors.put(documentType, accessor);
    }

    private static DocumentAccessor getAccessor(Class<?> documentType) {
        return (DocumentAccessor)accessors.get(documentType);
    }

    private static DocumentAccessor getAccessor(Object document) {
        Class<?> clazz = document.getClass();
        DocumentAccessor accessor = Documents.getAccessor(clazz);
        if (accessor == null) {
            if (document instanceof Map) {
                accessor = Documents.getAccessor(Map.class);
                Documents.putAccessor(clazz, accessor);
            } else if (document instanceof ObjectNode) {
                accessor = Documents.getAccessor(ObjectNode.class);
                Documents.putAccessor(clazz, accessor);
            } else {
                try {
                    accessor = new AnnotatedMethodAccessor(clazz);
                }
                catch (InvalidDocumentException eAnnotatedMethod) {
                    try {
                        accessor = new AnnotatedFieldAccessor(clazz);
                    }
                    catch (InvalidDocumentException eAnnotatedField) {
                        accessor = new MethodAccessor(clazz);
                    }
                }
                accessors.putIfAbsent(clazz, accessor);
                accessor = Documents.getAccessor(clazz);
            }
        }
        return accessor;
    }

    static {
        accessors.put(Map.class, new MapAccessor());
        Documents.putAccessor(ObjectNode.class, new ObjectNodeAccessor());
    }

    private static final class ObjectNodeAccessor
    implements DocumentAccessor {
        private ObjectNodeAccessor() {
        }

        @Override
        public boolean hasIdMutator() {
            return true;
        }

        @Override
        public String getId(Object o) {
            return this.getFieldValue(o, Documents.ID_FIELD_NAME);
        }

        @Override
        public void setId(Object o, String id) {
            this.setField(o, Documents.ID_FIELD_NAME, id);
        }

        @Override
        public String getRevision(Object o) {
            return this.getFieldValue(o, Documents.REV_FIELD_NAME);
        }

        @Override
        public void setRevision(Object o, String rev) {
            this.setField(o, Documents.REV_FIELD_NAME, rev);
        }

        private String getFieldValue(Object o, String fieldName) {
            JsonNode target = (JsonNode)o;
            JsonNode field = target.get(fieldName);
            if (field == null) {
                return null;
            }
            if (!field.isTextual()) {
                throw Exceptions.newRTE("field %s in node: %s is not textual ", fieldName, target);
            }
            return field.textValue();
        }

        private void setField(Object o, String fieldName, String fieldValue) {
            ((ObjectNode)o).put(fieldName, fieldValue);
        }
    }

    private static final class MapAccessor
    implements DocumentAccessor {
        private MapAccessor() {
        }

        @Override
        public String getId(Object o) {
            return this.cast(o).get(Documents.ID_FIELD_NAME);
        }

        @Override
        public String getRevision(Object o) {
            return this.cast(o).get(Documents.REV_FIELD_NAME);
        }

        @Override
        public boolean hasIdMutator() {
            return true;
        }

        @Override
        public void setId(Object o, String id) {
            this.cast(o).put(Documents.ID_FIELD_NAME, id);
        }

        @Override
        public void setRevision(Object o, String rev) {
            this.cast(o).put(Documents.REV_FIELD_NAME, rev);
        }

        private Map<String, String> cast(Object o) {
            return (Map)o;
        }
    }

    private static final class AnnotatedFieldAccessor
    implements DocumentAccessor {
        Field idAccessor;
        Field idMutator;
        Field revisionAccessor;
        Field revisionMutator;

        AnnotatedFieldAccessor(Class<?> clazz) {
            try {
                this.idAccessor = this.resolveIdAccessor(clazz);
                this.assertFieldFound(clazz, this.idAccessor, "id accessor");
                this.idMutator = this.resolveIdMutator(clazz);
                this.revisionAccessor = this.resolveRevAccessor(clazz);
                this.assertFieldFound(clazz, this.revisionAccessor, "revision accessor");
                this.revisionMutator = this.resolveRevMutator(clazz);
                this.assertFieldFound(clazz, this.revisionMutator, "revision mutator");
            }
            catch (InvalidDocumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public boolean hasIdMutator() {
            return this.idMutator != null;
        }

        private void assertFieldFound(Class<?> clazz, Field f, String missingField) {
            if (f == null) {
                throw new InvalidDocumentException(clazz, missingField);
            }
        }

        private Field resolveRevAccessor(Class<?> clazz) throws Exception {
            return this.findAnnotatedField(clazz, Documents.REV_FIELD_NAME);
        }

        private Field resolveIdAccessor(Class<?> clazz) throws Exception {
            return this.findAnnotatedField(clazz, Documents.ID_FIELD_NAME);
        }

        private Field resolveIdMutator(Class<?> clazz) throws Exception {
            return this.findAnnotatedField(clazz, Documents.ID_FIELD_NAME);
        }

        private Field resolveRevMutator(Class<?> clazz) throws Exception {
            return this.findAnnotatedField(clazz, Documents.REV_FIELD_NAME);
        }

        private Field findAnnotatedField(Class<?> clazz, String annotationValue) {
            for (Field me : clazz.getDeclaredFields()) {
                JsonProperty a = me.getAnnotation(JsonProperty.class);
                if (a == null || !a.value().equals(annotationValue)) continue;
                me.setAccessible(true);
                return me;
            }
            return clazz.getSuperclass() != null ? this.findAnnotatedField(clazz.getSuperclass(), annotationValue) : null;
        }

        @Override
        public String getId(Object o) {
            try {
                return (String)this.idAccessor.get(o);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public void setId(Object o, String id) {
            try {
                this.idMutator.set(o, id);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public String getRevision(Object o) {
            try {
                return (String)this.revisionAccessor.get(o);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public void setRevision(Object o, String rev) {
            try {
                this.revisionMutator.set(o, rev);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }
    }

    private static final class AnnotatedMethodAccessor
    extends MethodAccessor {
        AnnotatedMethodAccessor(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected Method resolveRevAccessor(Class<?> clazz) throws Exception {
            return this.findAnnotatedMethod(clazz, Documents.REV_FIELD_NAME, String.class);
        }

        @Override
        protected Method resolveIdAccessor(Class<?> clazz) throws Exception {
            return this.findAnnotatedMethod(clazz, Documents.ID_FIELD_NAME, String.class);
        }

        @Override
        protected Method resolveIdMutator(Class<?> clazz) throws Exception {
            return this.findAnnotatedMethod(clazz, Documents.ID_FIELD_NAME, Void.TYPE);
        }

        @Override
        protected Method resolveRevMutator(Class<?> clazz) throws Exception {
            return this.findAnnotatedMethod(clazz, Documents.REV_FIELD_NAME, Void.TYPE);
        }

        private Method findAnnotatedMethod(Class<?> clazz, String annotationValue, Class<?> returnType) {
            for (Method me : clazz.getDeclaredMethods()) {
                JsonProperty a = me.getAnnotation(JsonProperty.class);
                if (a == null || !a.value().equals(annotationValue) || !returnType.isAssignableFrom(me.getReturnType())) continue;
                me.setAccessible(true);
                return me;
            }
            return clazz.getSuperclass() != null ? this.findAnnotatedMethod(clazz.getSuperclass(), annotationValue, returnType) : null;
        }
    }

    private static class MethodAccessor
    implements DocumentAccessor {
        private final Class<?>[] NO_PARAMS = new Class[0];
        private final Object[] NO_ARGS = new Object[0];
        Method idAccessor;
        Method idMutator;
        Method revisionAccessor;
        Method revisionMutator;

        MethodAccessor(Class<?> clazz) {
            try {
                this.idAccessor = this.resolveIdAccessor(clazz);
                this.assertMethodFound(clazz, this.idAccessor, "id accessor");
                this.idMutator = this.resolveIdMutator(clazz);
                this.revisionAccessor = this.resolveRevAccessor(clazz);
                this.assertMethodFound(clazz, this.revisionAccessor, "revision accessor");
                this.revisionMutator = this.resolveRevMutator(clazz);
                this.assertMethodFound(clazz, this.revisionMutator, "revision mutator");
            }
            catch (InvalidDocumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public boolean hasIdMutator() {
            return this.idMutator != null;
        }

        protected void assertMethodFound(Class<?> clazz, Method m, String missingField) {
            if (m == null) {
                throw new InvalidDocumentException(clazz, missingField);
            }
        }

        protected Method resolveRevAccessor(Class<?> clazz) throws Exception {
            return this.findMethod(clazz, "getRevision", this.NO_PARAMS);
        }

        protected Method resolveIdAccessor(Class<?> clazz) throws Exception {
            return this.findMethod(clazz, "getId", this.NO_PARAMS);
        }

        private Method findMethod(Class<?> clazz, String name, Class<?> ... parameters) throws Exception {
            for (Method me : clazz.getDeclaredMethods()) {
                if (!me.getName().equals(name) || me.getParameterTypes().length != parameters.length) continue;
                me.setAccessible(true);
                return me;
            }
            return clazz.getSuperclass() != null ? this.findMethod(clazz.getSuperclass(), name, parameters) : null;
        }

        protected Method resolveIdMutator(Class<?> clazz) throws Exception {
            return this.findMethod(clazz, "setId", String.class);
        }

        protected Method resolveRevMutator(Class<?> clazz) throws Exception {
            return this.findMethod(clazz, "setRevision", String.class);
        }

        @Override
        public String getId(Object o) {
            try {
                return (String)this.idAccessor.invoke(o, this.NO_ARGS);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public void setId(Object o, String id) {
            try {
                this.idMutator.invoke(o, id);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public String getRevision(Object o) {
            try {
                return (String)this.revisionAccessor.invoke(o, this.NO_ARGS);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public void setRevision(Object o, String rev) {
            try {
                this.revisionMutator.invoke(o, rev);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }
    }
}

