/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.support;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AttachmentsInOrderParser {
    public static List<String> parseAttachmentNames(JsonParser documentJsonParser) throws IOException {
        JsonToken jsonToken;
        documentJsonParser.nextToken();
        while ((jsonToken = documentJsonParser.nextToken()) != JsonToken.END_OBJECT) {
            if ("_attachments".equals(documentJsonParser.getCurrentName())) {
                return AttachmentsInOrderParser.readAttachments(documentJsonParser);
            }
            if (jsonToken != JsonToken.START_OBJECT) continue;
            AttachmentsInOrderParser.readIgnoreObject(documentJsonParser);
        }
        return null;
    }

    private static List<String> readAttachments(JsonParser jsonParser) throws IOException {
        jsonParser.nextToken();
        return AttachmentsInOrderParser.readAttachmentsObject(jsonParser);
    }

    private static List<String> readAttachmentsObject(JsonParser jsonParser) throws IOException {
        ArrayList<String> attachmentNameList = new ArrayList<String>();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String attachmentName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
                String message = "_attachments contains an invalid object.";
                throw new JsonParseException(message, jsonParser.getCurrentLocation());
            }
            AttachmentsInOrderParser.readIgnoreObject(jsonParser);
            attachmentNameList.add(attachmentName);
        }
        return attachmentNameList;
    }

    private static void readIgnoreObject(JsonParser jsonParser) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            AttachmentsInOrderParser.readIgnoreObject(jsonParser);
        }
    }
}

