/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ektorp.CouchDbConnector;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.impl.docref.BackReferencedBeanDeserializer;
import org.ektorp.impl.docref.ConstructibleAnnotatedCollection;
import org.ektorp.util.Predicate;
import org.ektorp.util.ReflectionUtils;

public class EktorpBeanDeserializerModifier
extends BeanDeserializerModifier {
    private final CouchDbConnector db;
    private final ObjectMapper objectMapper;
    static final Map<String, Class<? extends Collection>> _collectionFallbacks = new HashMap<String, Class<? extends Collection>>();

    public EktorpBeanDeserializerModifier(CouchDbConnector db, ObjectMapper objectMapper) {
        this.db = db;
        this.objectMapper = objectMapper;
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        List<ConstructibleAnnotatedCollection> fields;
        if (deserializer instanceof BeanDeserializer && !(fields = this.collectFields(config, beanDesc)).isEmpty()) {
            return new BackReferencedBeanDeserializer((BeanDeserializer)deserializer, fields, this.db, beanDesc.getType().getRawClass());
        }
        return super.modifyDeserializer(config, beanDesc, deserializer);
    }

    private List<ConstructibleAnnotatedCollection> collectFields(final DeserializationConfig config, final BeanDescription desc) {
        final ArrayList<ConstructibleAnnotatedCollection> fields = new ArrayList<ConstructibleAnnotatedCollection>();
        final LinkedHashMap<String, AnnotatedMethod> setters = new LinkedHashMap<String, AnnotatedMethod>();
        List properties = desc.findProperties();
        for (BeanPropertyDefinition beanPropertyDefinition : properties) {
            setters.put(beanPropertyDefinition.getInternalName(), beanPropertyDefinition.getSetter());
        }
        ReflectionUtils.eachField(desc.getType().getRawClass(), new Predicate<Field>(){

            @Override
            public boolean apply(Field input) {
                ConstructibleAnnotatedCollection c;
                if (ReflectionUtils.hasAnnotation(input, DocumentReferences.class) && (c = EktorpBeanDeserializerModifier.this.collectBackrefField(config, desc, setters, input)) != null) {
                    fields.add(c);
                }
                return false;
            }
        });
        return fields;
    }

    private ConstructibleAnnotatedCollection collectBackrefField(DeserializationConfig config, BeanDescription beanDesc, Map<String, AnnotatedMethod> setters, Field field) {
        JavaType type = this.objectMapper.getTypeFactory().constructType(field.getGenericType());
        if (!(type instanceof CollectionType)) {
            return null;
        }
        CollectionType collectionType = (CollectionType)type;
        return new ConstructibleAnnotatedCollection(field, this.findCtor(config, collectionType, field.getType()), this.constructSettableProperty(config, beanDesc, field.getName(), setters.get(field.getName()), (JavaType)collectionType), collectionType);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config, BeanDescription beanDesc, String name, AnnotatedMethod setter, JavaType type) {
        Method member;
        if (!(!config.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS) || Modifier.isPublic((member = setter.getAnnotated()).getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers()))) {
            member.setAccessible(true);
        }
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        MethodProperty prop = new MethodProperty((BeanPropertyDefinition)SimpleBeanPropertyDefinition.construct((MapperConfig)config, (AnnotatedMember)setter), type, typeDeser, beanDesc.getClassAnnotations(), setter);
        AnnotationIntrospector.ReferenceProperty ref = config.getAnnotationIntrospector().findReferenceType((AnnotatedMember)setter);
        if (ref != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    private Constructor<Collection<Object>> findCtor(DeserializationConfig config, CollectionType type, Class<?> clazz) {
        Class<Object> collectionClass = clazz;
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type);
            }
            collectionClass = fallback;
        }
        boolean fixAccess = config.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        Constructor ctor = ClassUtil.findConstructor(collectionClass, (boolean)fixAccess);
        return ctor;
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        return super.updateBuilder(config, beanDesc, builder);
    }

    static {
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), LinkedHashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
    }
}

