/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.ektorp.DbAccessException;
import org.ektorp.DocumentNotFoundException;
import org.ektorp.UpdateConflictException;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;

public class StdResponseHandler<T>
implements ResponseCallback<T> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static DbAccessException createDbAccessException(HttpResponse hr) {
        String body;
        Object responseBody;
        try {
            InputStream content = hr.getContent();
            responseBody = content != null ? StdResponseHandler.responseBodyAsNode(IOUtils.toString((InputStream)content)) : NullNode.getInstance();
        }
        catch (Exception e) {
            responseBody = NullNode.getInstance();
        }
        switch (hr.getCode()) {
            case 404: {
                return new DocumentNotFoundException(hr.getRequestURI(), (JsonNode)responseBody);
            }
            case 409: {
                return new UpdateConflictException();
            }
        }
        try {
            body = StdResponseHandler.toPrettyString((JsonNode)responseBody);
        }
        catch (IOException e) {
            body = "unavailable";
        }
        return new DbAccessException(hr.toString() + "\nURI: " + hr.getRequestURI() + "\nResponse Body: \n" + body);
    }

    private static String toPrettyString(JsonNode n) throws IOException {
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)n);
    }

    private static JsonNode responseBodyAsNode(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return NullNode.getInstance();
        }
        if (!s.startsWith("{")) {
            return NullNode.getInstance();
        }
        return MAPPER.readTree(s);
    }

    protected static JsonNode responseBodyAsNode(InputStream inputStream, ObjectMapper mapper) throws IOException {
        return mapper.readTree(inputStream);
    }

    protected static <T> T checkResponseBodyOkAndReturnDefaultValue(HttpResponse hr, T defaultValue, ObjectMapper mapper) throws IOException {
        InputStream content = hr.getContent();
        try {
            content = hr.getContent();
            JsonNode body = StdResponseHandler.responseBodyAsNode(content, MAPPER);
            JsonNode okNode = body.get("ok");
            if (okNode != null && okNode.isBoolean() && okNode.booleanValue()) {
                T t = defaultValue;
                return t;
            }
            throw new DbAccessException("Unexpected response body content, expected {\"ok\":true}, got " + body.toString());
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    @Override
    public T error(HttpResponse hr) {
        throw StdResponseHandler.createDbAccessException(hr);
    }

    @Override
    public T success(HttpResponse hr) throws Exception {
        return StdResponseHandler.checkResponseBodyOkAndReturnDefaultValue(hr, null, MAPPER);
    }
}

