/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.ektorp.http.HttpResponse;
import org.ektorp.util.Exceptions;

public class StdHttpResponse
implements HttpResponse {
    private static final HttpEntity NULL_ENTITY = new NullEntity();
    private final HttpEntity entity;
    private final StatusLine status;
    private final String requestURI;
    private final HttpUriRequest httpRequest;
    private final String revision;

    public static StdHttpResponse of(org.apache.http.HttpResponse rsp, HttpUriRequest httpRequest) {
        return new StdHttpResponse(rsp.getEntity(), rsp.getStatusLine(), httpRequest, rsp.getFirstHeader("ETag"));
    }

    public StdHttpResponse(HttpEntity e, StatusLine status, HttpUriRequest httpRequest, Header eTagHeader) {
        this.httpRequest = httpRequest;
        this.entity = e != null ? e : NULL_ENTITY;
        this.status = status;
        this.requestURI = httpRequest.getURI().toString();
        this.revision = eTagHeader != null ? eTagHeader.getValue().replace("\"", "") : null;
    }

    @Override
    public int getCode() {
        return this.status.getStatusCode();
    }

    public String getReason() {
        return this.status.getReasonPhrase();
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public long getContentLength() {
        return this.entity.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.entity.getContentType().getValue();
    }

    @Override
    public InputStream getContent() {
        try {
            return new ConnectionReleasingInputStream(this.entity.getContent());
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    @Override
    public String getETag() {
        return this.revision;
    }

    @Override
    public boolean isSuccessful() {
        return this.getCode() < 300;
    }

    @Override
    public void releaseConnection() {
        try {
            if (this.entity.getContent() != null) {
                this.entity.getContent().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void abort() {
        this.httpRequest.abort();
    }

    public String toString() {
        return this.status.getStatusCode() + ":" + this.status.getReasonPhrase();
    }

    private static class NullEntity
    implements HttpEntity {
        static final Header contentType = new BasicHeader("Content-Type", "null");
        static final Header contentEncoding = new BasicHeader("Content-Encoding", "UTF-8");

        private NullEntity() {
        }

        public void consumeContent() throws IOException {
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return null;
        }

        public Header getContentEncoding() {
            return contentEncoding;
        }

        public long getContentLength() {
            return 0L;
        }

        public Header getContentType() {
            return contentType;
        }

        public boolean isChunked() {
            return false;
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isStreaming() {
            return false;
        }

        public void writeTo(OutputStream outstream) throws IOException {
            throw new UnsupportedOperationException("NullEntity cannot write");
        }
    }

    private class ConnectionReleasingInputStream
    extends FilterInputStream {
        private ConnectionReleasingInputStream(InputStream src) {
            super(src);
        }

        @Override
        public void close() throws IOException {
            StdHttpResponse.this.releaseConnection();
        }
    }
}

