/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.ektorp.util.Assert;
import org.ektorp.util.Exceptions;

@NotThreadSafe
@SuppressWarnings(value={"HE_EQUALS_USE_HASHCODE"})
public class JacksonableEntity
extends AbstractHttpEntity {
    private byte[] objSer;
    private final Object objRef;
    private final ObjectMapper objectMapper;

    public JacksonableEntity(Object ser, boolean bufferize, ObjectMapper objectMapper) {
        Assert.notNull(ser, "Source object");
        this.objectMapper = objectMapper;
        this.objRef = ser;
        if (bufferize) {
            try {
                this.createBytes(ser);
            }
            catch (IOException e) {
                throw Exceptions.propagate(e);
            }
        }
        this.setContentType("application/json");
    }

    public JacksonableEntity(Object ser, ObjectMapper objectMapper) {
        this(ser, false, objectMapper);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof JacksonableEntity)) {
            return false;
        }
        JacksonableEntity other = (JacksonableEntity)((Object)o);
        return this.objRef == other.objRef;
    }

    private void createBytes(Object ser) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.objectMapper.writeValue((OutputStream)baos, ser);
        this.objSer = baos.toByteArray();
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        if (this.objSer == null) {
            this.createBytes(this.objRef);
        }
        return new ByteArrayInputStream(this.objSer);
    }

    public long getContentLength() {
        if (this.objSer == null) {
            return -1L;
        }
        return this.objSer.length;
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return this.objSer == null;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Assert.notNull(outstream, "Output stream");
        if (this.objSer == null) {
            this.objectMapper.writeValue(outstream, this.objRef);
            outstream.flush();
        } else {
            outstream.write(this.objSer);
            outstream.flush();
        }
    }

    public Object getTarget() {
        return this.objRef;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

