/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.dataload;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import org.ektorp.CouchDbConnector;
import org.ektorp.util.Assert;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDataLoader.class);
    private final ObjectMapper objectMapper;
    protected final CouchDbConnector db;

    public DefaultDataLoader(CouchDbConnector db) {
        this(db, new ObjectMapper());
    }

    public DefaultDataLoader(CouchDbConnector db, ObjectMapper objectMapper) {
        Assert.notNull(db, "CouchDbConnector cannot be null");
        Assert.notNull(objectMapper, "ObjectMapper cannot be null");
        this.db = db;
        this.objectMapper = objectMapper;
    }

    public void load(Reader in) {
        try {
            this.doLoad(in);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    private void doLoad(Reader in) throws IOException, JsonParseException, JsonMappingException {
        HashSet<String> allIds = new HashSet<String>(this.db.getAllDocIds());
        JsonNode jn = (JsonNode)this.objectMapper.readValue(in, JsonNode.class);
        Iterator i = jn.elements();
        while (i.hasNext()) {
            JsonNode n = (JsonNode)i.next();
            String id = n.get("_id").textValue();
            if (allIds.contains(id)) continue;
            LOG.info("adding {} to database", (Object)id);
            this.createDocument(n, id);
        }
    }

    protected void createDocument(JsonNode n, String id) {
        this.db.create(id, n);
    }
}

