/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ektorp.DbAccessException;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpResponse;

public class StreamingViewResult
implements Serializable,
Iterable<ViewResult.Row>,
Closeable {
    private static final String OFFSET_FIELD_NAME = "offset";
    private static final String TOTAL_ROWS_FIELD_NAME = "total_rows";
    private static final long serialVersionUID = 4750290767936801714L;
    private int totalRows = -1;
    private int offset = -1;
    @SuppressWarnings(value={"SE_BAD_FIELD"})
    private final BufferedReader reader;
    private final ObjectMapper objectMapper;
    private boolean iteratorCalled;
    private final boolean ignoreNotFound;
    @SuppressWarnings(value={"SE_BAD_FIELD"})
    private final HttpResponse httpResponse;

    @SuppressWarnings(value={"DM_DEFAULT_ENCODING", "NP_DEREFERENCE_OF_READLINE_VALUE"})
    public StreamingViewResult(ObjectMapper objectMapper, HttpResponse httpResponse, boolean ignoreNotFound) {
        this.objectMapper = objectMapper;
        this.httpResponse = httpResponse;
        this.ignoreNotFound = ignoreNotFound;
        this.reader = new BufferedReader(new InputStreamReader(httpResponse.getContent()));
        try {
            String info = this.reader.readLine();
            this.totalRows = this.getFieldValue(info, TOTAL_ROWS_FIELD_NAME);
            this.offset = this.getFieldValue(info, OFFSET_FIELD_NAME);
        }
        catch (IOException e) {
            throw new DbAccessException(e);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    @Override
    public Iterator<ViewResult.Row> iterator() {
        if (this.iteratorCalled) {
            throw new IllegalStateException("Iterator can only be called once!");
        }
        this.iteratorCalled = true;
        return new StreamingViewResultIterator();
    }

    public void abort() {
        this.httpResponse.abort();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getFieldValue(String line, String key) {
        int index = line.indexOf(key);
        if (index == -1) {
            return -1;
        }
        int fromIndex = index + key.length() + 2;
        return Integer.parseInt(line.substring(fromIndex, line.indexOf(",", fromIndex)));
    }

    private class StreamingViewResultIterator
    implements Iterator<ViewResult.Row> {
        private ViewResult.Row row;
        private boolean closed = false;

        private StreamingViewResultIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.closed) {
                return false;
            }
            if (this.row != null) {
                return true;
            }
            try {
                JsonNode node;
                do {
                    String doc;
                    if ((doc = StreamingViewResult.this.reader.readLine()) == null || doc.equals("]}")) {
                        StreamingViewResult.this.reader.close();
                        this.closed = true;
                        return false;
                    }
                    if (doc.endsWith(",")) {
                        doc = doc.substring(0, doc.length() - 1);
                    }
                    node = StreamingViewResult.this.objectMapper.readTree(doc);
                } while (StreamingViewResult.this.ignoreNotFound && node.has("error"));
                this.row = new ViewResult.Row(node);
                return true;
            }
            catch (IOException e) {
                throw new DbAccessException(e);
            }
        }

        @Override
        public ViewResult.Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Attempt to iterate beyond the result set");
            }
            ViewResult.Row toReturn = this.row;
            this.row = null;
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

