/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ektorp.ViewQuery;
import org.ektorp.util.Base64;
import org.ektorp.util.Exceptions;

public class PageRequest {
    private static final String NEXT_KEY_FIELD_NAME = "key";
    private static final String NEXT_DOCID_FIELD_NAME = "id";
    private static final String PAGE_SIZE_FIELD_NAME = "s";
    private static final String BACK_FIELD_NAME = "b";
    private static final String PAGE_FIELD_NAME = "p";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final int pageSize;
    private final KeyIdPair nextKey;
    private final boolean back;
    private final int page;

    public static ViewQuery applyPagingParameters(ViewQuery q, PageRequest pr) {
        ViewQuery pagedQuery = q.clone();
        if (pr.page > 0) {
            if (pr.getStartKey() != null) {
                pagedQuery.startKey(pr.getStartKey());
            }
            if (pr.getStartKeyDocId() != null) {
                pagedQuery.startDocId(pr.getStartKeyDocId());
            }
            if (pr.back) {
                pagedQuery.descending(!pagedQuery.isDescending());
            }
        }
        int additionalRowsToQuery = 1;
        pagedQuery.limit(pr.getPageSize() + additionalRowsToQuery);
        return pagedQuery;
    }

    public int getPageNo() {
        return this.page;
    }

    public static PageRequest firstPage(int pageSize) {
        return new Builder().pageSize(pageSize).build();
    }

    public Builder nextRequest(Object nextStartKey, String nextStartDocId) {
        try {
            JsonNode keyNode = MAPPER.readTree(MAPPER.writeValueAsString(nextStartKey));
            return new Builder(this).nextKey(new KeyIdPair(keyNode, nextStartDocId));
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    private PageRequest(Builder b) {
        this.back = b.back;
        this.page = b.page;
        this.nextKey = b.nextKey;
        this.pageSize = b.pageSize;
    }

    public static PageRequest fromLink(String link) {
        try {
            JsonNode n = MAPPER.readTree((InputStream)new ByteArrayInputStream(Base64.decode(link, 16)));
            JsonNode keyNode = n.get(NEXT_KEY_FIELD_NAME);
            JsonNode docIdNode = n.get(NEXT_DOCID_FIELD_NAME);
            String docId = null;
            if (docIdNode != null) {
                docId = docIdNode.asText();
            }
            KeyIdPair keyIdPair = keyNode != null || docId != null ? new KeyIdPair(keyNode, docId) : null;
            int pageSize = n.get(PAGE_SIZE_FIELD_NAME).intValue();
            boolean back = n.get(BACK_FIELD_NAME).asInt() == 1;
            int page = n.get(PAGE_FIELD_NAME).asInt();
            return new Builder().nextKey(keyIdPair).pageSize(pageSize).back(back).page(page).build();
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public String asLink() {
        try {
            return Base64.encodeBytes(MAPPER.writeValueAsBytes((Object)this.asJson()), 16);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public JsonNode asJson() {
        ObjectNode n = MAPPER.createObjectNode();
        if (this.nextKey != null) {
            if (this.nextKey.key != null) {
                n.put(NEXT_KEY_FIELD_NAME, this.nextKey.key);
            }
            if (this.nextKey.docId != null) {
                n.put(NEXT_DOCID_FIELD_NAME, this.nextKey.docId);
            }
        }
        n.put(PAGE_SIZE_FIELD_NAME, this.pageSize);
        n.put(BACK_FIELD_NAME, this.back ? 1 : 0);
        n.put(PAGE_FIELD_NAME, this.page);
        return n;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Object getStartKey() {
        return this.nextKey != null ? this.nextKey.key : null;
    }

    public String getStartKeyDocId() {
        return this.nextKey != null ? this.nextKey.docId : null;
    }

    public PageRequest getPreviousPageRequest() {
        return new Builder(this).page(this.page - 1).build();
    }

    public boolean isBack() {
        return this.back;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append("(");
        builder.append("pageSize=").append(this.pageSize);
        builder.append(",page=").append(this.page);
        builder.append(",back=").append(this.back);
        builder.append(",nextKey=").append(this.nextKey);
        builder.append(")");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.back ? 1231 : 1237);
        result = 31 * result + (this.nextKey == null ? 0 : this.nextKey.hashCode());
        result = 31 * result + this.page;
        result = 31 * result + this.pageSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequest other = (PageRequest)obj;
        if (this.back != other.back) {
            return false;
        }
        if (this.nextKey == null ? other.nextKey != null : !this.nextKey.equals(other.nextKey)) {
            return false;
        }
        if (this.page != other.page) {
            return false;
        }
        return this.pageSize == other.pageSize;
    }

    private static final class KeyIdPair {
        final JsonNode key;
        final String docId;

        KeyIdPair(JsonNode key, String docId) {
            this.key = key;
            this.docId = docId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.docId == null ? 0 : this.docId.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.toString().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyIdPair other = (KeyIdPair)obj;
            if (this.docId == null ? other.docId != null : !this.docId.equals(other.docId)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.toString().equals(other.key.toString()));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getName()).append("(");
            builder.append("key=").append(this.key);
            builder.append(",docId=").append(this.docId);
            builder.append(")");
            return builder.toString();
        }
    }

    public static class Builder {
        private int pageSize;
        private KeyIdPair nextKey;
        private boolean back;
        private int page;

        public Builder() {
        }

        public Builder(PageRequest prototype) {
            this.back = prototype.back;
            this.nextKey = prototype.nextKey;
            this.page = prototype.page;
            this.pageSize = prototype.pageSize;
        }

        public Builder pageSize(int i) {
            this.pageSize = i;
            return this;
        }

        public Builder page(int i) {
            this.page = i;
            return this;
        }

        public Builder back(boolean b) {
            this.back = b;
            return this;
        }

        public Builder nextKey(KeyIdPair k) {
            this.nextKey = k;
            return this;
        }

        public PageRequest build() {
            return new PageRequest(this);
        }

        public int getPageNo() {
            return this.page;
        }

        public int getNextPage() {
            return this.page + 1;
        }

        public int getPrevPage() {
            return this.page - 1;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getName()).append("(");
            builder.append("pageSize=").append(this.pageSize);
            builder.append(",page=").append(this.page);
            builder.append(",back=").append(this.back);
            builder.append(",nextKey=").append(this.nextKey);
            builder.append(")");
            return builder.toString();
        }
    }
}

