/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.support;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ektorp.support.OpenCouchDbDocument;
import org.ektorp.util.Assert;

public class DesignDocument
extends OpenCouchDbDocument {
    private static final long serialVersionUID = 727813829995624926L;
    public static final String ID_PREFIX = "_design/";
    private static final String DEFAULT_LANGUAGE = "javascript";
    public static final String AUTO_UPDATE_VIEW_ON_CHANGE = "org.ektorp.support.AutoUpdateViewOnChange";
    public static final String UPDATE_ON_DIFF = "org.ektorp.support.UpdateDesignDocOnDiff";
    @SuppressWarnings(value={"SE_BAD_FIELD"})
    private Map<String, View> views;
    private Map<String, String> lists;
    private Map<String, String> shows;
    private Map<String, String> updateHandlers;
    private String language = "javascript";
    private Map<String, String> filters;

    public DesignDocument() {
    }

    public DesignDocument(String id) {
        this.setId(id);
    }

    @JsonProperty
    public Map<String, View> getViews() {
        return Collections.unmodifiableMap(this.views());
    }

    @JsonProperty
    public Map<String, String> getLists() {
        return Collections.unmodifiableMap(this.lists());
    }

    @JsonProperty
    public Map<String, String> getShows() {
        return Collections.unmodifiableMap(this.shows());
    }

    @JsonProperty
    public Map<String, String> getFilters() {
        return Collections.unmodifiableMap(this.filters());
    }

    @JsonProperty
    public Map<String, String> getUpdates() {
        return Collections.unmodifiableMap(this.updates());
    }

    private Map<String, String> lists() {
        if (this.lists == null) {
            this.lists = new HashMap<String, String>();
        }
        return this.lists;
    }

    private Map<String, String> shows() {
        if (this.shows == null) {
            this.shows = new HashMap<String, String>();
        }
        return this.shows;
    }

    private Map<String, View> views() {
        if (this.views == null) {
            this.views = new HashMap<String, View>();
        }
        return this.views;
    }

    private Map<String, String> filters() {
        if (this.filters == null) {
            this.filters = new HashMap<String, String>();
        }
        return this.filters;
    }

    private Map<String, String> updates() {
        if (this.updateHandlers == null) {
            this.updateHandlers = new HashMap<String, String>();
        }
        return this.updateHandlers;
    }

    @JsonProperty
    void setViews(Map<String, View> views) {
        this.views = views;
    }

    @JsonProperty
    void setShows(Map<String, String> shows) {
        this.shows = shows;
    }

    @JsonProperty
    void setLists(Map<String, String> lists) {
        this.lists = lists;
    }

    @JsonProperty
    void setFilters(Map<String, String> filters) {
        this.filters = filters;
    }

    @JsonProperty
    void setUpdates(Map<String, String> updateHandlers) {
        this.updateHandlers = updateHandlers;
    }

    @JsonProperty
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty
    public void setLanguage(String s) {
        this.language = s;
    }

    public boolean containsView(String name) {
        return this.views().containsKey(name);
    }

    public View get(String viewName) {
        return this.views().get(viewName);
    }

    public void addView(String name, View v) {
        this.views().put(name, v);
    }

    public void removeView(String name) {
        this.views().remove(name);
    }

    public void addListFunction(String name, String function) {
        this.lists().put(name, function);
    }

    public void removeListFunction(String name) {
        this.lists().remove(name);
    }

    public void addShowFunction(String name, String function) {
        this.shows().put(name, function);
    }

    public void removeShowFunction(String name) {
        this.shows().remove(name);
    }

    public void addFilter(String name, String function) {
        this.filters().put(name, function);
    }

    public void removeFilter(String name) {
        this.filters().remove(name);
    }

    public boolean mergeWith(DesignDocument dd) {
        boolean updateOnDiff = this.updateOnDiff();
        boolean changed = this.mergeViews(dd.views(), updateOnDiff);
        changed = this.mergeFunctions(this.lists(), dd.lists(), updateOnDiff) || changed;
        changed = this.mergeFunctions(this.shows(), dd.shows(), updateOnDiff) || changed;
        changed = this.mergeFunctions(this.filters(), dd.filters(), updateOnDiff) || changed;
        changed = this.mergeFunctions(this.updates(), dd.updates(), updateOnDiff) || changed;
        return changed;
    }

    private boolean mergeFunctions(Map<String, String> existing, Map<String, String> mergeFunctions, boolean updateOnDiff) {
        boolean changed = false;
        for (Map.Entry<String, String> e : mergeFunctions.entrySet()) {
            String existingFunc;
            String name = e.getKey();
            String func = e.getValue();
            if (!existing.containsKey(name)) {
                existing.put(name, func);
                changed = true;
                continue;
            }
            if (!updateOnDiff || (existingFunc = existing.get(name)).equals(func)) continue;
            existing.put(name, func);
            changed = true;
        }
        return changed;
    }

    private boolean mergeViews(Map<String, View> mergeViews, boolean updateOnDiff) {
        boolean changed = false;
        for (Map.Entry<String, View> e : mergeViews.entrySet()) {
            View existing;
            String name = e.getKey();
            View candidate = e.getValue();
            if (!this.containsView(name)) {
                this.addView(name, candidate);
                changed = true;
                continue;
            }
            if (!updateOnDiff || (existing = this.get(name)).equals(candidate)) continue;
            this.addView(name, candidate);
            changed = true;
        }
        return changed;
    }

    private boolean updateOnDiff() {
        return Boolean.getBoolean(AUTO_UPDATE_VIEW_ON_CHANGE) || Boolean.getBoolean(UPDATE_ON_DIFF);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class View {
        @JsonProperty
        private String map;
        @JsonProperty
        private String reduce;
        private Map<String, Object> anonymous;

        public View() {
        }

        public static View of(org.ektorp.support.View v) {
            return v.reduce().length() == 0 ? new View(v.map()) : new View(v.map(), v.reduce());
        }

        public View(String map) {
            this.map = map;
        }

        public View(String map, String reduce) {
            this(map);
            this.reduce = reduce;
        }

        public String getMap() {
            return this.map;
        }

        public void setMap(String map) {
            Assert.hasText(map, "the map function may not be null or empty");
            this.map = map;
        }

        public String getReduce() {
            return this.reduce;
        }

        public void setReduce(String reduce) {
            this.reduce = reduce;
        }

        @JsonAnyGetter
        public Map<String, Object> getAnonymous() {
            return this.anonymous();
        }

        @JsonAnySetter
        public void setAnonymous(String key, Object value) {
            this.anonymous().put(key, value);
        }

        private Map<String, Object> anonymous() {
            if (this.anonymous == null) {
                this.anonymous = new HashMap<String, Object>();
            }
            return this.anonymous;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            result = 31 * result + (this.reduce == null ? 0 : this.reduce.hashCode());
            result = 31 * result + (this.anonymous == null ? 0 : this.anonymous.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            View other = (View)obj;
            if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
                return false;
            }
            if (this.reduce == null ? other.reduce != null : !this.reduce.equals(other.reduce)) {
                return false;
            }
            return !(this.anonymous == null ? other.anonymous != null : !this.anonymous.equals(other.anonymous));
        }
    }
}

