/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ektorp.Attachment;
import org.ektorp.support.Revisions;
import org.ektorp.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CouchDbDocument
implements Serializable {
    public static final String ATTACHMENTS_NAME = "_attachments";
    private static final long serialVersionUID = 1L;
    private String id;
    private String revision;
    private Map<String, Attachment> attachments;
    private List<String> conflicts;
    private Revisions revisions;

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="_id")
    public void setId(String s) {
        Assert.hasText(s, "id must have a value");
        if (this.id != null && this.id.equals(s)) {
            return;
        }
        if (this.id != null) {
            throw new IllegalStateException("cannot set id, id already set");
        }
        this.id = s;
    }

    @JsonProperty(value="_rev")
    public String getRevision() {
        return this.revision;
    }

    @JsonProperty(value="_rev")
    public void setRevision(String s) {
        if (s != null && s.length() == 0) {
            return;
        }
        this.revision = s;
    }

    @JsonIgnore
    public boolean isNew() {
        return this.revision == null;
    }

    @JsonProperty(value="_attachments")
    public Map<String, Attachment> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="_attachments")
    void setAttachments(Map<String, Attachment> attachments) {
        this.attachments = attachments;
    }

    @JsonProperty(value="_conflicts")
    void setConflicts(List<String> conflicts) {
        this.conflicts = conflicts;
    }

    @JsonProperty(value="_revisions")
    void setRevisions(Revisions r) {
        this.revisions = r;
    }

    @JsonIgnore
    public Revisions getRevisions() {
        return this.revisions;
    }

    @JsonIgnore
    public List<String> getConflicts() {
        return this.conflicts;
    }

    public boolean hasConflict() {
        return this.conflicts != null && !this.conflicts.isEmpty();
    }

    protected void removeAttachment(String id) {
        Assert.hasText(id, "id may not be null or emtpy");
        if (this.attachments != null) {
            this.attachments.remove(id);
        }
    }

    protected void addInlineAttachment(Attachment a) {
        Assert.notNull(a, "attachment may not be null");
        Assert.hasText(a.getDataBase64(), "attachment must have data base64-encoded");
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Attachment>();
        }
        this.attachments.put(a.getId(), a);
    }
}

