/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import org.ektorp.DocumentOperationResult;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.URI;
import org.ektorp.impl.BulkExecutor;
import org.ektorp.impl.BulkOperation;
import org.ektorp.impl.BulkOperationResponseHandler;
import org.ektorp.impl.JsonSerializer;

public abstract class BulkOperationCollectionBulkExecutor
implements BulkExecutor<Collection<?>> {
    protected URI dbURI;
    protected RestTemplate restTemplate;
    protected ObjectMapper objectMapper;

    public BulkOperationCollectionBulkExecutor() {
    }

    public BulkOperationCollectionBulkExecutor(URI dbURI, RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.dbURI = dbURI;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    protected abstract JsonSerializer getJsonSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DocumentOperationResult> executeBulk(Collection<?> objects, boolean allOrNothing) {
        BulkOperation op = this.getJsonSerializer().createBulkOperation(objects, allOrNothing);
        try {
            List<DocumentOperationResult> result = this.restTemplate.post(this.dbURI.append("_bulk_docs").toString(), op.getData(), new BulkOperationResponseHandler(objects, this.objectMapper));
            op.awaitCompletion();
            List<DocumentOperationResult> list = result;
            return list;
        }
        finally {
            op.close();
        }
    }
}

