/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.field.FieldList;
import org.eclipse.jdt.internal.core.nd.field.FieldLong;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToOne;
import org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.eclipse.jdt.internal.core.nd.java.NdAnnotation;
import org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotation;

public class NdMethodAnnotationData
extends NdNode {
    public static final FieldOneToOne<NdMethod> METHOD;
    public static final FieldLong TAG_BITS;
    public static final FieldList<NdAnnotation> ANNOTATIONS;
    public static final FieldList<NdTypeAnnotation> TYPE_ANNOTATIONS;
    public static final StructDef<NdMethodAnnotationData> type;

    static {
        type = StructDef.create(NdMethodAnnotationData.class, NdNode.type);
        METHOD = FieldOneToOne.createOwner(type, NdMethod.type, NdMethod.ANNOTATION_DATA);
        TAG_BITS = type.addLong();
        ANNOTATIONS = FieldList.create(type, NdAnnotation.type);
        TYPE_ANNOTATIONS = FieldList.create(type, NdTypeAnnotation.type);
        type.done();
    }

    public NdMethodAnnotationData(Nd nd, long address) {
        super(nd, address);
    }

    public NdMethodAnnotationData(NdMethod method) {
        super(method.getNd());
        METHOD.put(this.getNd(), this.address, method);
    }

    public void setTagBits(long bits) {
        TAG_BITS.put(this.getNd(), this.address, bits);
    }

    public long getTagBits() {
        return TAG_BITS.get(this.getNd(), this.address);
    }

    public List<NdTypeAnnotation> getTypeAnnotations() {
        return TYPE_ANNOTATIONS.asList(this.getNd(), this.address);
    }

    public List<NdAnnotation> getAnnotations() {
        return ANNOTATIONS.asList(this.getNd(), this.address);
    }

    public NdAnnotation createAnnotation() {
        return ANNOTATIONS.append(this.getNd(), this.getAddress());
    }

    public void allocateAnnotations(int length) {
        ANNOTATIONS.allocate(this.getNd(), this.getAddress(), length);
    }

    public NdTypeAnnotation createTypeAnnotation() {
        return TYPE_ANNOTATIONS.append(this.getNd(), this.getAddress());
    }

    public void allocateTypeAnnotations(int length) {
        TYPE_ANNOTATIONS.allocate(this.getNd(), this.getAddress(), length);
    }
}

