/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.map.primitive.MutableCharDoubleMap;
import org.eclipse.collections.api.map.primitive.CharDoubleMap;

/**
 * A factory which creates instances of type {@link MutableCharDoubleMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableCharDoubleMapFactory
{
    MutableCharDoubleMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableCharDoubleMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableCharDoubleMap with();

    /**
     * Same as {@link #empty()}. but takes in an initial capacity
     */
    MutableCharDoubleMap ofInitialCapacity(int capacity);

    /**
     * Same as {@link #empty()}. but takes in an initial capacity
     */
    MutableCharDoubleMap withInitialCapacity(int capacity);

    /**
     * Same as {@link #withAll(CharDoubleMap)}.
     */
    MutableCharDoubleMap ofAll(CharDoubleMap map);

    MutableCharDoubleMap withAll(CharDoubleMap map);

    /**
     * Creates an {@code MutableCharDoubleMap} from an {@code Iterable<T>} by applying {@code keyFunction} and {@code valueFunction}.
     *
     * @since 10.0
     */
    <T> MutableCharDoubleMap from(Iterable<T> iterable, CharFunction<? super T> keyFunction, DoubleFunction<? super T> valueFunction);
}
