/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CongestionStatisticLogger
extends CounterStatisticManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CongestionStatisticLogger.class);
    private final SimpleCounterStatistic sentRequests;
    private final SimpleCounterStatistic queueRequests;
    private final SimpleCounterStatistic dequeueRequests;
    private final SimpleCounterStatistic receivedResponses;

    public CongestionStatisticLogger(String tag) {
        super(tag);
        this.sentRequests = new SimpleCounterStatistic("sent-requests", this.align);
        this.queueRequests = new SimpleCounterStatistic("queue-requests", this.align);
        this.dequeueRequests = new SimpleCounterStatistic("dequeue-requests", this.align);
        this.receivedResponses = new SimpleCounterStatistic("recv-responses", this.align);
        this.init();
    }

    public CongestionStatisticLogger(String tag, int interval, TimeUnit unit, ScheduledExecutorService executor) {
        super(tag, (long)interval, unit, executor);
        this.sentRequests = new SimpleCounterStatistic("sent-requests", this.align);
        this.queueRequests = new SimpleCounterStatistic("queue-requests", this.align);
        this.dequeueRequests = new SimpleCounterStatistic("dequeue-requests", this.align);
        this.receivedResponses = new SimpleCounterStatistic("recv-responses", this.align);
        this.init();
    }

    private void init() {
        this.add(this.sentRequests);
        this.add(this.queueRequests);
        this.add(this.receivedResponses);
    }

    public boolean isEnabled() {
        return LOGGER.isInfoEnabled();
    }

    public void dump() {
        try {
            if (this.isEnabled()) {
                if (LOGGER.isDebugEnabled() && (this.receivedResponses.isUsed() || this.sentRequests.isUsed() || this.queueRequests.isUsed())) {
                    String eol = StringUtil.lineSeparator();
                    String head = "   " + this.tag;
                    StringBuilder log = new StringBuilder();
                    log.append(this.tag).append("congestion statistic:").append(eol);
                    log.append(head).append(this.sentRequests).append(eol);
                    log.append(head).append(this.queueRequests).append(eol);
                    log.append(head).append(this.dequeueRequests).append(eol);
                    log.append(head).append(this.receivedResponses).append(eol);
                    LOGGER.debug("{}", (Object)log);
                }
                this.transferCounter();
            }
        }
        catch (Throwable e) {
            LOGGER.error("{}", (Object)this.tag, (Object)e);
        }
    }

    public void sendRequest() {
        this.sentRequests.increment();
    }

    public void queueRequest() {
        this.queueRequests.increment();
    }

    public void dequeueRequest() {
        this.dequeueRequests.increment();
    }

    public void receiveResponse(Response response) {
        if (!response.isDuplicate()) {
            this.receivedResponses.increment();
        }
    }
}

