/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.net.SocketAddress;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveLayer
extends AbstractLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserveLayer.class);

    public ObserveLayer(Configuration config) {
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        ObserveRelation relation = exchange.getRelation();
        if (relation != null && relation.isEstablished()) {
            if (response.isSuccess() ^ response.isNotification()) {
                if (response.isNotification()) {
                    LOGGER.warn("Error notification, remove observe-option {}", (Object)response);
                    response.getOptions().removeObserve();
                } else {
                    LOGGER.warn("No-notification response with observe-relation {}, drop.", (Object)response);
                    response.setSendError(new IllegalArgumentException("Notification must have observe-option!"));
                    return;
                }
            }
            if (exchange.getRequest().isAcknowledged() || exchange.getRequest().getType() == CoAP.Type.NON) {
                if (!response.isSuccess()) {
                    LOGGER.debug("response has error code {} and must be sent as CON", (Object)response.getCode());
                    response.setType(CoAP.Type.CON);
                } else if (relation.check()) {
                    LOGGER.debug("observe relation check requires the notification to be sent as CON");
                    response.setType(CoAP.Type.CON);
                } else if (response.getType() == null) {
                    LOGGER.debug("observe relation sent the message as NON (default)");
                    response.setType(CoAP.Type.NON);
                }
            }
            if (response.getType() == CoAP.Type.CON) {
                this.prepareSelfReplacement(exchange, response);
            }
            if (relation.isPostponedNotification(response)) {
                LOGGER.debug("a former notification is still in transit. Postponing {}", (Object)response);
                return;
            }
        } else if (response.isNotification()) {
            LOGGER.warn("Notification without observe-relation, remove observe-option {}", (Object)response);
            response.getOptions().removeObserve();
        }
        this.lower().sendResponse(exchange, response);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (response.isNotification() && exchange.getRequest().isCanceled()) {
            LOGGER.debug("rejecting notification for canceled Exchange");
            EmptyMessage rst = EmptyMessage.newRST(response);
            this.sendEmptyMessage(exchange, rst);
        } else {
            this.upper().receiveResponse(exchange, response);
        }
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        ObserveRelation relation;
        if (message.getType() == CoAP.Type.RST && exchange.getOrigin() == Exchange.Origin.REMOTE && exchange.getCurrentResponse().isNotification() && (relation = exchange.getRelation()) != null) {
            relation.cleanup();
        }
        this.upper().receiveEmptyMessage(exchange, message);
    }

    private void prepareSelfReplacement(Exchange exchange, Response response) {
        response.addMessageObserver(new NotificationController(exchange, response));
    }

    private class NotificationController
    extends MessageObserverAdapter {
        private final Exchange exchange;
        private final Response response;

        public NotificationController(Exchange exchange, Response response) {
            this.exchange = exchange;
            this.response = response;
        }

        @Override
        public void onAcknowledgement() {
            this.exchange.execute(new Runnable(){

                @Override
                public void run() {
                    ObserveRelation relation = NotificationController.this.exchange.getRelation();
                    boolean canceled = relation.isCanceled();
                    Response next = relation.getNextNotification(NotificationController.this.response, true);
                    if (next != null) {
                        LOGGER.debug("notification has been acknowledged, send the next one");
                        if (canceled) {
                            next.cancel();
                        } else {
                            ObserveLayer.super.sendResponse(NotificationController.this.exchange, next);
                        }
                    }
                }
            });
        }

        @Override
        public void onRetransmission() {
            ObserveRelation relation = this.exchange.getRelation();
            boolean canceled = relation.isCanceled();
            Response next = relation.getNextNotification(this.response, false);
            if (canceled) {
                this.response.cancel();
                if (next != null) {
                    next.cancel();
                    next = null;
                }
            }
            if (next != null) {
                LOGGER.debug("notification has timed out and there is a fresher notification for the retransmission");
                if (next.getType() != CoAP.Type.CON) {
                    next.setType(CoAP.Type.CON);
                    ObserveLayer.this.prepareSelfReplacement(this.exchange, next);
                }
                this.response.cancel();
                ObserveLayer.super.sendResponse(this.exchange, next);
            }
        }

        @Override
        public void onTimeout() {
            ObserveRelation relation = this.exchange.getRelation();
            LOGGER.info("notification for token [{}] timed out. Canceling all relations with source [{}]", (Object)relation.getExchange().getRequest().getToken(), StringUtil.toLog((SocketAddress)relation.getSource()));
            relation.cancelAll();
        }

        @Override
        protected void failed() {
            ObserveRelation relation = this.exchange.getRelation();
            LOGGER.info("notification for token [{}] failed. Source [{}].", (Object)relation.getExchange().getRequest().getToken(), StringUtil.toLog((SocketAddress)relation.getSource()));
            relation.cancel();
        }
    }
}

