/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.deduplication.CropRotation;
import org.eclipse.californium.core.network.deduplication.Deduplicator;
import org.eclipse.californium.core.network.deduplication.NoDeduplicator;
import org.eclipse.californium.core.network.deduplication.SweepDeduplicator;
import org.eclipse.californium.core.network.deduplication.SweepPerPeerDeduplicator;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeduplicatorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeduplicatorFactory.class);
    private static DeduplicatorFactory factory;

    public static synchronized DeduplicatorFactory getDeduplicatorFactory() {
        if (factory == null) {
            factory = new DeduplicatorFactory();
        }
        return factory;
    }

    public static synchronized void setDeduplicatorFactory(DeduplicatorFactory factory) {
        DeduplicatorFactory.factory = factory;
    }

    public Deduplicator createDeduplicator(Configuration config) {
        String type;
        switch (type = (String)config.get((BasicDefinition)CoapConfig.DEDUPLICATOR)) {
            case "PEERS_MARK_AND_SWEEP": {
                return new SweepPerPeerDeduplicator(config);
            }
            case "MARK_AND_SWEEP": {
                return new SweepDeduplicator(config);
            }
            case "CROP_ROTATION": {
                return new CropRotation(config);
            }
            case "NO_DEDUPLICATOR": {
                return new NoDeduplicator();
            }
        }
        LOGGER.warn("configuration contains unsupported deduplicator type, duplicate detection will be turned off");
        return new NoDeduplicator();
    }
}

