/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.Arrays;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.NoResponseOption;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;

public class Option
implements Comparable<Option> {
    private final int number;
    private byte[] value;

    public Option() {
        this.number = 0;
        this.setValue(Bytes.EMPTY);
    }

    public Option(int number) {
        this.number = number;
    }

    public Option(int number, String str) {
        this.number = number;
        this.setStringValue(str);
    }

    public Option(int number, int val) {
        this.number = number;
        this.setIntegerValue(val);
    }

    public Option(int number, long val) {
        this.number = number;
        this.setLongValue(val);
    }

    public Option(int number, byte[] opaque) {
        this.number = number;
        this.setValue(opaque);
    }

    public int getLength() {
        return this.getValue().length;
    }

    public int getNumber() {
        return this.number;
    }

    public byte[] getValue() {
        if (this.value == null) {
            String name = OptionNumberRegistry.toString(this.number);
            throw new IllegalStateException(name + " option value must be set before!");
        }
        return this.value;
    }

    public String getStringValue() {
        return new String(this.getValue(), CoAP.UTF8_CHARSET);
    }

    public int getIntegerValue() {
        int ret = 0;
        byte[] value = this.getValue();
        for (int i = 0; i < value.length; ++i) {
            ret += (value[value.length - i - 1] & 0xFF) << i * 8;
        }
        return ret;
    }

    public long getLongValue() {
        long ret = 0L;
        byte[] value = this.getValue();
        for (int i = 0; i < value.length; ++i) {
            ret += (long)(value[value.length - i - 1] & 0xFF) << i * 8;
        }
        return ret;
    }

    public void setValue(byte[] value) {
        if (value == null) {
            String name = OptionNumberRegistry.toString(this.number);
            throw new NullPointerException(name + " option value must not be null!");
        }
        OptionNumberRegistry.assertValueLength(this.number, value.length);
        this.value = value;
    }

    public void setStringValue(String str) {
        this.setValue(str == null ? null : str.getBytes(CoAP.UTF8_CHARSET));
    }

    public void setIntegerValue(int val) {
        int length = (32 - Integer.numberOfLeadingZeros(val) + 7) / 8;
        byte[] value = new byte[length];
        for (int i = 0; i < length; ++i) {
            value[length - i - 1] = (byte)(val >> i * 8);
        }
        this.setValue(value);
    }

    public void setLongValue(long val) {
        int length = (64 - Long.numberOfLeadingZeros(val) + 7) / 8;
        byte[] value = new byte[length];
        for (int i = 0; i < length; ++i) {
            value[length - i - 1] = (byte)(val >> i * 8);
        }
        this.setValue(value);
    }

    public boolean isCritical() {
        return (this.number & 1) != 0;
    }

    public boolean isUnSafe() {
        return (this.number & 2) != 0;
    }

    public boolean isNoCacheKey() {
        return (this.number & 0x1E) == 28;
    }

    @Override
    public int compareTo(Option o) {
        return this.number - o.number;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option op = (Option)o;
        return this.number == op.number && Arrays.equals(this.value, op.value);
    }

    public int hashCode() {
        return this.number * 31 + Arrays.hashCode(this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OptionNumberRegistry.toString(this.number));
        sb.append(": ");
        sb.append(this.toValueString());
        return sb.toString();
    }

    public String toValueString() {
        if (this.value == null) {
            return "not available";
        }
        switch (OptionNumberRegistry.getFormatByNr(this.number)) {
            case INTEGER: {
                if (this.number == 27 || this.number == 23) {
                    return "\"" + new BlockOption(this.value) + "\"";
                }
                int iValue = this.getIntegerValue();
                if (this.number == 17 || this.number == 12) {
                    return "\"" + MediaTypeRegistry.toString(iValue) + "\"";
                }
                if (this.number == 258) {
                    return "\"" + new NoResponseOption(iValue) + "\"";
                }
                return Long.toString(this.getLongValue());
            }
            case STRING: {
                return "\"" + this.getStringValue() + "\"";
            }
            case EMPTY: {
                return "";
            }
        }
        return "0x" + StringUtil.byteArray2Hex((byte[])this.value);
    }

    Option setValueUnchecked(byte[] value) {
        this.value = value;
        return this;
    }
}

