/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.HorizontalAxesAdjuster;
import org.eclipse.birt.chart.computation.withaxes.IAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.ValueAxesHelper;
import org.eclipse.birt.chart.computation.withaxes.VerticalAxesAdjuster;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.util.CDateTime;

public class AxesAdjuster
implements IAxisAdjuster,
IConstants {
    private AllAxes fAllAxes;
    private ValueAxesHelper fValueAxesHelper;
    private PlotWithAxes fPlotWithAxes;
    private Bounds fPlotBounds;

    public AxesAdjuster(PlotWithAxes plotWithAxes, ValueAxesHelper valueAxesHelper, Bounds boPlot) {
        this.fPlotWithAxes = plotWithAxes;
        this.fValueAxesHelper = valueAxesHelper;
        this.fPlotBounds = boPlot;
        this.fAllAxes = plotWithAxes.getAxes();
    }

    public void adjust() throws ChartException {
        int index = 0;
        if (this.fAllAxes.getPrimaryBase().getIntersectionValue().iType == 1) {
            index = this.fValueAxesHelper.getValueAxes().length - 1;
        }
        if (!this.fAllAxes.areAxesSwapped()) {
            new VerticalAxesAdjuster(this.fValueAxesHelper.getValueAxes(), this.fAllAxes.getPrimaryBase(), this.fPlotWithAxes, this.fPlotBounds).adjust();
            new HorizontalAxesAdjuster(new OneAxis[]{this.fAllAxes.getPrimaryBase()}, this.fValueAxesHelper.getValueAxes()[index], this.fPlotWithAxes, this.fPlotBounds).adjust(false);
        } else {
            new HorizontalAxesAdjuster(this.fValueAxesHelper.getValueAxes(), this.fAllAxes.getPrimaryBase(), this.fPlotWithAxes, this.fPlotBounds).adjust();
            new VerticalAxesAdjuster(new OneAxis[]{this.fAllAxes.getPrimaryBase()}, this.fValueAxesHelper.getValueAxes()[index], this.fPlotWithAxes, this.fPlotBounds).adjust(false);
        }
    }

    static final double getLocationDelta(AutoScale sc, IntersectionValue iv) {
        AxisTickCoordinates da = sc.getTickCordinates();
        if (iv.getType() == 2) {
            return 0.0;
        }
        if (iv.getType() == 1) {
            return 0.0;
        }
        if ((sc.getType() & 0x10) == 16 || sc.isCategoryScale()) {
            double dValue = iv.getValueAsDouble(sc);
            return da.getStep() * dValue;
        }
        if ((sc.getType() & 8) == 8) {
            CDateTime cdtValue = Methods.asDateTime(iv.getValue());
            CDateTime cdt = Methods.asDateTime(sc.getMinimum());
            CDateTime cdtPrev = null;
            int iUnit = Methods.asInteger(sc.getUnit());
            int iStep = Methods.asInteger(sc.getStep());
            int i = 0;
            while (i < da.size()) {
                if (cdt.after((Object)cdtValue)) {
                    if (cdtPrev == null) {
                        return 0.0;
                    }
                    long l1 = cdtPrev.getTimeInMillis();
                    long l2 = cdt.getTimeInMillis();
                    long l = cdtValue.getTimeInMillis();
                    double dUnitSize = da.getStep();
                    double dOffset = dUnitSize / (double)(l2 - l1) * (double)(l - l1);
                    return dUnitSize * (double)(i - 1) + dOffset;
                }
                cdtPrev = cdt;
                cdt = cdt.forward(iUnit, iStep);
                ++i;
            }
            double distance = da.getStep() * (double)da.size();
            double axisDisc = sc.getEnd() - sc.getStart();
            if (da.getStep() > 0.0) {
                if (distance > axisDisc) {
                    distance = axisDisc;
                }
            } else if (distance < axisDisc) {
                distance = axisDisc;
            }
            return distance;
        }
        if ((sc.getType() & 4) == 4) {
            double dValue = iv.getValueAsDouble(sc);
            if (dValue == 0.0) {
                return sc.getStart();
            }
            if (dValue < 0.0) {
                return 0.0;
            }
            double dMinimumLog = Math.log(Methods.asDouble(sc.getMinimum())) / LOG_10;
            double dStepLog = Math.log(Methods.asDouble(sc.getStep())) / LOG_10;
            double dValueLog = Math.log(dValue) / LOG_10;
            return (dValueLog - dMinimumLog) / dStepLog * da.getStep();
        }
        double dValue = iv.getValueAsDouble(sc);
        double dMinimum = Methods.asDouble(sc.getMinimum());
        double dMaximum = Methods.asDouble(sc.getMaximum());
        double[] ea = sc.getEndPoints();
        if (dMaximum == dMinimum) {
            return 0.0;
        }
        return (dValue - dMinimum) / (dMaximum - dMinimum) * (ea[1] - ea[0]);
    }
}

