/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.trans.extend;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.mybatis.Mappers;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.dromara.common.utils.StringUtil;
import org.dromara.core.trans.vo.VO;
import org.dromara.trans.service.impl.SimpleTransService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisFlexSimpleTransDiver
implements SimpleTransService.SimpleTransDiver {
    private static final Logger log = LoggerFactory.getLogger(MybatisFlexSimpleTransDiver.class);

    public List<? extends VO> findByIds(List<? extends Serializable> ids, Class<? extends VO> targetClass, String uniqueField) {
        return this.findByIds(ids, targetClass, uniqueField, null);
    }

    public List<? extends VO> findByIds(List<? extends Serializable> ids, Class<? extends VO> targetClass, String uniqueField, Set<String> targetFields) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(targetClass);
        uniqueField = this.getUniqueField(tableInfo, uniqueField);
        QueryWrapper queryWrapper = this.genWrapper(tableInfo, targetFields, uniqueField);
        queryWrapper.where(this.getQueryColumn(tableInfo, uniqueField).in(ids));
        return this.getMapper(targetClass).selectListByQuery(queryWrapper);
    }

    public VO findById(Serializable id, Class<? extends VO> targetClass, String uniqueField) {
        return this.findById(id, targetClass, uniqueField, null);
    }

    public VO findById(Serializable id, Class<? extends VO> targetClass, String uniqueField, Set<String> targetFields) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(targetClass);
        uniqueField = this.getUniqueField(tableInfo, uniqueField);
        QueryWrapper queryWrapper = this.genWrapper(tableInfo, targetFields, uniqueField);
        queryWrapper.where(this.getQueryColumn(tableInfo, uniqueField).in(new Object[]{id}));
        return (VO)this.getMapper(targetClass).selectOneById(id);
    }

    private String getUniqueField(TableInfo tableInfo, String uniqueField) {
        if (!StringUtil.isEmpty((String)uniqueField)) {
            return uniqueField;
        }
        return this.getKeyProperty(tableInfo);
    }

    private String getKeyProperty(TableInfo tableInfo) {
        List primaryKeyList = tableInfo.getPrimaryKeyList();
        if (primaryKeyList.isEmpty()) {
            throw new IllegalArgumentException(String.format("\u7c7b %s \u4e2d\u6ca1\u6709\u627e\u5230 @Id \u5b9a\u4e49\u7684\u4e3b\u952e\uff0c\u8bf7\u4f7f\u7528 uniqueField \u6307\u5b9a\u4e3b\u952e\u3002", tableInfo.getEntityClass().getName()));
        }
        return ((IdInfo)primaryKeyList.get(0)).getProperty();
    }

    private QueryWrapper genWrapper(TableInfo tableInfo, Set<String> targetFields, String uniqueField) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        if (targetFields != null && !targetFields.isEmpty()) {
            targetFields.add(this.getKeyProperty(tableInfo));
            if (!StringUtil.isEmpty((String)uniqueField)) {
                targetFields.add(uniqueField);
            }
            queryWrapper.select((QueryColumn[])targetFields.stream().map(arg_0 -> ((TableInfo)tableInfo).getColumnByProperty(arg_0)).map(arg_0 -> ((TableInfo)tableInfo).getQueryColumnByProperty(arg_0)).toArray(QueryColumn[]::new));
        }
        return queryWrapper;
    }

    private QueryColumn getQueryColumn(TableInfo tableInfo, String field) {
        String column = tableInfo.getColumnByProperty(field);
        return tableInfo.getQueryColumnByProperty(column);
    }

    public BaseMapper getMapper(Class entity) {
        return Mappers.ofEntityClass((Class)entity);
    }
}

