/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.LineReader;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.SystemUtil;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.setting.GroupedMap;

public class SettingLoader {
    private static final Log log = Log.get();
    private static final char COMMENT_FLAG_PRE = '#';
    private final Charset charset;
    private final boolean isUseVariable;
    private char assignFlag = (char)61;
    private String varRegex = "\\$\\{(.*?)\\}";
    private ValueEditor valueEditor;

    public SettingLoader(Charset charset, boolean isUseVariable) {
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public SettingLoader setVarRegex(String regex) {
        this.varRegex = regex;
        return this;
    }

    public SettingLoader setAssignFlag(char assignFlag) {
        this.assignFlag = assignFlag;
        return this;
    }

    public SettingLoader setValueEditor(ValueEditor valueEditor) {
        this.valueEditor = valueEditor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupedMap load(Resource resource) {
        GroupedMap groupedMap;
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", resource);
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            groupedMap = this.load(settingStream);
        }
        catch (Exception e) {
            GroupedMap groupedMap2;
            try {
                log.error(e, "Load setting error!", new Object[0]);
                groupedMap2 = new GroupedMap();
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(settingStream);
                throw throwable;
            }
            IoUtil.closeQuietly(settingStream);
            return groupedMap2;
        }
        IoUtil.closeQuietly(settingStream);
        return groupedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GroupedMap load(InputStream settingStream) throws IOException {
        GroupedMap groupedMap = new GroupedMap();
        LineReader reader = null;
        try {
            String line;
            reader = new LineReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StrUtil.isBlank(line = StrUtil.trim(line)) || StrUtil.startWith((CharSequence)line, '#')) continue;
                if (StrUtil.isWrap((CharSequence)line, '[', ']')) {
                    group = StrUtil.trim(line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = SplitUtil.split(line, String.valueOf(this.assignFlag), 2, true, false).toArray(new String[0]);
                if (keyValue.length < 2) continue;
                String key = StrUtil.trim(keyValue[0]);
                String value = keyValue[1];
                if (null != this.valueEditor) {
                    value = this.valueEditor.edit(group, key, value);
                }
                if (this.isUseVariable) {
                    value = this.replaceVar(groupedMap, group, value);
                }
                groupedMap.put(group, key, value);
            }
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(reader);
            throw throwable;
        }
        IoUtil.closeQuietly(reader);
        return groupedMap;
    }

    public void store(GroupedMap groupedMap, String absolutePath) {
        this.store(groupedMap, FileUtil.touch(absolutePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(GroupedMap groupedMap, File file) {
        Assert.notNull(file, "File to store must be not null !", new Object[0]);
        log.debug("Store Setting to [{}]...", file.getAbsolutePath());
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(file, this.charset, false);
            this.store(groupedMap, writer);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(writer);
            throw throwable;
        }
        IoUtil.closeQuietly(writer);
    }

    private synchronized void store(GroupedMap groupedMap, PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : groupedMap.entrySet()) {
            writer.println(StrUtil.format("{}{}{}", Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')));
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                writer.println(StrUtil.format("{} {} {}", entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()));
            }
        }
    }

    private String replaceVar(GroupedMap groupedMap, String group, String value) {
        Set vars = ReUtil.findAll(this.varRegex, (CharSequence)value, 0, new HashSet());
        for (String var : vars) {
            List<String> groupAndKey;
            String key = ReUtil.get(this.varRegex, (CharSequence)var, 1);
            if (!StrUtil.isNotBlank(key)) continue;
            String varValue = groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = SplitUtil.split(key, ".", 2, true, false)).size() > 1) {
                varValue = groupedMap.get(groupAndKey.get(0), groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = SystemUtil.get(key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }

    @FunctionalInterface
    public static interface ValueEditor {
        public String edit(String var1, String var2, String var3);
    }
}

