/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer;

import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;

public interface JSONContext {
    public JSON getContextJson();

    public JSONFactory getFactory();

    default public JSONConfig config() {
        return this.getFactory().getConfig();
    }

    default public JSONObject getOrCreateObj() {
        JSON contextJson = this.getContextJson();
        if (contextJson instanceof JSONObject) {
            return (JSONObject)contextJson;
        }
        return this.getFactory().ofObj();
    }

    default public JSONArray getOrCreateArray() {
        JSON contextJson = this.getContextJson();
        if (contextJson instanceof JSONArray) {
            return (JSONArray)contextJson;
        }
        return this.getFactory().ofArray();
    }

    default public JSONPrimitive getOrCreatePrimitive(Object value) {
        JSON contextJson = this.getContextJson();
        if (contextJson instanceof JSONPrimitive) {
            return ((JSONPrimitive)contextJson).setValue(value);
        }
        return this.getFactory().ofPrimitive(value);
    }
}

