/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.lang.reflect.Type;
import java.util.List;
import org.dromara.hutool.core.lang.getter.TypeGetter;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.support.InternalJSONUtil;

public interface JSONGetter<K>
extends TypeGetter<K> {
    public JSONFactory getFactory();

    default public boolean isNull(K key) {
        return ObjUtil.isNull(this.getJSON(key));
    }

    default public String getStrEscaped(K key) {
        return this.getStrEscaped(key, null);
    }

    default public String getStrEscaped(K key, String defaultValue) {
        return InternalJSONUtil.escape(this.getStr(key, defaultValue));
    }

    default public JSONArray getJSONArray(K key) {
        JSON json = this.getJSON(key);
        if (null == json) {
            return null;
        }
        if (json instanceof JSONObject) {
            return this.getFactory().parseArray(json);
        }
        return json.asJSONArray();
    }

    default public JSONObject getJSONObject(K key) {
        JSON json = this.getJSON(key);
        if (null == json) {
            return null;
        }
        return json.asJSONObject();
    }

    default public <T> List<T> getBeanList(K key, Class<T> beanType) {
        JSONArray jsonArray = this.getJSONArray(key);
        return null == jsonArray ? null : jsonArray.toList(beanType);
    }

    @Override
    default public Object getObj(K key, Object defaultValue) {
        JSON json = this.getJSON(key);
        Object value = json instanceof JSONPrimitive ? ((JSONPrimitive)json).getValue() : json;
        return ObjUtil.defaultIfNull(value, defaultValue);
    }

    @Override
    default public <T> T get(K key, Type type, T defaultValue) {
        JSON value = this.getJSON(key);
        if (ObjUtil.isNull(value)) {
            return defaultValue;
        }
        return ObjUtil.defaultIfNull(value.toBean(type), defaultValue);
    }

    public JSON getJSON(K var1);
}

