/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.undertow;

import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.dromara.hutool.http.server.engine.undertow.UndertowExchangeBase;
import org.dromara.hutool.http.server.handler.ServerResponse;

public class UndertowResponse
extends UndertowExchangeBase
implements ServerResponse {
    private Charset charset = DEFAULT_CHARSET;

    public UndertowResponse(HttpServerExchange exchange) {
        super(exchange);
    }

    @Override
    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    @Override
    public ServerResponse setStatus(int statusCode) {
        this.exchange.setStatusCode(statusCode);
        return this;
    }

    @Override
    public ServerResponse setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public ServerResponse addHeader(String header, String value) {
        this.exchange.getResponseHeaders().add(new HttpString(header), value);
        return this;
    }

    @Override
    public ServerResponse setHeader(String header, String value) {
        this.exchange.getResponseHeaders().put(new HttpString(header), value);
        return this;
    }

    @Override
    public ServerResponse setHeader(String header, List<String> value) {
        this.exchange.getResponseHeaders().putAll(new HttpString(header), value);
        return this;
    }

    public Sender getSender() {
        return this.exchange.getResponseSender();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.exchange.getOutputStream();
    }

    @Override
    public ServerResponse write(byte[] data) {
        this.getSender().send(ByteBuffer.wrap(data));
        return this;
    }
}

