/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import javax.net.ssl.SSLContext;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.http.server.ServerConfig;
import org.dromara.hutool.http.server.engine.AbstractServerEngine;
import org.dromara.hutool.http.server.engine.undertow.UndertowRequest;
import org.dromara.hutool.http.server.engine.undertow.UndertowResponse;

public class UndertowEngine
extends AbstractServerEngine {
    private Undertow undertow;

    public UndertowEngine() {
        Assert.notNull(Undertow.class);
    }

    @Override
    public void start() {
        this.initEngine();
        this.undertow.start();
    }

    public Undertow getRawEngine() {
        return this.undertow;
    }

    @Override
    protected void reset() {
        if (null != this.undertow) {
            this.undertow.stop();
            this.undertow = null;
        }
    }

    @Override
    protected void initEngine() {
        SSLContext sslContext;
        int maxThreads;
        int coreThreads;
        long idleTimeout;
        long maxBodySize;
        if (null != this.undertow) {
            return;
        }
        Undertow.Builder builder = Undertow.builder().setHandler(exchange -> this.handler.handle(new UndertowRequest(exchange), new UndertowResponse(exchange)));
        ServerConfig config = this.config;
        int maxHeaderSize = config.getMaxHeaderSize();
        if (maxHeaderSize > 0) {
            builder.setServerOption(UndertowOptions.MAX_HEADER_SIZE, (Object)maxHeaderSize);
        }
        if ((maxBodySize = config.getMaxBodySize()) > 0L) {
            builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)maxBodySize);
        }
        if ((idleTimeout = config.getIdleTimeout()) > 0L) {
            builder.setServerOption(UndertowOptions.IDLE_TIMEOUT, (Object)((int)idleTimeout));
        }
        if ((coreThreads = config.getCoreThreads()) > 0) {
            builder.setIoThreads(coreThreads);
        }
        if ((maxThreads = config.getMaxThreads()) > 0) {
            builder.setWorkerThreads(maxThreads);
        }
        if (null != (sslContext = config.getSslContext())) {
            builder.addHttpsListener(config.getPort(), config.getHost(), sslContext);
        } else {
            builder.addHttpListener(config.getPort(), config.getHost());
        }
        this.undertow = builder.build();
    }
}

